/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoAlteracaoSalarial;
import br.com.fiorilli.sip.persistence.entity.HistsalSalsPK;
import br.com.fiorilli.sip.persistence.entity.Salario;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="HISTSAL_SALS")
@Audited
public class SalarioAlterado
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistsalSalsPK histsalSalsPK;
    @Column(name="VALOR_ANTERIOR")
    private BigDecimal valorAnterior;
    @Column(name="VALOR_ATUAL")
    private BigDecimal valorAtual;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salario;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODHISTSAL", referencedColumnName="CODHISTSAL", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private HistoricoAlteracaoSalarial historicoAlteracaoSalarial;

    public SalarioAlterado() {
    }

    public SalarioAlterado(HistsalSalsPK histsalSalsPK) {
        this.histsalSalsPK = histsalSalsPK;
    }

    public HistsalSalsPK getHistsalSalsPK() {
        return this.histsalSalsPK;
    }

    public void setHistsalSalsPK(HistsalSalsPK histsalSalsPK) {
        this.histsalSalsPK = histsalSalsPK;
    }

    public BigDecimal getValorAnterior() {
        return this.valorAnterior;
    }

    public void setValorAnterior(BigDecimal valorAnterior) {
        this.valorAnterior = valorAnterior;
    }

    public BigDecimal getValorAtual() {
        return this.valorAtual;
    }

    public void setValorAtual(BigDecimal valorAtual) {
        this.valorAtual = valorAtual;
    }

    public Salario getSalario() {
        return this.salario;
    }

    public void setSalario(Salario value) {
        this.salario = value;
        if (value != null) {
            if (this.getHistsalSalsPK() == null) {
                this.setHistsalSalsPK(new HistsalSalsPK());
            }
            this.getHistsalSalsPK().setEntidade(value.getSalarioPK().getEntidade());
            this.getHistsalSalsPK().setRefsal(value.getSalarioPK().getCodigo());
        } else if (this.getHistsalSalsPK() != null) {
            this.getHistsalSalsPK().setEntidade(null);
            this.getHistsalSalsPK().setRefsal(null);
        }
    }

    public HistoricoAlteracaoSalarial getHistoricoAlteracaoSalarial() {
        return this.historicoAlteracaoSalarial;
    }

    public void setHistoricoAlteracaoSalarial(HistoricoAlteracaoSalarial value) {
        this.historicoAlteracaoSalarial = value;
        if (value != null) {
            if (this.getHistsalSalsPK() == null) {
                this.setHistsalSalsPK(new HistsalSalsPK());
            }
            this.getHistsalSalsPK().setEntidade(value.getHistsalPK().getEntidade());
            this.getHistsalSalsPK().setCodhistsal(value.getHistsalPK().getCodhistsal());
        } else if (this.getHistsalSalsPK() != null) {
            this.getHistsalSalsPK().setEntidade(null);
            this.getHistsalSalsPK().setCodhistsal(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.histsalSalsPK != null ? this.histsalSalsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SalarioAlterado)) {
            return false;
        }
        SalarioAlterado other = (SalarioAlterado)object;
        return (this.histsalSalsPK != null || other.histsalSalsPK == null) && (this.histsalSalsPK == null || this.histsalSalsPK.equals(other.histsalSalsPK));
    }

    public String toString() {
        return "entity.HistsalSals[ histsalSalsPK=" + this.histsalSalsPK + " ]";
    }
}

