/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CargoSalario;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalario;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalarioInicial;
import br.com.fiorilli.sip.persistence.entity.SalarioDocumentoCriacao;
import br.com.fiorilli.sip.persistence.entity.SalarioDocumentoExtincao;
import br.com.fiorilli.sip.persistence.entity.SalarioPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Salario.class, autoFilter=true)
@Entity
@Table(name="SALARIOS")
@Audited
public class Salario
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT s FROM Salario s where s.salarioPK.entidade = :entidadeId";
    public static final String FIND_FOR_FILTER = "SELECT s FROM Salario s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') AND s.salarioPK.entidade = :entidadeCodigo ORDER BY s.nome";
    @EmbeddedId
    protected SalarioPK salarioPK;
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @FilterConfig(label="Valor", order=3)
    @Column(name="VALOR")
    private BigDecimal valor;
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private int id;
    @Embedded
    private SalarioDocumentoCriacao documentoCriacao;
    @Embedded
    private SalarioDocumentoExtincao documentoExtincao;
    @Size(max=10)
    @Column(name="CLASSE")
    private String classe;
    @Size(max=10)
    @Column(name="NIVEL")
    private String nivel;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="salario")
    private List<CargoSalario> cargoSalarios;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="salario")
    private List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicial;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="salarioAnterior")
    private List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicialAnterior;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="salario")
    private List<HistoricoTrabalhadorSalario> historicoTrabSalario;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="salarioAnterior")
    private List<HistoricoTrabalhadorSalario> historicoTrabSalarioAnterior;

    public Salario() {
    }

    public Salario(SalarioPK salarioPK) {
        this.salarioPK = salarioPK;
    }

    public Salario(SalarioPK salarioPK, int id) {
        this.salarioPK = salarioPK;
        this.id = id;
    }

    public Salario(String entidade, String codigo) {
        this.salarioPK = new SalarioPK(entidade, codigo);
    }

    public SalarioPK getSalarioPK() {
        return this.salarioPK;
    }

    public void setsalarioPK(SalarioPK salarioPK) {
        this.salarioPK = salarioPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getClasse() {
        return this.classe;
    }

    public void setClasse(String classe) {
        this.classe = classe;
    }

    public String getNivel() {
        return this.nivel;
    }

    public void setNivel(String nivel) {
        this.nivel = nivel;
    }

    public List<HistoricoTrabalhadorSalarioInicial> getHistoricoTrabSalarioInicial() {
        return this.historicoTrabSalarioInicial;
    }

    public void setHistoricoTrabSalarioInicial(List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicial) {
        this.historicoTrabSalarioInicial = historicoTrabSalarioInicial;
    }

    public List<HistoricoTrabalhadorSalarioInicial> getHistoricoTrabSalarioInicialAnterior() {
        return this.historicoTrabSalarioInicialAnterior;
    }

    public void setHistoricoTrabSalarioInicialAnterior(List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicialAnterior) {
        this.historicoTrabSalarioInicialAnterior = historicoTrabSalarioInicialAnterior;
    }

    public List<HistoricoTrabalhadorSalario> getHistoricoTrabSalario() {
        return this.historicoTrabSalario;
    }

    public void setHistoricoTrabSalario(List<HistoricoTrabalhadorSalario> historicoTrabSalario) {
        this.historicoTrabSalario = historicoTrabSalario;
    }

    public List<HistoricoTrabalhadorSalario> getHistoricoTrabSalarioAnterior() {
        return this.historicoTrabSalarioAnterior;
    }

    public void setHistoricoTrabSalarioAnterior(List<HistoricoTrabalhadorSalario> historicoTrabSalarioAnterior) {
        this.historicoTrabSalarioAnterior = historicoTrabSalarioAnterior;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.salarioPK != null ? this.salarioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Salario)) {
            return false;
        }
        Salario other = (Salario)object;
        return (this.salarioPK != null || other.salarioPK == null) && (this.salarioPK == null || this.salarioPK.equals(other.salarioPK));
    }

    public String toString() {
        return "entity.Salarios[ salarioPK=" + this.salarioPK + " ]";
    }

    @Override
    public String getHashId() {
        return Integer.toString(this.hashCode());
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }

    public SalarioDocumentoCriacao getDocumentoCriacao() {
        if (this.documentoCriacao == null) {
            this.documentoCriacao = new SalarioDocumentoCriacao();
        }
        return this.documentoCriacao;
    }

    public void setDocumentoCriacao(SalarioDocumentoCriacao documentoCriacao) {
        this.documentoCriacao = documentoCriacao;
    }

    public SalarioDocumentoExtincao getDocumentoExtincao() {
        if (this.documentoExtincao == null) {
            this.documentoExtincao = new SalarioDocumentoExtincao();
        }
        return this.documentoExtincao;
    }

    public void setDocumentoExtincao(SalarioDocumentoExtincao documentoExtincao) {
        this.documentoExtincao = documentoExtincao;
    }
}

