/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="RPPS_HISTORICO_PREVIDENCIARIO")
@Audited
public class RppsHistoricoPrecidenciario
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_RPPS_HIST_PREV";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Column(name="MES")
    private String mes;
    @Column(name="TOTALPROVENTOS")
    private Double totalProventos;
    @Column(name="SALARIOMENSAL")
    private Double salarioMensal;
    @Column(name="SALARIODECIMOTERCEIRO")
    private Double salario13;
    @Column(name="ALIQUOTASEGURADO")
    private Double aliquotaSegurado;
    @Column(name="CONTRIBUICAOMENSAL")
    private Double contribuicaoMensal;
    @Column(name="CONTRIBUICAODECIMOTERCEIRO")
    private Double contribuicao13;
    @Column(name="TAXAPATRONAL")
    private Double taxaPatronal;
    @Column(name="PATRONALMENSAL")
    private Double patronalMensal;
    @Column(name="PATRONALDECIMOTERCEIRO")
    private Double patronal13;
    @Column(name="TAXAPATRONALCOMPLEMENTAR")
    private Double taxaPatronalComplementar;
    @Column(name="PATRONALCOMPLMENSAL")
    private Double patronalComplementoMensal;
    @Column(name="PATRONALCOMPLDECIMOTERCEIRO")
    private Double patronalComplemento13;
    @Column(name="DEDUCAOMATERNIDADE")
    private Double deducaoMaternidade;
    @Column(name="DEDUCAOSALARIOFAMILIA")
    private Double deducaoSalarioFamilia;
    @Column(name="DEDUCAOOUTRAS")
    private Double deducaoOutras;
    @Column(name="TOTAL_PATRONAL", updatable=false, insertable=false)
    private Double totalPatronal;
    @Column(name="TEMPO_BRUTO")
    private Short tempoBruto;
    @Column(name="FALTAS")
    private Short faltas;
    @Column(name="LICENCAS")
    private Short licencas;
    @Column(name="LICENCAS_SEM_VENCIMENTOS")
    private Short licencasSemVencimento;
    @Column(name="SUSPENSOES")
    private Short suspensoes;
    @Column(name="DISPONIBILIDADE")
    private Short disponibilidade;
    @Column(name="OUTROS_ABATIMENTOS")
    private Short outrosAbatimentos;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public RppsHistoricoPrecidenciario() {
    }

    public RppsHistoricoPrecidenciario(Integer id) {
        this.id = id;
    }

    public RppsHistoricoPrecidenciario(Builder b) {
        this.entidade = b.entidade;
        this.registro = b.registro;
        this.ano = b.ano;
        this.mes = b.mes;
        this.contribuicaoMensal = b.contribuicaoMensal;
        this.patronalMensal = b.patronalMensal;
        this.tempoBruto = b.tempoBruto;
        this.faltas = b.faltas;
        this.licencas = b.licencas;
        this.licencasSemVencimento = b.licencasSemVencimento;
        this.suspensoes = b.suspensoes;
        this.disponibilidade = b.disponibilidade;
        this.outrosAbatimentos = b.outros;
    }

    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalproventos) {
        this.totalProventos = totalproventos;
    }

    public Double getSalarioMensal() {
        return this.salarioMensal;
    }

    public void setSalarioMensal(Double salariomensal) {
        this.salarioMensal = salariomensal;
    }

    public Double getSalario13() {
        return this.salario13;
    }

    public void setSalario13(Double salariodecimoterceiro) {
        this.salario13 = salariodecimoterceiro;
    }

    public Double getAliquotaSegurado() {
        return this.aliquotaSegurado;
    }

    public void setAliquotaSegurado(Double aliquotasegurado) {
        this.aliquotaSegurado = aliquotasegurado;
    }

    public Double getContribuicaoMensal() {
        return this.contribuicaoMensal;
    }

    public void setContribuicaoMensal(Double contribuicaomensal) {
        this.contribuicaoMensal = contribuicaomensal;
    }

    public Double getContribuicao13() {
        return this.contribuicao13;
    }

    public void setContribuicao13(Double contribuicaodecimoterceiro) {
        this.contribuicao13 = contribuicaodecimoterceiro;
    }

    public Double getTaxaPatronal() {
        return this.taxaPatronal;
    }

    public void setTaxaPatronal(Double taxapatronal) {
        this.taxaPatronal = taxapatronal;
    }

    public Double getPatronalMensal() {
        return this.patronalMensal;
    }

    public void setPatronalMensal(Double patronalmensal) {
        this.patronalMensal = patronalmensal;
    }

    public Double getPatronal13() {
        return this.patronal13;
    }

    public void setPatronal13(Double patronaldecimoterceiro) {
        this.patronal13 = patronaldecimoterceiro;
    }

    public Double getTaxaPatronalComplementar() {
        return this.taxaPatronalComplementar;
    }

    public void setTaxaPatronalComplementar(Double taxapatronalcomplementar) {
        this.taxaPatronalComplementar = taxapatronalcomplementar;
    }

    public Double getPatronalComplementoMensal() {
        return this.patronalComplementoMensal;
    }

    public void setPatronalComplementoMensal(Double patronalcomplmensal) {
        this.patronalComplementoMensal = patronalcomplmensal;
    }

    public Double getPatronalComplemento13() {
        return this.patronalComplemento13;
    }

    public void setPatronalComplemento13(Double patronalcompldecimoterceiro) {
        this.patronalComplemento13 = patronalcompldecimoterceiro;
    }

    public Double getDeducaoMaternidade() {
        return this.deducaoMaternidade;
    }

    public void setDeducaoMaternidade(Double deducaomaternidade) {
        this.deducaoMaternidade = deducaomaternidade;
    }

    public Double getDeducaoSalarioFamilia() {
        return this.deducaoSalarioFamilia;
    }

    public void setDeducaoSalarioFamilia(Double deducaosalariofamilia) {
        this.deducaoSalarioFamilia = deducaosalariofamilia;
    }

    public Double getDeducaoOutras() {
        return this.deducaoOutras;
    }

    public void setDeducaoOutras(Double deducaooutras) {
        this.deducaoOutras = deducaooutras;
    }

    public Double getTotalPatronal() {
        return this.totalPatronal;
    }

    public void setTotalPatronal(Double totalPatronal) {
        this.totalPatronal = totalPatronal;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidade = null;
            this.registro = null;
        }
        this.trabalhador = trabalhador;
    }

    public Short getTempoBruto() {
        return this.tempoBruto;
    }

    public void setTempoBruto(Short tempoBruto) {
        this.tempoBruto = tempoBruto;
    }

    public Short getFaltas() {
        return this.faltas;
    }

    public void setFaltas(Short faltas) {
        this.faltas = faltas;
    }

    public Short getLicencas() {
        return this.licencas;
    }

    public void setLicencas(Short licencas) {
        this.licencas = licencas;
    }

    public Short getLicencasSemVencimento() {
        return this.licencasSemVencimento;
    }

    public void setLicencasSemVencimento(Short licencasSemVencimento) {
        this.licencasSemVencimento = licencasSemVencimento;
    }

    public Short getSuspensoes() {
        return this.suspensoes;
    }

    public void setSuspensoes(Short suspensoes) {
        this.suspensoes = suspensoes;
    }

    public Short getDisponibilidade() {
        return this.disponibilidade;
    }

    public void setDisponibilidade(Short disponibilidade) {
        this.disponibilidade = disponibilidade;
    }

    public Short getOutrosAbatimentos() {
        return this.outrosAbatimentos;
    }

    public void setOutrosAbatimentos(Short outrosAbatimentos) {
        this.outrosAbatimentos = outrosAbatimentos;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public MesNomeEnum getMes() {
        return MesNomeEnum.of(this.mes);
    }

    public void setMes(MesNomeEnum mes) {
        this.mes = mes != null ? mes.getCodigo() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RppsHistoricoPrecidenciario other = (RppsHistoricoPrecidenciario)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "RppsHistoricoPrecidenciario [id=" + this.id + ", entidade=" + this.entidade + ", registro=" + this.registro + ", ano=" + this.ano + ", mes=" + this.mes + "]";
    }

    public boolean isTrabalhadorAndMesAndAnoEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RppsHistoricoPrecidenciario other = (RppsHistoricoPrecidenciario)obj;
        if (this.ano == null ? other.ano != null : !this.ano.equals(other.ano)) {
            return false;
        }
        if (this.entidade == null ? other.entidade != null : !this.entidade.equals(other.entidade)) {
            return false;
        }
        if (this.mes == null ? other.mes != null : !this.mes.equals(other.mes)) {
            return false;
        }
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public static class Builder {
        private final short ZERO = 0;
        private final String entidade;
        private final String registro;
        private final String ano;
        private final String mes;
        private Double contribuicaoMensal = 0.0;
        private Double patronalMensal = 0.0;
        private Short tempoBruto = 0;
        private Short faltas = 0;
        private Short licencas = 0;
        private Short licencasSemVencimento = 0;
        private Short suspensoes = 0;
        private Short disponibilidade = 0;
        private Short outros = 0;

        public Builder(String enitdade, String registro, String ano, String mes) {
            this.entidade = enitdade;
            this.registro = registro;
            this.ano = ano;
            this.mes = mes;
        }

        public RppsHistoricoPrecidenciario build() {
            return new RppsHistoricoPrecidenciario(this);
        }

        public Builder contribuicaoMensal(Double contribuicaoMensal) {
            this.contribuicaoMensal = contribuicaoMensal;
            return this;
        }

        public Builder patronalMensal(Double patronalMensal) {
            this.patronalMensal = patronalMensal;
            return this;
        }

        public Builder tempoBruto(Short tempoBruto) {
            this.tempoBruto = tempoBruto;
            return this;
        }

        public Builder faltas(Short faltas) {
            this.faltas = faltas;
            return this;
        }

        public Builder licencas(Short licencas) {
            this.licencas = licencas;
            return this;
        }

        public Builder licencasSemVencimento(Short licencasSemVencimento) {
            this.licencasSemVencimento = licencasSemVencimento;
            return this;
        }

        public Builder suspensoes(Short suspensoes) {
            this.suspensoes = suspensoes;
            return this;
        }

        public Builder disponibilidade(Short disponibilidade) {
            this.disponibilidade = disponibilidade;
            return this;
        }

        public Builder outros(Short outros) {
            this.outros = outros;
            return this;
        }
    }
}

