/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="RESPONSAVEL")
@Audited
public class Responsavel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ENTIDADE = "select r FROM Responsavel r WHERE r.entidade.codigo = :entidadeCodigo   and ((current_date between r.dataInicio and coalesce(r.dataTermino, current_date)) or (r.dataInicio is null))";
    public static final String GENERATOR = "GEN_RESPONSAVEL";
    @Id
    @Column(name="PK")
    private Integer pk;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=18)
    @Column(name="ID")
    private String identificador;
    @Column(name="TIPOID")
    private String tipoIdentificador;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=60)
    @Column(name="CONTATO")
    private String contato;
    @Embedded
    private Endereco endereco;
    @Size(max=2)
    @Column(name="DDD")
    private String ddd;
    @Size(max=11)
    @Column(name="FONE")
    private String fone;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Size(max=15)
    @Column(name="RG")
    private String rg;
    @Size(max=8)
    @Column(name="RG_ORGAO_EMISSOR")
    private String rgOrgaoEmissor;
    @Column(name="DTNASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Column(name="ULTIMA_NOTIFICACAO_SIPWEB")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ultimaNotificacaoSipweb;
    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Column(name="DATA_TERMINO")
    @Temporal(value=TemporalType.DATE)
    private Date dataTermino;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;

    public static Responsavel createNoNull(String entidadeCodigo) {
        Responsavel responsavel = new Responsavel();
        responsavel.entidadeCodigo = entidadeCodigo;
        responsavel.endereco = new Endereco();
        return responsavel;
    }

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public Responsavel() {
    }

    public Responsavel(Integer pk) {
        this.pk = pk;
    }

    public Integer getPk() {
        return this.pk;
    }

    public void setPk(Integer pk) {
        this.pk = pk;
    }

    public IdentificadorTipo getTipoIdentificador() {
        return IdentificadorTipo.get(this.tipoIdentificador);
    }

    public void setTipoIdentificador(IdentificadorTipo tipoid) {
        this.tipoIdentificador = tipoid.getCodigo();
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getDdd() {
        return this.ddd;
    }

    public void setDdd(String ddd) {
        this.ddd = ddd;
    }

    public String getFone() {
        return this.fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dtnascimento) {
        this.dataNascimento = dtnascimento;
    }

    public Date getUltimaNotificacaoSipweb() {
        return this.ultimaNotificacaoSipweb;
    }

    public void setUltimaNotificacaoSipweb(Date ultimaNotificacaoSipweb) {
        this.ultimaNotificacaoSipweb = ultimaNotificacaoSipweb;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Entidade getEntidade() {
        if (this.entidade == null) {
            this.entidade = new Entidade();
        }
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Responsavel other = (Responsavel)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public String toString() {
        return "Responsavel [pk=" + this.pk + "]";
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getRgOrgaoEmissor() {
        return this.rgOrgaoEmissor;
    }

    public void setRgOrgaoEmissor(String rgOrgaoEmissor) {
        this.rgOrgaoEmissor = rgOrgaoEmissor;
    }
}

