/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="REPREENSAO")
@Audited
public class Repreensao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_REPREENSAO";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1024)
    @Column(name="REPREENSAO")
    private String repreensao;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESAREPREENSOR")
    private String entidadeRepreensor;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTROREPREENSOR")
    private String registroRepreensor;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeRepreendido;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registroRepreendido;
    @Basic(optional=false)
    @NotNull
    @JoinColumns(value={@JoinColumn(name="EMPRESAREPREENSOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTROREPREENSOR", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorRepreensor;
    @Basic(optional=false)
    @NotNull
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorRepreendido;

    public Repreensao() {
    }

    public String getEntidadeRepreensor() {
        return this.entidadeRepreensor;
    }

    public void setEntidadeRepreensor(String entidadeRepreensor) {
        this.entidadeRepreensor = entidadeRepreensor;
    }

    public String getRegistroRepreensor() {
        return this.registroRepreensor;
    }

    public void setRegistroRepreensor(String registroRepreensor) {
        this.registroRepreensor = registroRepreensor;
    }

    public String getEntidadeRepreendido() {
        return this.entidadeRepreendido;
    }

    public void setEntidadeRepreendido(String entidadeRepreendido) {
        this.entidadeRepreendido = entidadeRepreendido;
    }

    public String getRegistroRepreendido() {
        return this.registroRepreendido;
    }

    public void setRegistroRepreendido(String registroRepreendido) {
        this.registroRepreendido = registroRepreendido;
    }

    public Repreensao(Integer codigo) {
        this.codigo = codigo;
    }

    public Repreensao(Integer codigo, String repreensao) {
        this.codigo = codigo;
        this.repreensao = repreensao;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public String getRepreensao() {
        return this.repreensao;
    }

    public void setRepreensao(String repreensao) {
        this.repreensao = repreensao;
    }

    public Trabalhador getTrabalhadorRepreensor() {
        return this.trabalhadorRepreensor;
    }

    public void setTrabalhadorRepreensor(Trabalhador trabalhador) {
        this.trabalhadorRepreensor = trabalhador;
        if (trabalhador != null) {
            this.entidadeRepreensor = trabalhador.getTrabalhadorPK().getEntidade();
            this.registroRepreensor = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidadeRepreensor = null;
            this.registroRepreensor = null;
        }
    }

    public Trabalhador getTrabalhadorRepreendido() {
        return this.trabalhadorRepreendido;
    }

    public void setTrabalhadorRepreendido(Trabalhador trabalhador) {
        this.trabalhadorRepreendido = trabalhador;
        if (trabalhador != null) {
            this.entidadeRepreendido = trabalhador.getTrabalhadorPK().getEntidade();
            this.registroRepreendido = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidadeRepreendido = null;
            this.registroRepreendido = null;
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Repreensao)) {
            return false;
        }
        Repreensao other = (Repreensao)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Repreensao[ codigo=" + this.codigo + " ]";
    }
}

