/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.RepMarca;
import br.com.fiorilli.sip.persistence.entity.RepTipoModelo;
import java.util.Arrays;
import java.util.List;

public enum RepModelo {
    IDX(RepMarca.CONTROL_ID, "iDX", RepTipoModelo.RELOGIO),
    PRISMA_SF(RepMarca.HENRY, "Prisma Super F\u00e1cil", RepTipoModelo.RELOGIO),
    PRIMME_SF(RepMarca.HENRY, "Primme SF Ponto", RepTipoModelo.RELOGIO),
    PRIMME_ACESSO(RepMarca.HENRY, "Primme Acesso", RepTipoModelo.RELOGIO),
    HEXA(RepMarca.HENRY, "Hexa", RepTipoModelo.RELOGIO),
    INNER(RepMarca.TOPDATA, "Inner", RepTipoModelo.RELOGIO),
    LUMEN_ADVANCE(RepMarca.HENRY, "Lumen Advance", RepTipoModelo.CATRACA),
    KURUMIN_REP3(RepMarca.PROVEU, "Kurumin Rep3", RepTipoModelo.RELOGIO),
    IDCLASS(RepMarca.CONTROL_ID, "iDClass", RepTipoModelo.RELOGIO),
    PROX_S(RepMarca.RWTECH, "PROX-S", RepTipoModelo.RELOGIO),
    BIOPROX_S(RepMarca.RWTECH, "BIOPROX-S", RepTipoModelo.RELOGIO),
    BIOPROX_C(RepMarca.RWTECH, "BIOPROX-C", RepTipoModelo.RELOGIO),
    BIOPROX_BS(RepMarca.RWTECH, "BIOPROX-BS", RepTipoModelo.RELOGIO),
    BIOPROX_BC(RepMarca.RWTECH, "BIOPROX-BC", RepTipoModelo.RELOGIO),
    BIO_MBC(RepMarca.RWTECH, "BIO-MBC", RepTipoModelo.RELOGIO),
    E1(RepMarca.EVO, "E1", RepTipoModelo.RELOGIO),
    E2(RepMarca.EVO, "E2", RepTipoModelo.RELOGIO),
    E3(RepMarca.EVO, "E3", RepTipoModelo.RELOGIO),
    E4(RepMarca.EVO, "E4", RepTipoModelo.RELOGIO),
    E5(RepMarca.EVO, "E5", RepTipoModelo.RELOGIO),
    E6(RepMarca.EVO, "E6", RepTipoModelo.RELOGIO),
    E7(RepMarca.EVO, "E7", RepTipoModelo.RELOGIO),
    E8(RepMarca.EVO, "E8", RepTipoModelo.RELOGIO),
    E9(RepMarca.EVO, "E9", RepTipoModelo.RELOGIO),
    E10(RepMarca.EVO, "E10", RepTipoModelo.RELOGIO);

    private final RepMarca marca;
    private final String descricao;
    private final RepTipoModelo tipoModelo;

    private RepModelo(RepMarca marca, String descricao, RepTipoModelo tipoModelo) {
        this.marca = marca;
        this.descricao = descricao;
        this.tipoModelo = tipoModelo;
    }

    public RepMarca getMarca() {
        return this.marca;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public RepTipoModelo getTipoModelo() {
        return this.tipoModelo;
    }

    public boolean isHexa() {
        return this == HEXA;
    }

    public boolean isPrimmeAcesso() {
        return this == PRIMME_ACESSO;
    }

    public boolean isPrimmeSf() {
        return this == PRIMME_SF;
    }

    public boolean isPrismaSf() {
        return this == PRISMA_SF;
    }

    public List<RepModelo> getRelogios() {
        List<RepModelo> relogios = Arrays.asList(RepModelo.values());
        for (RepModelo modelo : RepModelo.values()) {
            if (modelo.getTipoModelo() == RepTipoModelo.RELOGIO) continue;
            relogios.remove((Object)modelo);
        }
        return relogios;
    }

    public List<RepModelo> getCatacras() {
        List<RepModelo> catracas = Arrays.asList(RepModelo.values());
        for (RepModelo modelo : RepModelo.values()) {
            if (modelo.getTipoModelo() == RepTipoModelo.CATRACA) continue;
            catracas.remove((Object)modelo);
        }
        return catracas;
    }
}

