/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.RepModelo;
import br.com.fiorilli.sip.persistence.entity.RepTipoModelo;
import java.util.LinkedList;
import java.util.List;

public enum RepMarca {
    CONTROL_ID("Control Id"),
    HENRY("Henry"),
    TOPDATA("TOPData"),
    PROVEU("Proveu"),
    RWTECH("RWTECH"),
    EVO("EVO");

    private final String descricao;

    private RepMarca(String descricao) {
        this.descricao = descricao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public boolean isControlID() {
        return this == CONTROL_ID;
    }

    public boolean isHenry() {
        return this == HENRY;
    }

    public boolean isTopdata() {
        return this == TOPDATA;
    }

    public boolean isProveu() {
        return this == PROVEU;
    }

    public boolean isRWTECH() {
        return this == RWTECH;
    }

    public List<RepModelo> getModelos() {
        LinkedList<RepModelo> list = new LinkedList<RepModelo>();
        for (RepModelo m : RepModelo.values()) {
            if (m.getMarca() != this) continue;
            list.add(m);
        }
        return list;
    }

    public List<RepModelo> getModelosRelogios() {
        LinkedList<RepModelo> list = new LinkedList<RepModelo>();
        for (RepModelo m : RepModelo.values()) {
            if (m.getMarca() != this || m.getTipoModelo() != RepTipoModelo.RELOGIO) continue;
            list.add(m);
        }
        return list;
    }
}

