/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.RepMarca;
import br.com.fiorilli.sip.persistence.entity.RepModelo;
import br.com.fiorilli.sip.persistence.entity.RepTipo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="REP_CONFIG")
@FilterConfigType(autoFilter=true)
@Audited
public class RepConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_REP_CONFIG";
    public static final String QUERY_ENABLED_BY_ENTIDADE_AND_NUMERO_REP = "SELECT r FROM RepConfig r WHERE r.entidadeCodigo = :entidadeCodigo AND r.numeroDoRep = :numeroRep AND r.habilitado = true ";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @FilterConfig(label="Descri\u00e7\u00e3o", condition=FilterCondition.COMECE, inputType=FilterInputType.TEXT)
    @Size(max=60)
    @Column(name="DESCRICAO")
    private String descricao;
    @FilterConfig(label="Marca", condition=FilterCondition.IGUAL, inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=RepMarca.class, enumId="ordinal", itemLabel="descricao")
    @Enumerated
    @Column(name="MARCA")
    private RepMarca marca;
    @Enumerated
    @Column(name="MODELO")
    private RepModelo modelo;
    @Column(name="ENDERECO")
    @Size(max=60)
    private String endereco;
    @Column(name="PORTA")
    private Integer porta;
    @Size(max=60)
    @Column(name="LOGIN")
    private String login;
    @Size(max=64)
    @Column(name="SENHA")
    private String senha;
    @Column(name="SEGUNDO")
    private Integer segundo = 0;
    @Column(name="CADA_SEGUNDO")
    @Type(type="BooleanTypeSip")
    private Boolean cadaSegundo;
    @Column(name="MINUTO")
    private Integer minuto = 0;
    @Column(name="CADA_MINUTO")
    @Type(type="BooleanTypeSip")
    private Boolean cadaMinuto;
    @Column(name="HORA")
    private Integer hora = 0;
    @Type(type="BooleanTypeSip")
    @Column(name="CADA_HORA")
    private Boolean cadaHora;
    @Column(name="DIA_DA_SEMANA")
    private Integer diaDaSemana;
    @Type(type="BooleanTypeSip")
    @Column(name="CADA_DIA_DA_SEMANA")
    private Boolean cadaDiaDaSemana;
    @Column(name="DIA_DO_MES")
    private Integer diaDoMes;
    @Type(type="BooleanTypeSip")
    @Column(name="CADA_DIA_DO_MES")
    private Boolean cadaDiaDoMes;
    @Column(name="MES")
    private Integer mes;
    @Type(type="BooleanTypeSip")
    @Column(name="CADA_MES")
    private Boolean cadaMes;
    @FilterConfig(label="Habilitado", condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="HABILITADO")
    private Boolean habilitado;
    @Column(name="DATA_INICIO")
    private Date dataInicio;
    @Column(name="NSR_INICIO")
    private Integer nsrInicio;
    @FilterConfig(label="N\u00famero", condition=FilterCondition.IGUAL, inputType=FilterInputType.TEXT)
    @Size(max=17)
    @Column(name="NUMERO_REP", length=17)
    private String numeroDoRep;
    @Size(max=17)
    @Column(name="CPF_RESPONSAVEL", length=14)
    private String cpfResponsavel;
    @Column(name="TIPO_REP")
    private Short tipoRep;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public RepMarca getMarca() {
        return this.marca;
    }

    public void setMarca(RepMarca marca) {
        this.marca = marca;
    }

    public RepModelo getModelo() {
        return this.modelo;
    }

    public void setModelo(RepModelo modelo) {
        this.modelo = modelo;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public Integer getPorta() {
        return this.porta;
    }

    public void setPorta(Integer porta) {
        this.porta = porta;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Integer getSegundo() {
        return this.segundo;
    }

    public void setSegundo(Integer segundo) {
        this.segundo = segundo;
    }

    public Boolean getCadaSegundo() {
        return this.cadaSegundo;
    }

    public void setCadaSegundo(Boolean cadaSegundo) {
        this.cadaSegundo = cadaSegundo;
    }

    public Integer getMinuto() {
        return this.minuto;
    }

    public void setMinuto(Integer minuto) {
        this.minuto = minuto;
    }

    public Boolean getCadaMinuto() {
        return this.cadaMinuto;
    }

    public void setCadaMinuto(Boolean cadaMinuto) {
        this.cadaMinuto = cadaMinuto;
    }

    public Integer getHora() {
        return this.hora;
    }

    public void setHora(Integer hora) {
        this.hora = hora;
    }

    public Boolean getCadaHora() {
        return this.cadaHora;
    }

    public void setCadaHora(Boolean cadaHora) {
        this.cadaHora = cadaHora;
    }

    public Integer getDiaDaSemana() {
        return this.diaDaSemana;
    }

    public void setDiaDaSemana(Integer diaDaSemana) {
        this.diaDaSemana = diaDaSemana;
    }

    public Boolean getCadaDiaDaSemana() {
        return this.cadaDiaDaSemana;
    }

    public void setCadaDiaDaSemana(Boolean cadaDiaDaSemana) {
        this.cadaDiaDaSemana = cadaDiaDaSemana;
    }

    public Integer getDiaDoMes() {
        return this.diaDoMes;
    }

    public void setDiaDoMes(Integer diaDoMes) {
        this.diaDoMes = diaDoMes;
    }

    public Boolean getCadaDiaDoMes() {
        return this.cadaDiaDoMes;
    }

    public void setCadaDiaDoMes(Boolean cadaDiaDoMes) {
        this.cadaDiaDoMes = cadaDiaDoMes;
    }

    public Integer getMes() {
        return this.mes;
    }

    public void setMes(Integer mes) {
        this.mes = mes;
    }

    public Boolean getCadaMes() {
        return this.cadaMes;
    }

    public void setCadaMes(Boolean cadaMes) {
        this.cadaMes = cadaMes;
    }

    public Boolean getHabilitado() {
        return this.habilitado;
    }

    public void setHabilitado(Boolean habilitado) {
        this.habilitado = habilitado;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataCadastro) {
        this.dataInicio = dataCadastro;
    }

    public Integer getNsrInicio() {
        return this.nsrInicio;
    }

    public void setNsrInicio(Integer nsrInicio) {
        this.nsrInicio = nsrInicio;
    }

    public String getCpfResponsavel() {
        return this.cpfResponsavel;
    }

    public void setCpfResponsavel(String cpfResponsavel) {
        this.cpfResponsavel = cpfResponsavel;
    }

    public Short getTipoRep() {
        return this.tipoRep;
    }

    public RepTipo getTipoRepEnum() {
        return RepTipo.of(this.tipoRep.shortValue());
    }

    public void setTipoRep(Short tipoRep) {
        this.tipoRep = tipoRep;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepConfig other = (RepConfig)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "ColetorRep [id=" + this.id + ", descricao=" + this.descricao + ", marca=" + (Object)((Object)this.marca) + ", modelo=" + (Object)((Object)this.modelo) + ", endereco=" + this.endereco + ", porta=" + this.porta + "]";
    }

    public void setNumeroDoRep(String numeroDoRep) {
        this.numeroDoRep = numeroDoRep;
    }

    public String getNumeroDoRep() {
        return this.numeroDoRep;
    }
}

