/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Epi;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="CONTROLE_EPI")
@Audited
public class RegistroControleEpi
implements Serializable {
    private static final long serialVersionUID = 7075756764007948471L;
    public static final String FIND_BY_TRABALHADOR = "SELECT DISTINCT c FROM RegistroControleEpi c JOIN FETCH c.trabalhador WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String GET_FETCHED_BY_ID = "SELECT c FROM RegistroControleEpi c LEFT JOIN FETCH c.trabalhador LEFT JOIN FETCH c.epi WHERE c.codigo = :codigo";
    public static final String GENERATOR = "GEN_CONTROLEEPI";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="QTD")
    private short qtd;
    @FilterConfig(label="Dt.Entrega", order=3, inputType=FilterInputType.CALENDAR)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTENTREGA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dtentrega;
    @FilterConfig(label="Dt.Devolu\u00e7\u00e3o", order=4, inputType=FilterInputType.CALENDAR)
    @Column(name="DTDEVOLUCAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dtdevolucao;
    @NotNull
    @Size(min=3, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @NotNull
    @Size(min=6, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @FilterConfig(label="Trabalhador", order=1, condition=FilterCondition.IGUAL)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfig(label="EPI", order=2, condition=FilterCondition.IGUAL)
    @JoinColumn(name="EPI", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Epi epi;

    public RegistroControleEpi() {
    }

    public RegistroControleEpi(Integer codigo) {
        this.codigo = codigo;
    }

    public RegistroControleEpi(Integer codigo, short qtd, Date dtentrega) {
        this.codigo = codigo;
        this.qtd = qtd;
        this.dtentrega = dtentrega;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public short getQtd() {
        return this.qtd;
    }

    public void setQtd(short qtd) {
        this.qtd = qtd;
    }

    public Date getDtentrega() {
        return this.dtentrega;
    }

    public void setDtentrega(Date dtentrega) {
        this.dtentrega = dtentrega;
    }

    public Date getDtdevolucao() {
        return this.dtdevolucao;
    }

    public void setDtdevolucao(Date dtdevolucao) {
        this.dtdevolucao = dtdevolucao;
    }

    public Trabalhador getTrabalhador() {
        if (this.trabalhador == null) {
            this.trabalhador = new Trabalhador();
        }
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidade = null;
            this.registro = null;
        }
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Epi getEpi() {
        if (this.epi == null) {
            this.epi = new Epi();
        }
        return this.epi;
    }

    public void setEpi(Epi epi) {
        this.epi = epi;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegistroControleEpi)) {
            return false;
        }
        RegistroControleEpi other = (RegistroControleEpi)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.ControleEpi[ codigo=" + this.codigo + " ]";
    }
}

