/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.ArrayList;
import java.util.List;

public enum ReferenciaTipo {
    FOLHA_MENSAL("1", "Folha Mensal"),
    ADIAMENTO_SALARIO("2", "Adto. Salario M\u00eas"),
    FOLHA_COMPLEMENTAR("3", "Folha Complementar"),
    ADIAMENTO_13("4", "Adiantamento 13\u00ba Sal\u00e1rio"),
    FECHAMENTO_13("5", "Fechamento 13\u00ba Sal\u00e1rio"),
    FERIAS("6", "F\u00e9rias"),
    DESLIGAMENTO("7", "Desligamento"),
    COMPLEMENTAR_DESLIGAMENTO("8", "Complementar de Desligamento"),
    FOLHA_COMPLEMENTAR_ENCARGOS("9", "Folha Complementar c/ Encargos");

    private final String codigo;
    private final String descricao;

    private ReferenciaTipo(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static ReferenciaTipo get(String codigo) {
        for (ReferenciaTipo r : ReferenciaTipo.values()) {
            if (!r.getCodigo().equals(codigo)) continue;
            return r;
        }
        return FOLHA_MENSAL;
    }

    public static boolean isTodosSelecionados(ReferenciaTipo[] selecionados) {
        if (selecionados != null) {
            return selecionados.length == ReferenciaTipo.values().length;
        }
        return false;
    }

    public static List<String> getCodigoList(ReferenciaTipo[] referenciasTipos) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (referenciasTipos == null) {
            return returnList;
        }
        for (int i = 0; i < referenciasTipos.length; ++i) {
            String codigo = referenciasTipos[i].getCodigo();
            if (codigo == null) continue;
            returnList.add(codigo);
        }
        return returnList;
    }

    public static boolean containOnlyFerias(ReferenciaTipo[] referenciasTipos) {
        if (referenciasTipos != null && referenciasTipos.length == 1) {
            return FERIAS.equals((Object)referenciasTipos[0]);
        }
        return false;
    }

    public static List<String> toListString(List<ReferenciaTipo> tipos) {
        ArrayList<String> codigoList = new ArrayList<String>();
        for (ReferenciaTipo t : tipos) {
            if (t.getCodigo() == null) continue;
            codigoList.add(t.getCodigo());
        }
        return codigoList;
    }

    public boolean isFerias() {
        return this == FERIAS;
    }

    public boolean isFolhaMensal() {
        return this == FOLHA_MENSAL;
    }
}

