/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Bases;
import br.com.fiorilli.sip.persistence.entity.BasesRateio;
import br.com.fiorilli.sip.persistence.entity.CtrlMargemConsignavel;
import br.com.fiorilli.sip.persistence.entity.DespmedicaEntidade;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.ExcluiuMovimento;
import br.com.fiorilli.sip.persistence.entity.FeriasMovimento;
import br.com.fiorilli.sip.persistence.entity.FolhaComplementarTipoESocial;
import br.com.fiorilli.sip.persistence.entity.FolhaPosteriorComplementar;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioMovimento;
import br.com.fiorilli.sip.persistence.entity.Mes;
import br.com.fiorilli.sip.persistence.entity.MesAno;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.Movimento;
import br.com.fiorilli.sip.persistence.entity.MovimentoRateio;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefip;
import br.com.fiorilli.sip.persistence.entity.Msgholerite;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoEvento;
import br.com.fiorilli.sip.persistence.entity.PontoMes;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTcePr;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.Rpps;
import br.com.fiorilli.sip.persistence.entity.SipempenhosCtrl;
import br.com.fiorilli.sip.persistence.entity.Sipimportcabecalho;
import br.com.fiorilli.sip.persistence.entity.SituacaoReferencia;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.joda.time.Interval;
import org.joda.time.Period;

@Entity
@Table(name="REFERENCIA")
@Audited
public class Referencia
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_REFERENCIAS_ENCERRADAS_BY_ANO_MES = "SELECT r FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.encerrado = 'S' AND r.situacao = NORMAL AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes ORDER BY r.primeiroDia DESC";
    public static final String FIND_BY_ANO_MES_TIPO = "SELECT r FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo = :referenciaTipo AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes";
    public static final String FIND_BY_ANO_MES_TIPOS = "SELECT r FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo IN (:referenciaTipo) AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes";
    public static final String FIND_BY_CODIGO_SCPI_ANO_MES_TIPO = "SELECT r FROM Referencia r WHERE r.entidade.scpi.codigoNoScpi = :codigoNoScpi AND r.tipo = :referenciaTipo AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes AND r.encerrado = 'S' AND r.sipweb = 'S'";
    public static final String FIND_BY_ANO_MES_TIPO_VO = "SELECT NEW br.com.fiorilli.sipweb.vo.ws.ReferenciaWsVo(r.codigo, r.mes.mesPK.ano, r.mes.mesPK.mes, r.tipo, r.dataPagamento) FROM Referencia r WHERE r.entidade.codigo = :entidadeId AND r.tipo = :referenciaTipo AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes ORDER BY r.mes.mesPK.ano, r.mes.mesPK.mes";
    public static final String FIND_PRIMEIRO_DIA_BY_ANO_AND_MES = "SELECT r.primeiroDia FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo = :tipo AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes AND r.encerrado = 'N'";
    public static final String FIND_REFERENCIA_NOT_ENCERRADA = "SELECT r FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo = :tipo AND r.encerrado = 'N' ORDER BY r.primeiroDia DESC";
    public static final String FIND_ULTIMO_DIA_BY_ANO_AND_MES = "SELECT r.ultimoDia FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo = :tipo AND r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes AND r.encerrado = 'N'";
    public static final String FIND_ULTIMO_DIA_BY_ANO = "SELECT r.ultimoDia FROM Referencia r WHERE r.entidade.codigo = :entidadeCodigo AND r.tipo = :tipo AND r.mes.mesPK.ano = :ano AND r.encerrado = 'N'";
    public static final String FIND_REFERENCIA_ANTERIOR = "SELECT r.codigo FROM Referencia r WHERE r.entidadeCodigo = :entidadeCodigo AND r.tipo = '1' AND ((r.ano = :ano AND r.mesCodigo < :mes) OR (r.ano < :ano)) ORDER BY r.ano DESC, r.mesCodigo DESC";
    public static final String FIND_BY_REFERENCIA_ANTERIOR = "SELECT r FROM Referencia r WHERE r.referenciaAnteriorCodigo = :codigo";
    public static final String GENERATOR = "GEN_CODIGOREFERENCIA";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="DTPAGTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataPagamento;
    @Column(name="DTFECHA")
    @Temporal(value=TemporalType.DATE)
    private Date dataFechamento;
    @Column(name="PRIMEIRO_DIA")
    @Temporal(value=TemporalType.DATE)
    private Date primeiroDia;
    @Column(name="ULTIMO_DIA")
    @Temporal(value=TemporalType.DATE)
    private Date ultimoDia;
    @Type(type="BooleanTypeSip")
    @Column(name="ENCERRADO")
    private Boolean encerrado;
    @Column(name="ADMITIDOS")
    private Short admitidos;
    @Column(name="DEMITIDOS")
    private Short demitidos;
    @Column(name="SALDO_ANTERIOR")
    private Short saldoAnterior;
    @Column(name="SALDO_ATUAL")
    private Short saldoAtual;
    @Column(name="SALMINNACIONAL")
    private Double salarioMinimoNacional;
    @Column(name="SALMINMUNICIPAL")
    private Double salarioMinimoMunicipal;
    @Column(name="DATAHORA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datahora;
    @Column(name="DOMINGOS")
    private Short domingos;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO_REC_FERIAS")
    private String anoReciboFerias;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES_REC_FERIAS")
    private String mesReciboFerias;
    @Column(name="FERIADOS")
    private Short feriados;
    @Column(name="PRIMEIRO_DIA_FREQ")
    @Temporal(value=TemporalType.DATE)
    private Date primeiroDiaFreq;
    @Column(name="ULTIMO_DIA_FREQ")
    @Temporal(value=TemporalType.DATE)
    private Date ultimoDiaFreq;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULO_COMPLETO")
    private Boolean calculoCompleto;
    @Column(name="SITUACAO")
    @Enumerated
    private SituacaoReferencia situacao;
    @Column(name="DTVENCIMENTO_PREVIDENCIA")
    @Temporal(value=TemporalType.DATE)
    private Date dtvencimentoPrevidencia;
    @Column(name="DTRECOLHIMENTO_PREVIDENCIA")
    @Temporal(value=TemporalType.DATE)
    private Date dtrecolhimentoPrevidencia;
    @Column(name="SABADOS")
    private Short sabados;
    @Type(type="BooleanTypeSip")
    @Column(name="SIPWEB")
    private Boolean sipweb;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<Bases> basesList;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="referencia1", fetch=FetchType.EAGER)
    private Msgholerite msgholerite;
    @OneToMany(mappedBy="referenciaPagto", fetch=FetchType.LAZY)
    private List<LicencaPremioMovimento> movtolicencapremioList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<SipempenhosCtrl> sipempenhosCtrlList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<Sipimportcabecalho> sipimportcabecalhoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia1", fetch=FetchType.LAZY)
    private List<Rpps> rppsList;
    @Column(name="TIPO", insertable=false, updatable=false)
    private String tipo;
    @Column(name="TIPO")
    @Type(type="TipoReferencia")
    private ReferenciaTipo tipoReferencia;
    @OneToMany(mappedBy="referenciaAnterior", fetch=FetchType.LAZY)
    private List<Referencia> referenciaList;
    @Column(name="CODIGO_MES_ANTERIOR")
    private Integer referenciaAnteriorCodigo;
    @JoinColumn(name="CODIGO_MES_ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referenciaAnterior;
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES", insertable=false, updatable=false)
    private String mesCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA"), @JoinColumn(name="ANO", referencedColumnName="ANO"), @JoinColumn(name="MES", referencedColumnName="MES")})
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    private Mes mes;
    @Size(min=1, max=3)
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidadeCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @OneToMany(mappedBy="referenciaPagamento", fetch=FetchType.LAZY)
    private List<FeriasMovimento> movimentoFeriasList;
    @OneToMany(mappedBy="referencia", fetch=FetchType.LAZY)
    private List<MovimentoSefip> movimentoSefipList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<MovimentoRateio> movimentoRateioList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<BasesRateio> basesRateioList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<FolhaPosteriorComplementar> folhaPosteriorComplList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<CtrlMargemConsignavel> ctrlMargemConsignavelList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<Ponto> pontoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia1", fetch=FetchType.LAZY)
    private List<ExcluiuMovimento> excluiuMovimentoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<Movimento> movimentoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<DespmedicaEntidade> despmedicaEntidadeList;
    @Enumerated
    @Column(name="TIPO_FOLHA_COMPL_ESOCIAL")
    private FolhaComplementarTipoESocial tipoFolhaComplementarESocial;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="referencia")
    private ReferenciaTcePr tcePr;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<PontoEvento> pontoEventoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referenciaPagto", fetch=FetchType.LAZY)
    private List<PontoEvento> pontoEventoPagtoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="referencia", fetch=FetchType.LAZY)
    private List<PontoMes> pontoMesList;

    public MesAno getMesAno() {
        return new MesAno(this.mes.getMesPK().getMes(), this.mes.getMesPK().getAno());
    }

    public Referencia() {
    }

    public Referencia(Integer codigo) {
        this.codigo = codigo;
    }

    public Referencia(Integer codigo, String anoRecFerias, String mesRecFerias) {
        this.codigo = codigo;
        this.anoReciboFerias = anoRecFerias;
        this.mesReciboFerias = mesRecFerias;
    }

    private Referencia(Builder b) {
        this.codigo = b.codigo;
        this.ano = b.ano;
        this.mesCodigo = b.mes.getCodigo();
        this.entidadeCodigo = b.entidade;
        this.tipoReferencia = b.tipo;
        this.tipo = b.tipo.getCodigo();
        this.primeiroDia = b.primeiroDia;
        this.ultimoDia = b.ultimoDia;
        this.primeiroDiaFreq = b.primeiroDiaFrequencia;
        this.ultimoDiaFreq = b.ultimoDiaFrequencia;
        this.sabados = b.sabados;
        this.domingos = b.domingos;
        this.feriados = b.feriados;
        this.mes = b.mesObject;
        this.dataPagamento = b.dataPagamento;
        this.dataFechamento = b.dataFechamento;
        this.salarioMinimoMunicipal = b.salarioMinimoMunicipal;
        this.salarioMinimoNacional = b.salarioMinimoNacional;
        this.referenciaAnteriorCodigo = b.referenciaAnteriorCodigo;
        this.situacao = b.situacao;
        this.mesReciboFerias = b.mesReciboFerias;
        this.anoReciboFerias = b.anoReciboFerias;
        this.encerrado = b.encerrado;
        this.datahora = b.dataHora;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    public Date getPrimeiroDia() {
        return this.primeiroDia;
    }

    public void setPrimeiroDia(Date primeiroDia) {
        this.primeiroDia = primeiroDia;
    }

    public Date getUltimoDia() {
        return this.ultimoDia;
    }

    public void setUltimoDia(Date ultimoDia) {
        this.ultimoDia = ultimoDia;
    }

    public Short getAdmitidos() {
        return this.admitidos;
    }

    public void setAdmitidos(Short admitidos) {
        this.admitidos = admitidos;
    }

    public Short getDemitidos() {
        return this.demitidos;
    }

    public void setDemitidos(Short demitidos) {
        this.demitidos = demitidos;
    }

    public Short getSaldoAnterior() {
        return this.saldoAnterior;
    }

    public void setSaldoAnterior(Short saldoAnterior) {
        this.saldoAnterior = saldoAnterior;
    }

    public Short getSaldoAtual() {
        return this.saldoAtual;
    }

    public void setSaldoAtual(Short saldoAtual) {
        this.saldoAtual = saldoAtual;
    }

    public Double getSalarioMinimoNacional() {
        return this.salarioMinimoNacional;
    }

    public void setSalarioMinimoNacional(Double salminnacional) {
        this.salarioMinimoNacional = salminnacional;
    }

    public Double getSalarioMinimoMunicipal() {
        return this.salarioMinimoMunicipal;
    }

    public void setSalarioMinimoMunicipal(Double salminmunicipal) {
        this.salarioMinimoMunicipal = salminmunicipal;
    }

    public Date getDatahora() {
        return this.datahora;
    }

    public void setDatahora(Date datahora) {
        this.datahora = datahora;
    }

    public Short getDomingos() {
        return this.domingos;
    }

    public void setDomingos(Short domingos) {
        this.domingos = domingos;
    }

    public String getAnoReciboFerias() {
        return this.anoReciboFerias;
    }

    public void setAnoReciboFerias(String anoRecFerias) {
        this.anoReciboFerias = anoRecFerias;
    }

    public String getMesReciboFerias() {
        return this.mesReciboFerias;
    }

    public void setMesReciboFerias(String mesRecFerias) {
        this.mesReciboFerias = mesRecFerias;
    }

    public Short getFeriados() {
        return this.feriados;
    }

    public void setFeriados(Short feriados) {
        this.feriados = feriados;
    }

    public Date getPrimeiroDiaFreq() {
        return this.primeiroDiaFreq;
    }

    public void setPrimeiroDiaFreq(Date primeiroDiaFreq) {
        this.primeiroDiaFreq = primeiroDiaFreq;
    }

    public Date getUltimoDiaFreq() {
        return this.ultimoDiaFreq;
    }

    public void setUltimoDiaFreq(Date ultimoDiaFreq) {
        this.ultimoDiaFreq = ultimoDiaFreq;
    }

    public SituacaoReferencia getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoReferencia situacao) {
        this.situacao = situacao;
    }

    public Date getDtvencimentoPrevidencia() {
        return this.dtvencimentoPrevidencia;
    }

    public void setDtvencimentoPrevidencia(Date dtvencimentoPrevidencia) {
        this.dtvencimentoPrevidencia = dtvencimentoPrevidencia;
    }

    public Date getDtrecolhimentoPrevidencia() {
        return this.dtrecolhimentoPrevidencia;
    }

    public void setDtrecolhimentoPrevidencia(Date dtrecolhimentoPrevidencia) {
        this.dtrecolhimentoPrevidencia = dtrecolhimentoPrevidencia;
    }

    public Short getSabados() {
        return this.sabados;
    }

    public void setSabados(Short sabados) {
        this.sabados = sabados;
    }

    public Boolean getEncerrado() {
        return this.encerrado;
    }

    public void setEncerrado(Boolean encerrado) {
        this.encerrado = encerrado;
    }

    public Boolean getCalculoCompleto() {
        return this.calculoCompleto;
    }

    public void setCalculoCompleto(Boolean calculoCompleto) {
        this.calculoCompleto = calculoCompleto;
    }

    public Boolean getSipweb() {
        return this.sipweb;
    }

    public void setSipweb(Boolean sipweb) {
        this.sipweb = sipweb;
    }

    public List<Bases> getBasesList() {
        return this.basesList;
    }

    public void setBasesList(List<Bases> basesList) {
        this.basesList = basesList;
    }

    public Msgholerite getMsgholerite() {
        return this.msgholerite;
    }

    public void setMsgholerite(Msgholerite msgholerite) {
        this.msgholerite = msgholerite;
    }

    public List<LicencaPremioMovimento> getMovtolicencapremioList() {
        return this.movtolicencapremioList;
    }

    public void setMovtolicencapremioList(List<LicencaPremioMovimento> movtolicencapremioList) {
        this.movtolicencapremioList = movtolicencapremioList;
    }

    public List<SipempenhosCtrl> getSipempenhosCtrlList() {
        return this.sipempenhosCtrlList;
    }

    public void setSipempenhosCtrlList(List<SipempenhosCtrl> sipempenhosCtrlList) {
        this.sipempenhosCtrlList = sipempenhosCtrlList;
    }

    public List<Sipimportcabecalho> getSipimportcabecalhoList() {
        return this.sipimportcabecalhoList;
    }

    public void setSipimportcabecalhoList(List<Sipimportcabecalho> sipimportcabecalhoList) {
        this.sipimportcabecalhoList = sipimportcabecalhoList;
    }

    public List<Rpps> getRppsList() {
        return this.rppsList;
    }

    public void setRppsList(List<Rpps> rppsList) {
        this.rppsList = rppsList;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public final ReferenciaTipo getTipoReferencia() {
        return this.tipoReferencia;
    }

    public final void setTipoReferencia(ReferenciaTipo tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }

    public List<Referencia> getReferenciaList() {
        return this.referenciaList;
    }

    public void setReferenciaList(List<Referencia> referenciaList) {
        this.referenciaList = referenciaList;
    }

    public Referencia getReferenciaAnterior() {
        return this.referenciaAnterior;
    }

    public void setReferenciaAnterior(Referencia referenciaAnterior) {
        this.referenciaAnteriorCodigo = referenciaAnterior != null ? referenciaAnterior.getCodigo() : null;
        this.referenciaAnterior = referenciaAnterior;
    }

    public void setMes(Mes mes) {
        this.mes = mes;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidadeCodigo = entidade != null ? entidade.getCodigo() : null;
        this.entidade = entidade;
    }

    public List<FeriasMovimento> getMovimentoFeriasList() {
        return this.movimentoFeriasList;
    }

    public void setMovimentoFeriasList(List<FeriasMovimento> movtoferiasList) {
        this.movimentoFeriasList = movtoferiasList;
    }

    public List<MovimentoSefip> getMovimentoSefipList() {
        return this.movimentoSefipList;
    }

    public void setMovimentoSefipList(List<MovimentoSefip> movtosefipList) {
        this.movimentoSefipList = movtosefipList;
    }

    public List<MovimentoRateio> getMovimentoRateioList() {
        return this.movimentoRateioList;
    }

    public void setMovimentoRateioList(List<MovimentoRateio> movimentoRateioList) {
        this.movimentoRateioList = movimentoRateioList;
    }

    public List<BasesRateio> getBasesRateioList() {
        return this.basesRateioList;
    }

    public void setBasesRateioList(List<BasesRateio> basesRateioList) {
        this.basesRateioList = basesRateioList;
    }

    public List<FolhaPosteriorComplementar> getFolhaPosteriorComplList() {
        return this.folhaPosteriorComplList;
    }

    public void setFolhaPosteriorComplList(List<FolhaPosteriorComplementar> folhaPosteriorComplList) {
        this.folhaPosteriorComplList = folhaPosteriorComplList;
    }

    public List<CtrlMargemConsignavel> getCtrlMargemConsignavelList() {
        return this.ctrlMargemConsignavelList;
    }

    public void setCtrlMargemConsignavelList(List<CtrlMargemConsignavel> ctrlMargemConsignavelList) {
        this.ctrlMargemConsignavelList = ctrlMargemConsignavelList;
    }

    public List<Ponto> getPontoList() {
        return this.pontoList;
    }

    public void setPontoList(List<Ponto> pontoList) {
        this.pontoList = pontoList;
    }

    public List<ExcluiuMovimento> getExcluiuMovimentoList() {
        return this.excluiuMovimentoList;
    }

    public void setExcluiuMovimentoList(List<ExcluiuMovimento> excluiuMovimentoList) {
        this.excluiuMovimentoList = excluiuMovimentoList;
    }

    public List<Movimento> getMovimentoList() {
        return this.movimentoList;
    }

    public void setMovimentoList(List<Movimento> movimentoList) {
        this.movimentoList = movimentoList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Referencia)) {
            return false;
        }
        Referencia other = (Referencia)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public List<PontoMes> getPontoMesList() {
        return this.pontoMesList;
    }

    public void setPontoMesList(List<PontoMes> pontoMesList) {
        this.pontoMesList = pontoMesList;
    }

    public String toString() {
        return "entity.Referencia[ codigo=" + this.codigo + " ]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public Mes getMes() {
        return this.mes;
    }

    public String getMesCodigo() {
        return this.mesCodigo;
    }

    public void setMesCodigo(String mesCodigo) {
        this.mesCodigo = mesCodigo;
    }

    public Integer getReferenciaAnteriorCodigo() {
        return this.referenciaAnteriorCodigo;
    }

    public void setReferenciaAnteriorCodigo(Integer referenciaAnteriorId) {
        this.referenciaAnteriorCodigo = referenciaAnteriorId;
    }

    public FolhaComplementarTipoESocial getTipoFolhaComplementarESocial() {
        return this.tipoFolhaComplementarESocial;
    }

    public void setTipoFolhaComplementarESocial(FolhaComplementarTipoESocial tipoFolhaComplementarESocial) {
        this.tipoFolhaComplementarESocial = tipoFolhaComplementarESocial;
    }

    public boolean exists() {
        return this.codigo > 0;
    }

    public int getDiasMes() throws IllegalStateException {
        if (this.primeiroDia == null || this.ultimoDia == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel calcular a quantidade de dias corridos do m\u00eas. O primeiro ou o \u00faLtimo dia est\u00e3o em branco");
        }
        return new Period(this.primeiroDia.getTime(), this.ultimoDia.getTime()).getDays();
    }

    public static class Builder {
        private int codigo;
        private String ano;
        private MesNomeEnum mes;
        private String entidade;
        private ReferenciaTipo tipo = ReferenciaTipo.FOLHA_MENSAL;
        private Date primeiroDia;
        private Date ultimoDia;
        private Date primeiroDiaFrequencia;
        private Date ultimoDiaFrequencia;
        private short sabados;
        private short domingos;
        private short feriados;
        private Mes mesObject;
        private Date dataPagamento = new Date();
        private Date dataFechamento;
        private Double salarioMinimoMunicipal;
        private Double salarioMinimoNacional;
        private Integer referenciaAnteriorCodigo;
        private SituacaoReferencia situacao = SituacaoReferencia.NORMAL;
        private String mesReciboFerias;
        private String anoReciboFerias;
        private boolean encerrado = false;
        private Date dataHora = new Date();

        public Referencia build() {
            if (this.dataFechamento == null) {
                this.dataFechamento = this.dataPagamento;
            }
            if (this.sabados == 0) {
                this.sabados = SIPDateUtil.countSaturdays((Date)this.primeiroDiaFrequencia, (Date)this.ultimoDiaFrequencia);
            }
            if (this.domingos == 0) {
                this.domingos = SIPDateUtil.countSundays((Date)this.primeiroDiaFrequencia, (Date)this.ultimoDiaFrequencia);
            }
            if (this.mesReciboFerias == null) {
                this.mesReciboFerias = this.mes.next().getCodigo();
            }
            if (this.anoReciboFerias == null) {
                this.anoReciboFerias = "01".equals(this.mesReciboFerias) ? String.valueOf(Integer.parseInt(this.ano) + 1) : this.ano;
            }
            if (this.primeiroDia == null || this.ultimoDia == null) {
                Interval periodoReferencia = SIPUtil.getPrimeiroUltimoDiaFromMesAno((String)this.ano, (String)this.mes.getCodigo());
                if (this.primeiroDia == null) {
                    this.primeiroDia = periodoReferencia.getStart().toDate();
                }
                if (this.ultimoDia == null) {
                    this.ultimoDia = periodoReferencia.getEnd().toDate();
                }
            }
            return new Referencia(this);
        }

        public Builder codigo(int codigo) {
            this.codigo = codigo;
            return this;
        }

        public Builder ano(String ano) {
            this.ano = ano;
            return this;
        }

        public Builder mes(MesNomeEnum mesNomeEnum) {
            this.mes = mesNomeEnum;
            return this;
        }

        public Builder entidade(String entidade) {
            this.entidade = entidade;
            return this;
        }

        public Builder tipo(ReferenciaTipo tipo) {
            this.tipo = tipo;
            return this;
        }

        public Builder primeiroDia(Date primeiroDia) {
            this.primeiroDia = primeiroDia;
            return this;
        }

        public Builder ultimoDia(Date ultimoDia) {
            this.ultimoDia = ultimoDia;
            return this;
        }

        public Builder primeiroDiaFrequencia(Date primeiroDiaFrequencia) {
            this.primeiroDiaFrequencia = primeiroDiaFrequencia;
            return this;
        }

        public Builder ultimoDiaFrequencia(Date ultimoDiaFrequencia) {
            this.ultimoDiaFrequencia = ultimoDiaFrequencia;
            return this;
        }

        public Builder sadados(short sadados) {
            this.sabados = sadados;
            return this;
        }

        public Builder domingos(short domingos) {
            this.domingos = domingos;
            return this;
        }

        public Builder feriados(short feriados) {
            this.feriados = feriados;
            return this;
        }

        public Builder mesObject(Mes mesObject) {
            this.mesObject = mesObject;
            return this;
        }

        public Builder dataPagamento(Date dataPagamento) {
            this.dataPagamento = dataPagamento;
            return this;
        }

        public Builder dataFechamento(Date dataFechamento) {
            this.dataFechamento = dataFechamento;
            return this;
        }

        public Builder salarioMinimoMunicipal(Double salarioMinimoMunicipal) {
            this.salarioMinimoMunicipal = salarioMinimoMunicipal;
            return this;
        }

        public Builder salarioMinimoNacional(Double salarioMinimoNacional) {
            this.salarioMinimoNacional = salarioMinimoNacional;
            return this;
        }

        public Builder referenciaAnteriorCodigo(Integer referenciaAnteriorCodigo) {
            this.referenciaAnteriorCodigo = referenciaAnteriorCodigo;
            return this;
        }

        public Builder situacao(SituacaoReferencia situacao) {
            this.situacao = situacao;
            return this;
        }

        public Builder mesReciboFerias(String mesReciboFerias) {
            this.mesReciboFerias = mesReciboFerias;
            return this;
        }
    }
}

