/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROCESSO_ADM_JUDICIAL")
@Audited
public class ProcessoAdmJudicial
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_ALL = "SELECT p FROM ProcessoAdmJudicial p ORDER BY p.id";
    @Id
    @NotNull
    @Column(name="ID", unique=true)
    private Integer id;
    @FilterConfig(label="Autoria Pr\u00f3pria", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    @Type(type="BooleanTypeSip")
    @Column(name="AUTORIA")
    private Boolean autoria;
    @FilterConfig(label="Data Decis\u00e3o", inputType=FilterInputType.CALENDAR, condition=FilterCondition.IGUAL)
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DECISAO")
    private Date dataDecisao;
    @FilterConfig(label="Decis\u00e3o", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    @Size(max=512)
    @Column(name="DECISAO")
    private String decisao;
    @Type(type="BooleanTypeSip")
    @Column(name="DEPOSITO_MONTANTE_INTEGRAL")
    private Boolean depositoMontanteIntegral;
    @Size(max=3)
    @NotNull
    @Column(name="EMPRESA", length=3)
    private String entidadeCodigo;
    @FilterConfig(label="ID Munic\u00edpio", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL)
    @NotNull
    @Size(max=7)
    @Column(name="ID_MUNICIPIO")
    private String idMunicipio;
    @FilterConfig(label="ID Vara", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL)
    @NotNull
    @Size(max=2)
    @Column(name="ID_VARA")
    private String idVara;
    @NotNull
    @Column(name="INDICATIVO_SUSPENSAO")
    private Integer indicativoSuspensao;
    @FilterConfig(label="N\u00famero", inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL)
    @NotNull
    @Size(max=20)
    @Column(name="NUMERO")
    private String numero;
    @NotNull
    @Column(name="TIPO")
    private int tipo;
    @FilterConfig(label="UF Vara", inputType=FilterInputType.TEXT, condition=FilterCondition.IGUAL)
    @NotNull
    @Size(max=2)
    @Column(name="UF_VARA")
    private String ufVara;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getAutoria() {
        return this.autoria;
    }

    public void setAutoria(Boolean autoria) {
        this.autoria = autoria;
    }

    public Date getDataDecisao() {
        return this.dataDecisao;
    }

    public void setDataDecisao(Date dataDecisao) {
        this.dataDecisao = dataDecisao;
    }

    public String getDecisao() {
        return this.decisao;
    }

    public void setDecisao(String decisao) {
        this.decisao = decisao;
    }

    public Boolean getDepositoMontanteIntegral() {
        return this.depositoMontanteIntegral;
    }

    public void setDepositoMontanteIntegral(Boolean depositoMontanteIntegral) {
        this.depositoMontanteIntegral = depositoMontanteIntegral;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String empresa) {
        this.entidadeCodigo = empresa;
    }

    public String getIdMunicipio() {
        return this.idMunicipio;
    }

    public void setIdMunicipio(String idMunicipio) {
        this.idMunicipio = idMunicipio;
    }

    public String getIdVara() {
        return this.idVara;
    }

    public void setIdVara(String idVara) {
        this.idVara = idVara;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public String getUfVara() {
        return this.ufVara;
    }

    public void setUfVara(String ufVara) {
        this.ufVara = ufVara;
    }

    public Integer getIndicativoSuspensao() {
        return this.indicativoSuspensao;
    }

    public void setIndicativoSuspensao(Integer indicativoSuspensao) {
        this.indicativoSuspensao = indicativoSuspensao;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return String.valueOf(this.id);
    }

    public String getItemLabel() {
        return this.numero;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessoAdmJudicial other = (ProcessoAdmJudicial)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "ProcessoAdmJudicial [id=" + this.id + "]";
    }
}

