/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Comissao;
import br.com.fiorilli.sip.persistence.entity.DocumentoParecerProcedimentoAdiministrativo;
import br.com.fiorilli.sip.persistence.entity.EnvolvidoProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.MovimentoProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.NaturezaProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.ParecerProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PROC_ADM")
@FilterConfigType(query="SELECT DISTINCT $R{[e.id],[e]} FROM ProcedimentoAdministrativo e JOIN FETCH e.comissao JOIN FETCH e.natureza JOIN FETCH e.tipoLegal JOIN e.comissao co LEFT JOIN co.membros me LEFT JOIN FETCH e.parecer.tipoLegal LEFT JOIN FETCH e.documentosParecer dp WHERE (co.responsavel.trabalhadorPK = :trabalhadorPK OR me.trabalhador.trabalhadorPK = :trabalhadorPK) AND $P{[dataDocumento], [e.dataDocumento], [:dataDocumento]} AND $P{[numeroDocumento], [e.numeroDocumento], [:numeroDocumento]} AND $P{[comissao], [e.comissao], [:comissao]} AND $P{[natureza], [e.natureza], [:natureza]} AND $P{[tipoLegal], [e.tipoLegal], [:tipoLegal]}")
@Audited
public class ProcedimentoAdministrativo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ID = "SELECT DISTINCT pr FROM ProcedimentoAdministrativo pr WHERE pr.id = :procAdmId";
    public static final String DYNAMIC_QUERY = "SELECT DISTINCT $R{[e.id],[e]} FROM ProcedimentoAdministrativo e JOIN FETCH e.comissao JOIN FETCH e.natureza JOIN FETCH e.tipoLegal JOIN e.comissao co LEFT JOIN co.membros me LEFT JOIN FETCH e.parecer.tipoLegal LEFT JOIN FETCH e.documentosParecer dp WHERE (co.responsavel.trabalhadorPK = :trabalhadorPK OR me.trabalhador.trabalhadorPK = :trabalhadorPK) AND $P{[dataDocumento], [e.dataDocumento], [:dataDocumento]} AND $P{[numeroDocumento], [e.numeroDocumento], [:numeroDocumento]} AND $P{[comissao], [e.comissao], [:comissao]} AND $P{[natureza], [e.natureza], [:natureza]} AND $P{[tipoLegal], [e.tipoLegal], [:tipoLegal]}";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @FilterConfig(label="Data do Documento", order=4, condition=FilterCondition.INTERVALO, inputType=FilterInputType.CALENDAR)
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATADOC", nullable=false)
    private Date dataDocumento;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidadeId;
    @Column(name="NATUREZA", nullable=false)
    private int naturezaId;
    @Column(name="TIPOLEGAL", nullable=false)
    private int tipoLegalId;
    @Column(name="COMISSAO", nullable=false)
    private int comissaoId;
    @FilterConfig(label="N\u00famero/Ano", order=3)
    @Column(name="NUMDOC", nullable=false, length=16)
    private String numeroDocumento;
    @Column(name="OBJETO_TEXTO", nullable=false, length=512)
    private String objetoTexto;
    @Embedded
    private ParecerProcedimentoAdministrativo parecer;
    @OneToMany(mappedBy="procedimentoAdministrativo", fetch=FetchType.LAZY)
    private List<DocumentoParecerProcedimentoAdiministrativo> documentosParecer;
    @OneToMany(mappedBy="procedimentoAdministrativo", fetch=FetchType.LAZY)
    private List<MovimentoProcedimentoAdministrativo> movimentos;
    @OneToMany(mappedBy="procedimentoAdministrativo", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<EnvolvidoProcedimentoAdministrativo> envolvidos;
    @FilterConfig(label="Comiss\u00e3o", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigSelect(query="SELECT DISTINCT c FROM Comissao c JOIN FETCH c.responsavel LEFT JOIN c.membros m WHERE c.responsavel.trabalhadorPK = :trabalhadorPK OR m.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY c.codigo DESC", itemLabel="descricao")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMISSAO", insertable=false, updatable=false)
    private Comissao comissao;
    @FilterConfig(label="Natureza", inputType=FilterInputType.SELECT_ONE_MENU, order=1)
    @FilterConfigSelect(query="SELECT n FROM NaturezaProcedimentoAdministrativo n WHERE n.entidadeId = :entidadeId", itemLabel="nome")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="NATUREZA", insertable=false, updatable=false)
    private NaturezaProcedimentoAdministrativo natureza;
    @FilterConfig(label="Tipo Legal", order=2, inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT t FROM TipoDocumentoLegal t WHERE lower(t.nome) LIKE lower('%'||:param||'%') ORDER BY t.nome")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPOLEGAL", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    public String getEntidadeId() {
        return this.entidadeId;
    }

    public void setEntidadeId(String empresa) {
        this.entidadeId = empresa;
    }

    public int getNaturezaId() {
        return this.naturezaId;
    }

    public void setNaturezaId(int natureza) {
        this.naturezaId = natureza;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public String getObjetoTexto() {
        return this.objetoTexto;
    }

    public void setObjetoTexto(String objetoTexto) {
        this.objetoTexto = objetoTexto;
    }

    public int getTipoLegalId() {
        return this.tipoLegalId;
    }

    public void setTipoLegalId(int tipolegal) {
        this.tipoLegalId = tipolegal;
    }

    public Comissao getComissao() {
        return this.comissao;
    }

    public void setComissao(Comissao comissao) {
        this.comissao = comissao;
    }

    public List<DocumentoParecerProcedimentoAdiministrativo> getDocumentosParecer() {
        return this.documentosParecer;
    }

    public void setDocumentosParecer(List<DocumentoParecerProcedimentoAdiministrativo> documentosParecer) {
        this.documentosParecer = documentosParecer;
    }

    public int getComissaoId() {
        return this.comissaoId;
    }

    public void setComissaoId(int comissaoId) {
        this.comissaoId = comissaoId;
    }

    public NaturezaProcedimentoAdministrativo getNatureza() {
        return this.natureza;
    }

    public void setNatureza(NaturezaProcedimentoAdministrativo natureza) {
        this.natureza = natureza;
    }

    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegal = tipoLegal;
    }

    public ParecerProcedimentoAdministrativo getParecer() {
        if (this.parecer == null) {
            this.parecer = new ParecerProcedimentoAdministrativo();
        }
        return this.parecer;
    }

    public void setParecer(ParecerProcedimentoAdministrativo parecer) {
        this.parecer = parecer;
    }

    public List<MovimentoProcedimentoAdministrativo> getMovimentos() {
        return this.movimentos;
    }

    public void setMovimentos(List<MovimentoProcedimentoAdministrativo> movimentos) {
        this.movimentos = movimentos;
    }
}

