/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BrPdh;
import br.com.fiorilli.sip.persistence.entity.PppExameMedico;
import br.com.fiorilli.sip.persistence.entity.PppExposicaoFatorRisco;
import br.com.fiorilli.sip.persistence.entity.PppLotacao;
import br.com.fiorilli.sip.persistence.entity.PppPrincipalPK;
import br.com.fiorilli.sip.persistence.entity.PppProfissiografia;
import br.com.fiorilli.sip.persistence.entity.PppResponsavel;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="PPP_PRINCIPAL")
@Audited
public class PppPrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FETCHING_ALL = "SELECT p FROM PppPrincipal p WHERE p.pppPrincipalPK = :pppPrincipalPK";
    @EmbeddedId
    protected PppPrincipalPK pppPrincipalPK;
    @Enumerated(value=EnumType.STRING)
    @Column(name="BRPDH")
    private BrPdh brPdh;
    @Size(max=5)
    @Column(name="REGIREVEZ")
    private String regimeRevezamento;
    @Size(max=60)
    @Column(name="RELEGALNOME")
    private String reponsavelLegalNome;
    @Size(max=11)
    @Column(name="RELEGALNIT")
    private String responsavelLegalNit;
    @Column(name="DTEMISSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataEmissao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String obs;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pppPrincipal", fetch=FetchType.LAZY)
    private List<PppLotacao> pppLotacaoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pppPrincipal", fetch=FetchType.LAZY)
    private List<PppExposicaoFatorRisco> pppExposicaoFatorRiscoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pppPrincipal", fetch=FetchType.LAZY)
    private List<PppExameMedico> pppExameMedicoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pppPrincipal", fetch=FetchType.LAZY)
    private List<PppResponsavel> pppResponsavelList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pppPrincipal", fetch=FetchType.LAZY)
    private List<PppProfissiografia> pppProfissiografiaList;

    public PppPrincipal() {
    }

    public PppPrincipal(PppPrincipalPK pppPrincipalPK) {
        this.pppPrincipalPK = pppPrincipalPK;
    }

    public PppPrincipal(String entidade, String registro) {
        this.pppPrincipalPK = new PppPrincipalPK(entidade, registro);
    }

    public PppPrincipalPK getPppPrincipalPK() {
        return this.pppPrincipalPK;
    }

    public void setPppPrincipalPK(PppPrincipalPK pppPrincipalPK) {
        this.pppPrincipalPK = pppPrincipalPK;
    }

    public BrPdh getBrPdh() {
        return this.brPdh;
    }

    public void setBrPdh(BrPdh brpdh) {
        this.brPdh = brpdh;
    }

    public String getRegimeRevezamento() {
        return this.regimeRevezamento;
    }

    public void setRegimeRevezamento(String regirevez) {
        this.regimeRevezamento = regirevez;
    }

    public String getReponsavelLegalNome() {
        return this.reponsavelLegalNome;
    }

    public void setReponsavelLegalNome(String relegalnome) {
        this.reponsavelLegalNome = relegalnome;
    }

    public String getResponsavelLegalNit() {
        return this.responsavelLegalNit;
    }

    public void setResponsavelLegalNit(String relegalnit) {
        this.responsavelLegalNit = relegalnit;
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dtemissao) {
        this.dataEmissao = dtemissao;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public List<PppExposicaoFatorRisco> getPppExposicaoFatorRiscoList() {
        return this.pppExposicaoFatorRiscoList;
    }

    public void setPppExposicaoFatorRiscoList(List<PppExposicaoFatorRisco> pppRegisambiList) {
        this.pppExposicaoFatorRiscoList = pppRegisambiList;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public List<PppExameMedico> getPppExameMedicoList() {
        return this.pppExameMedicoList;
    }

    public void setPppExameMedicoList(List<PppExameMedico> pppMonitbiolList) {
        this.pppExameMedicoList = pppMonitbiolList;
    }

    public List<PppResponsavel> getPppResponsavelList() {
        return this.pppResponsavelList;
    }

    public void setPppResponsavelList(List<PppResponsavel> pppResponsList) {
        this.pppResponsavelList = pppResponsList;
    }

    public List<PppLotacao> getPppLotacaoList() {
        return this.pppLotacaoList;
    }

    public void setPppLotacaoList(List<PppLotacao> pppLotacaoList) {
        this.pppLotacaoList = pppLotacaoList;
    }

    public List<PppProfissiografia> getPppProfissiografiaList() {
        return this.pppProfissiografiaList;
    }

    public void setPppProfissiografiaList(List<PppProfissiografia> pppProfisList) {
        this.pppProfissiografiaList = pppProfisList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pppPrincipalPK != null ? this.pppPrincipalPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PppPrincipal)) {
            return false;
        }
        PppPrincipal other = (PppPrincipal)object;
        return (this.pppPrincipalPK != null || other.pppPrincipalPK == null) && (this.pppPrincipalPK == null || this.pppPrincipalPK.equals(other.pppPrincipalPK));
    }

    public String toString() {
        return "entity.PppPrincipal[ pppPrincipalPK=" + this.pppPrincipalPK + " ]";
    }
}

