/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.PppLotacaoPK;
import br.com.fiorilli.sip.persistence.entity.PppPrincipal;
import br.com.fiorilli.sip.persistence.entity.SefipTipoOcorrencia;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="PPP_LOTACAO")
@Audited
public class PppLotacao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(l.pppLotacaoPK.item), 0) + 1 FROM PppLotacao l WHERE l.pppPrincipal.pppPrincipalPK = :pppPrincipalPK";
    @EmbeddedId
    protected PppLotacaoPK pppLotacaoPK;
    @Column(name="DTINI")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @Size(max=4)
    @Column(name="TIPOID")
    private String tipoIdentificador;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Size(max=15)
    @Column(name="SETOR")
    private String setor;
    @Size(max=30)
    @Column(name="CARGO")
    private String cargo;
    @Size(max=30)
    @Column(name="FUNCAO")
    private String funcao;
    @Size(max=6)
    @Column(name="CBO")
    private String cbo;
    @Size(max=2)
    @Column(name="CODGFIP")
    private String ocorrenciaGfip;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private PppPrincipal pppPrincipal;

    public PppLotacao() {
    }

    public PppLotacao(PppLotacaoPK pppLotacaoPK) {
        this.pppLotacaoPK = pppLotacaoPK;
    }

    public PppLotacao(String entidade, String registro, short item) {
        this.pppLotacaoPK = new PppLotacaoPK(entidade, registro, item);
    }

    public PppLotacaoPK getPppLotacaoPK() {
        return this.pppLotacaoPK;
    }

    public void setPppLotacaoPK(PppLotacaoPK pppLotacaoPK) {
        this.pppLotacaoPK = pppLotacaoPK;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dtini) {
        this.dataInicio = dtini;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public String getTipoIdentificador() {
        return this.tipoIdentificador;
    }

    public void setTipoIdentificador(String tipoid) {
        this.tipoIdentificador = tipoid;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public String getSetor() {
        return this.setor;
    }

    public void setSetor(String setor) {
        this.setor = setor;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getFuncao() {
        return this.funcao;
    }

    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    public String getCbo() {
        return this.cbo;
    }

    public void setCbo(String cbo) {
        this.cbo = cbo;
    }

    public SefipTipoOcorrencia getOcorrenciaGfip() {
        return SefipTipoOcorrencia.get(this.ocorrenciaGfip);
    }

    public void setOcorrenciaGfip(SefipTipoOcorrencia codgfip) {
        this.ocorrenciaGfip = codgfip.getCodigo();
    }

    public PppPrincipal getPppPrincipal() {
        return this.pppPrincipal;
    }

    public void setPppPrincipal(PppPrincipal pppPrincipal) {
        this.pppPrincipal = pppPrincipal;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pppLotacaoPK != null ? this.pppLotacaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PppLotacao)) {
            return false;
        }
        PppLotacao other = (PppLotacao)object;
        return (this.pppLotacaoPK != null || other.pppLotacaoPK == null) && (this.pppLotacaoPK == null || this.pppLotacaoPK.equals(other.pppLotacaoPK));
    }

    public String toString() {
        return "entity.PppLotacao[ pppLotacaoPK=" + this.pppLotacaoPK + " ]";
    }
}

