/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.PontoWeb;
import br.com.fiorilli.sip.persistence.enums.PontoWebStatus;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_WEB_ALTERACAO")
@Audited
public class PontoWebAlteracao {
    public static final String GENERATOR = "GEN_PONTOWEB_ALTERACAO";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="DATAHORA", nullable=false)
    private Date dataHora;
    @Column(name="MOTIVO")
    @NotNull
    @Size(min=1, max=150)
    private String motivo;
    @Column(name="STATUS")
    @NotNull
    @Size(min=1, max=1)
    private String status;
    @Column(name="DATA_ANALISE", nullable=false)
    private Date dataAnalise;
    @Size(min=0, max=6)
    @Column(name="REGISTRO_RESPONSAVEL")
    private String registroResponsavel;
    @JoinColumn(name="ID_PONTO_WEB", referencedColumnName="NSR")
    @ManyToOne(fetch=FetchType.LAZY)
    private PontoWeb pontoWeb;

    public PontoWebStatus getStatusEnum() {
        if (this.status != null) {
            return PontoWebStatus.getBy(this.status);
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getDataAnalise() {
        return this.dataAnalise;
    }

    public String getRegistroResponsavel() {
        return this.registroResponsavel;
    }

    public PontoWeb getPontoWeb() {
        return this.pontoWeb;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDataAnalise(Date dataAnalise) {
        this.dataAnalise = dataAnalise;
    }

    public void setRegistroResponsavel(String registroResponsavel) {
        this.registroResponsavel = registroResponsavel;
    }

    public void setPontoWeb(PontoWeb pontoWeb) {
        this.pontoWeb = pontoWeb;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PontoWebAlteracao)) {
            return false;
        }
        PontoWebAlteracao other = (PontoWebAlteracao)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Date this$dataHora = this.getDataHora();
        Date other$dataHora = other.getDataHora();
        if (this$dataHora == null ? other$dataHora != null : !((Object)this$dataHora).equals(other$dataHora)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$dataAnalise = this.getDataAnalise();
        Date other$dataAnalise = other.getDataAnalise();
        if (this$dataAnalise == null ? other$dataAnalise != null : !((Object)this$dataAnalise).equals(other$dataAnalise)) {
            return false;
        }
        String this$registroResponsavel = this.getRegistroResponsavel();
        String other$registroResponsavel = other.getRegistroResponsavel();
        if (this$registroResponsavel == null ? other$registroResponsavel != null : !this$registroResponsavel.equals(other$registroResponsavel)) {
            return false;
        }
        PontoWeb this$pontoWeb = this.getPontoWeb();
        PontoWeb other$pontoWeb = other.getPontoWeb();
        return !(this$pontoWeb == null ? other$pontoWeb != null : !((Object)this$pontoWeb).equals(other$pontoWeb));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PontoWebAlteracao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Date $dataHora = this.getDataHora();
        result = result * 59 + ($dataHora == null ? 43 : ((Object)$dataHora).hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $dataAnalise = this.getDataAnalise();
        result = result * 59 + ($dataAnalise == null ? 43 : ((Object)$dataAnalise).hashCode());
        String $registroResponsavel = this.getRegistroResponsavel();
        result = result * 59 + ($registroResponsavel == null ? 43 : $registroResponsavel.hashCode());
        PontoWeb $pontoWeb = this.getPontoWeb();
        result = result * 59 + ($pontoWeb == null ? 43 : ((Object)$pontoWeb).hashCode());
        return result;
    }

    public String toString() {
        return "PontoWebAlteracao(id=" + this.getId() + ", dataHora=" + this.getDataHora() + ", motivo=" + this.getMotivo() + ", status=" + this.getStatus() + ", dataAnalise=" + this.getDataAnalise() + ", registroResponsavel=" + this.getRegistroResponsavel() + ", pontoWeb=" + this.getPontoWeb() + ")";
    }
}

