/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.enums.PontoWebTipo;
import br.com.fiorilli.sipweb.vo.ws.BatidaExternaWsVo;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_WEB")
@Audited
public class PontoWeb
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT pw FROM PontoWeb pw WHERE pw.trabalhador.trabalhadorPK = :trabalhadorPK AND pw.dataHora BETWEEN :periodoInicio AND :periodoFim ORDER BY pw.dataHora";
    public static final String FIND_BY_REGISTRO_AND_PERIODO = "SELECT NEW br.com.fiorilli.sipweb.vo.PontoOfTrabalhadorVo(pw.nsr, pw.dataHora) FROM PontoWeb pw WHERE pw.entidadeCodigo = :entidadeCodigo AND pw.registro = :registro AND pw.dataHora BETWEEN :periodoInicio AND :periodoFim ORDER BY pw.dataHora ";
    public static final String FIND_BY_CARTAO_PERIODO = "SELECT NEW " + BatidaExternaWsVo.class.getCanonicalName() + "(" + " t.ponto.numeroCartao, pw.dataHora, pw.latitude, pw.longitude, pw.ip " + ") " + "FROM PontoWeb pw " + "LEFT JOIN pw.trabalhador t " + "WHERE t.ponto.numeroCartao = :numeroCartao " + "AND pw.dataHora BETWEEN :dataInicial AND :dataFinal " + "ORDER BY pw.dataHora ";
    public static final String FIND_BY_TRABALHADOR_AND_DATA_REFERENCIA = "SELECT pw FROM PontoWeb pw WHERE pw.trabalhador.trabalhadorPK = :trabalhadorPK \tAND pw.dataReferencia = :data ORDER BY pw.dataHora, pw.tipo ";
    public static final String FIND_BY_TRABALHADOR_AND_PERIOD_REFERENCIA = "SELECT pw FROM PontoWeb pw WHERE pw.trabalhador.trabalhadorPK = :trabalhadorPK \tAND ((pw.dataReferencia BETWEEN :dataInicial AND :dataFinal) \t\tOR (pw.dataReferencia BETWEEN :dataInicialFreq AND :dataFinalFreq)) ";
    public static final String FIND_BY_TRABALHADOR_AND_PERIOD_BATIDA = "SELECT pw FROM PontoWeb pw WHERE pw.trabalhador.trabalhadorPK = :trabalhadorPK \tAND pw.dataHora BETWEEN :dataHoraInicial AND :dataHoraFinal ";
    public static final String UPDATE_REVERT_DATA_REFERENCIA = "UPDATE PontoWeb w SET w.dataReferencia = w.dataReferenciaAnterior, w.dataReferenciaAnterior = null WHERE w.pontoCodigo in (   select p.codigo from Ponto p where p.entidadeCodigo = :entidadeCodigo    AND p.registro = :registro    AND p.referenciaCodigo = :referenciaCodigo    AND not exists( \t    select 1 from PontoMes pm \t    where pm = p.pontoMes \t    and coalesce(pm.incorporarCalculoFolha, 'N') = true    )    AND coalesce(p.congelar, 'N') = false) AND w.dataReferenciaAnterior is not null ";
    public static final String GENERATOR = "GEN_PONTOWEB";
    @Id
    @Column(unique=true, nullable=false)
    private Integer nsr;
    @Column(name="DATAHORA", nullable=false)
    private Date dataHora;
    @Column(nullable=false)
    private Double latitude;
    @Column(nullable=false)
    private Double longitude;
    @Column(nullable=false)
    private String ip;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Column(name="TIPO")
    private Integer tipo;
    @Column(name="DATA_REFERENCIA")
    @Temporal(value=TemporalType.DATE)
    private Date dataReferencia;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @Column(name="CODPONTO")
    private Integer pontoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODPONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @Column(name="DATA_REFERENCIA_ANTERIOR")
    @Temporal(value=TemporalType.DATE)
    private Date dataReferenciaAnterior;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCAL_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private LocalTrabalho localTrabalho;
    @Column(name="DISTANCIA_BATIDA_METROS", insertable=false, updatable=false)
    private Double distanciaBatidaMetros;

    public PontoWeb() {
    }

    public Integer getNsr() {
        return this.nsr;
    }

    public void setNsr(Integer nsr) {
        this.nsr = nsr;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date datahora) {
        this.dataHora = datahora;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidadeCodigo = null;
            this.registro = null;
        }
        this.trabalhador = trabalhador;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public Date getDataReferencia() {
        return this.dataReferencia;
    }

    public void setDataReferencia(Date dataReferencia) {
        if (dataReferencia != null && this.dataReferencia != dataReferencia) {
            this.dataReferenciaAnterior = this.dataReferencia;
        }
        this.dataReferencia = dataReferencia;
    }

    public Integer getPontoCodigo() {
        return this.pontoCodigo;
    }

    public void setPontoCodigo(Integer pontoCodigo) {
        this.pontoCodigo = pontoCodigo;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        this.ponto = ponto;
        if (ponto != null) {
            this.pontoCodigo = ponto.getCodigo();
        }
    }

    public Date getDataReferenciaAnterior() {
        return this.dataReferenciaAnterior;
    }

    public PontoWebTipo getTipoEnum() {
        if (this.tipo != null) {
            return PontoWebTipo.getBy(this.tipo);
        }
        return null;
    }

    public LocalTrabalho getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalho localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    public Double getDistanciaBatidaMetros() {
        return this.distanciaBatidaMetros;
    }

    public void setDistanciaBatidaMetros(Double distanciaBatidaMetros) {
        this.distanciaBatidaMetros = distanciaBatidaMetros;
    }

    public boolean isBatidaForaLimite() {
        if (this.localTrabalho != null && this.localTrabalho.getToleranciaBatidaMetros() != null && this.localTrabalho.getToleranciaBatidaMetros() > 0.0) {
            return this.distanciaBatidaMetros > this.localTrabalho.getToleranciaBatidaMetros();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoWeb pontoWeb = (PontoWeb)o;
        return Objects.equals(this.nsr, pontoWeb.nsr);
    }

    public int hashCode() {
        return Objects.hash(this.nsr);
    }

    public static PontoWebBuilder builder() {
        return new PontoWebBuilder();
    }

    public PontoWeb(Integer nsr, Date dataHora, Double latitude, Double longitude, String ip, String entidadeCodigo, String registro, Integer tipo, Date dataReferencia, Trabalhador trabalhador, Integer pontoCodigo, Ponto ponto, Date dataReferenciaAnterior, LocalTrabalho localTrabalho, Double distanciaBatidaMetros) {
        this.nsr = nsr;
        this.dataHora = dataHora;
        this.latitude = latitude;
        this.longitude = longitude;
        this.ip = ip;
        this.entidadeCodigo = entidadeCodigo;
        this.registro = registro;
        this.tipo = tipo;
        this.dataReferencia = dataReferencia;
        this.trabalhador = trabalhador;
        this.pontoCodigo = pontoCodigo;
        this.ponto = ponto;
        this.dataReferenciaAnterior = dataReferenciaAnterior;
        this.localTrabalho = localTrabalho;
        this.distanciaBatidaMetros = distanciaBatidaMetros;
    }

    public String toString() {
        return "PontoWeb(nsr=" + this.getNsr() + ", dataHora=" + this.getDataHora() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", ip=" + this.getIp() + ", entidadeCodigo=" + this.getEntidadeCodigo() + ", registro=" + this.getRegistro() + ", tipo=" + this.getTipo() + ", dataReferencia=" + this.getDataReferencia() + ", trabalhador=" + this.getTrabalhador() + ", pontoCodigo=" + this.getPontoCodigo() + ", ponto=" + this.getPonto() + ", dataReferenciaAnterior=" + this.getDataReferenciaAnterior() + ", localTrabalho=" + this.getLocalTrabalho() + ", distanciaBatidaMetros=" + this.getDistanciaBatidaMetros() + ")";
    }

    public static class PontoWebBuilder {
        private Integer nsr;
        private Date dataHora;
        private Double latitude;
        private Double longitude;
        private String ip;
        private String entidadeCodigo;
        private String registro;
        private Integer tipo;
        private Date dataReferencia;
        private Trabalhador trabalhador;
        private Integer pontoCodigo;
        private Ponto ponto;
        private Date dataReferenciaAnterior;
        private LocalTrabalho localTrabalho;
        private Double distanciaBatidaMetros;

        PontoWebBuilder() {
        }

        public PontoWebBuilder nsr(Integer nsr) {
            this.nsr = nsr;
            return this;
        }

        public PontoWebBuilder dataHora(Date dataHora) {
            this.dataHora = dataHora;
            return this;
        }

        public PontoWebBuilder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public PontoWebBuilder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public PontoWebBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public PontoWebBuilder entidadeCodigo(String entidadeCodigo) {
            this.entidadeCodigo = entidadeCodigo;
            return this;
        }

        public PontoWebBuilder registro(String registro) {
            this.registro = registro;
            return this;
        }

        public PontoWebBuilder tipo(Integer tipo) {
            this.tipo = tipo;
            return this;
        }

        public PontoWebBuilder dataReferencia(Date dataReferencia) {
            this.dataReferencia = dataReferencia;
            return this;
        }

        public PontoWebBuilder trabalhador(Trabalhador trabalhador) {
            this.trabalhador = trabalhador;
            return this;
        }

        public PontoWebBuilder pontoCodigo(Integer pontoCodigo) {
            this.pontoCodigo = pontoCodigo;
            return this;
        }

        public PontoWebBuilder ponto(Ponto ponto) {
            this.ponto = ponto;
            return this;
        }

        public PontoWebBuilder dataReferenciaAnterior(Date dataReferenciaAnterior) {
            this.dataReferenciaAnterior = dataReferenciaAnterior;
            return this;
        }

        public PontoWebBuilder localTrabalho(LocalTrabalho localTrabalho) {
            this.localTrabalho = localTrabalho;
            return this;
        }

        public PontoWebBuilder distanciaBatidaMetros(Double distanciaBatidaMetros) {
            this.distanciaBatidaMetros = distanciaBatidaMetros;
            return this;
        }

        public PontoWeb build() {
            return new PontoWeb(this.nsr, this.dataHora, this.latitude, this.longitude, this.ip, this.entidadeCodigo, this.registro, this.tipo, this.dataReferencia, this.trabalhador, this.pontoCodigo, this.ponto, this.dataReferenciaAnterior, this.localTrabalho, this.distanciaBatidaMetros);
        }

        public String toString() {
            return "PontoWeb.PontoWebBuilder(nsr=" + this.nsr + ", dataHora=" + this.dataHora + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", ip=" + this.ip + ", entidadeCodigo=" + this.entidadeCodigo + ", registro=" + this.registro + ", tipo=" + this.tipo + ", dataReferencia=" + this.dataReferencia + ", trabalhador=" + this.trabalhador + ", pontoCodigo=" + this.pontoCodigo + ", ponto=" + this.ponto + ", dataReferenciaAnterior=" + this.dataReferenciaAnterior + ", localTrabalho=" + this.localTrabalho + ", distanciaBatidaMetros=" + this.distanciaBatidaMetros + ")";
        }
    }
}

