/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.TipoOcorrencia;
import br.com.fiorilli.sip.persistence.enums.PontoWebStatus;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_TRAB_OCORRENCIA")
@Audited
public class PontoTrabOcorrencia
implements Serializable {
    public static final String GENERATOR = "GEN_PONTOWEB_OCORRENCIA";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="CODPONTO")
    private Integer pontoId;
    @Column(name="TIPO_OCORRENCIA")
    private Integer tipoOcorrenciaId;
    @Column(name="STATUS")
    @NotNull
    @Size(min=1, max=1)
    private String status;
    @Column(name="DATA_LANCAMENTO", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dataLancamento;
    @Column(name="DATA_ANALISE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dataAnalise;
    @Column(name="OBS_ANALISE")
    @Size(min=1, max=512)
    private String obsAnalise;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODPONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPO_OCORRENCIA", referencedColumnName="ID", insertable=false, updatable=false)
    private TipoOcorrencia tipoOcorrencia;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Integer getPontoId() {
        return this.pontoId;
    }

    public void setPontoId(Integer pontoId) {
        this.pontoId = pontoId;
    }

    public Integer getTipoOcorrenciaId() {
        return this.tipoOcorrenciaId;
    }

    public void setTipoOcorrenciaId(Integer tipoOcorrenciaId) {
        this.tipoOcorrenciaId = tipoOcorrenciaId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Calendar getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Calendar dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public Calendar getDataAnalise() {
        return this.dataAnalise;
    }

    public void setDataAnalise(Calendar dataAnalise) {
        this.dataAnalise = dataAnalise;
    }

    public String getObsAnalise() {
        return this.obsAnalise;
    }

    public void setObsAnalise(String obsAnalise) {
        this.obsAnalise = obsAnalise;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        this.pontoId = ponto != null ? ponto.getCodigo() : null;
        this.ponto = ponto;
    }

    public TipoOcorrencia getTipoOcorrencia() {
        return this.tipoOcorrencia;
    }

    public void setTipoOcorrencia(TipoOcorrencia tipoOcorrencia) {
        this.tipoOcorrenciaId = tipoOcorrencia != null ? tipoOcorrencia.getId() : null;
        this.tipoOcorrencia = tipoOcorrencia;
    }

    public PontoWebStatus getStatusEnum() {
        return this.status != null ? PontoWebStatus.getBy(this.status) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoTrabOcorrencia that = (PontoTrabOcorrencia)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

