/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.TipoOcorrencia;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PONTO_TIPO_OCORRENCIA")
@SequenceGenerator(name="GEN_PONTO_TIPO_OCORRENCIA", sequenceName="GEN_PONTO_TIPO_OCORRENCIA", allocationSize=1)
@FilterConfigType(autoFilter=true)
@Audited
public class PontoTipoOcorrencia
implements Serializable {
    private static final long serialVersionUID = -212950756853322722L;
    public static final String FIND_BY_TIPO_PONTO = "SELECT pto FROM PontoTipoOcorrencia pto WHERE pto.ponto = :ponto and pto.tipoOcorrencia = :tipoOcorrencia";
    @Id
    @Column(name="ID")
    @GeneratedValue(generator="GEN_PONTO_TIPO_OCORRENCIA", strategy=GenerationType.AUTO)
    private Integer id;
    @Column(name="PONTO_ID")
    private Integer pontoId;
    @Column(name="TIPO_OCORRENCIA_ID")
    private Integer tipoOcorrenciaId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPO_OCORRENCIA_ID", referencedColumnName="ID", insertable=false, updatable=false)
    private TipoOcorrencia tipoOcorrencia;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.INNER)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PONTO_ID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @Type(type="BooleanTypeSip")
    @Column(name="INSERIDO_MANUAL")
    private Boolean inseridoManual;

    public PontoTipoOcorrencia(Builder builder) {
        this.setTipoOcorrencia(builder.tipoOcorrencia);
        this.setPonto(builder.ponto);
        this.setInseridoManual(builder.inseridoManualmente);
    }

    public Integer getPontoId() {
        return this.pontoId;
    }

    public void setPontoId(Integer pontoId) {
        this.pontoId = pontoId;
    }

    public Integer getTipoOcorrenciaId() {
        return this.tipoOcorrenciaId;
    }

    public void setTipoOcorrenciaId(Integer tipoOcorrenciaId) {
        this.tipoOcorrenciaId = tipoOcorrenciaId;
    }

    public TipoOcorrencia getTipoOcorrencia() {
        return this.tipoOcorrencia;
    }

    public void setTipoOcorrencia(TipoOcorrencia tipoOcorrencia) {
        this.tipoOcorrenciaId = tipoOcorrencia == null ? null : tipoOcorrencia.getId();
        this.tipoOcorrencia = tipoOcorrencia;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        this.pontoId = ponto == null ? null : ponto.getCodigo();
        this.ponto = ponto;
    }

    public Boolean getInseridoManual() {
        return this.inseridoManual;
    }

    public void setInseridoManual(Boolean inseridoManual) {
        this.inseridoManual = inseridoManual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.pontoId == null ? 0 : this.pontoId.hashCode());
        result = 31 * result + (this.tipoOcorrenciaId == null ? 0 : this.tipoOcorrenciaId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PontoTipoOcorrencia other = (PontoTipoOcorrencia)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.pontoId == null ? other.pontoId != null : !this.pontoId.equals(other.pontoId)) {
            return false;
        }
        return !(this.tipoOcorrenciaId == null ? other.tipoOcorrenciaId != null : !this.tipoOcorrenciaId.equals(other.tipoOcorrenciaId));
    }

    public String toString() {
        return "PontoTipoOcorrencia [id=" + this.id + ", pontoId=" + this.pontoId + ", tipoOcorrenciaId=" + this.tipoOcorrenciaId + "]";
    }

    public PontoTipoOcorrencia(Integer id, Integer pontoId, Integer tipoOcorrenciaId, TipoOcorrencia tipoOcorrencia, Ponto ponto, Boolean inseridoManual) {
        this.id = id;
        this.pontoId = pontoId;
        this.tipoOcorrenciaId = tipoOcorrenciaId;
        this.tipoOcorrencia = tipoOcorrencia;
        this.ponto = ponto;
        this.inseridoManual = inseridoManual;
    }

    public PontoTipoOcorrencia() {
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public static class Builder {
        private TipoOcorrencia tipoOcorrencia;
        private Ponto ponto;
        private boolean inseridoManualmente = true;

        public PontoTipoOcorrencia build() {
            return new PontoTipoOcorrencia(this);
        }

        public Builder withTipoOcorrencia(TipoOcorrencia tipoOcorrencia) {
            this.tipoOcorrencia = tipoOcorrencia;
            return this;
        }

        public Builder withPonto(Ponto ponto) {
            this.ponto = ponto;
            return this;
        }

        public Builder isInsertedAutomatilly() {
            this.inseridoManualmente = false;
            return this;
        }
    }
}

