/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Entity
@Table(name="PONTO_SOBRE_AVISO")
@SequenceGenerator(name="GEN_PONTO_SOBRE_AVISO", sequenceName="GEN_PONTO_SOBRE_AVISO", allocationSize=1)
@FilterConfigType(autoFilter=true, displayField=10)
@FilterConfigParameters(value={@FilterConfigParameter(id="matricula", fieldClass=Integer.class, fieldPath="trabalhador.", label="Matr\u00edcula", order=1), @FilterConfigParameter(id="nome", fieldClass=String.class, fieldPath="trabalhador.", condition=FilterCondition.CONTENHA, label="Nome", order=2)})
@Audited
public class PontoSobreAviso
implements Serializable {
    private static final long serialVersionUID = -4149493824541035831L;
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(generator="GEN_PONTO_SOBRE_AVISO", strategy=GenerationType.AUTO)
    private Integer id;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @FilterConfig(label="Registro", inputType=FilterInputType.NUMBER, order=3)
    @Column(name="REGISTRO")
    private String registro;
    @FilterConfig(label="Per. In\u00edcio", inputType=FilterInputType.CALENDAR, order=4, condition=FilterCondition.MAIOR_IGUAL)
    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataInicio;
    @FilterConfig(label="Per. Fim", inputType=FilterInputType.CALENDAR, order=5, condition=FilterCondition.MENOR_IGUAL)
    @Column(name="DATA_FIM")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataFim;
    @FilterConfig(label="Evento C\u00f3d.", inputType=FilterInputType.NUMBER, order=6)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.registro = trabalhador == null ? null : trabalhador.getTrabalhadorPK().getRegistro();
        this.trabalhador = trabalhador;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento == null ? null : evento.getEventoPK().getCodigo();
        this.evento = evento;
    }

    public boolean isNew() {
        return this.id == null;
    }

    public PontoSobreAviso withPeriodo(Date inicio, Date fim) {
        PontoSobreAviso sobreAviso = new PontoSobreAviso();
        sobreAviso.id = this.id;
        sobreAviso.dataInicio = inicio;
        sobreAviso.dataFim = fim;
        sobreAviso.entidadeCodigo = this.entidadeCodigo;
        sobreAviso.registro = this.registro;
        sobreAviso.eventoCodigo = this.eventoCodigo;
        return sobreAviso;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoSobreAviso that = (PontoSobreAviso)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.entidadeCodigo, that.entidadeCodigo) && Objects.equals(this.registro, that.registro) && Objects.equals(this.dataInicio, that.dataInicio) && Objects.equals(this.dataFim, that.dataFim) && Objects.equals(this.eventoCodigo, that.eventoCodigo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.entidadeCodigo, this.registro, this.dataInicio, this.dataFim, this.eventoCodigo);
    }

    public String toString() {
        return "PontoSobreAviso{id=" + this.id + ", entidadeCodigo='" + this.entidadeCodigo + '\'' + ", registro='" + this.registro + '\'' + ", dataInicio=" + this.dataInicio + ", dataFim=" + this.dataFim + ", eventoCodigo='" + this.eventoCodigo + '\'' + '}';
    }

    public String toStringPeriodo() {
        return "D\u00ea " + SIPDateUtil.toStringWithTime((Date)this.dataInicio) + " \u00e0 " + SIPDateUtil.toStringWithTime((Date)this.dataFim);
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)new DateTime((Object)this.dataInicio), (ReadableInstant)new DateTime((Object)this.dataFim));
    }
}

