/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

public enum PontoSituacao {
    ADMISSAO(0, "Admiss\u00e3o", "AD"),
    DEMISSAO(1, "Demiss\u00e3o", "DE"),
    FALTAS(2, "Falta", "FA"),
    FERIAS(3, "F\u00e9rias", "FE"),
    AFASTAMENTOS(4, "Afastamentos", "AF"),
    LICENCA_PREMIO(5, "Licen\u00e7a Pr\u00eamio", "LP"),
    HORAS_EXTRAS(6, "Horas Extras", "HE"),
    IMPLANTACAO(7, "Implanta\u00e7\u00e3o do Ponto", "IP"),
    NENHUM(8, "Nenhum", "NE"),
    INDEFINIDO(9, "Indefinido", "IN"),
    FERIAS_GOZO_ABONADA(10, "F\u00e9rias Gozo Abonada", "FA"),
    AFASTAMENTO_APOS_FERIAS(11, "Afastamentos ap\u00f3s F\u00e9rias", "AA");

    private final short codigo;
    private final String descricao;
    private final String descricaoAbreviada;

    private PontoSituacao(short codigo, String descricao, String descricaoAbreviada) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.descricaoAbreviada = descricaoAbreviada;
    }

    public short getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getDescricaoAbreviada() {
        return this.descricaoAbreviada;
    }

    public static PontoSituacao of(Short codigo) {
        if (codigo == null) {
            return null;
        }
        for (PontoSituacao ps : PontoSituacao.values()) {
            if (ps.getCodigo() != codigo.shortValue()) continue;
            return ps;
        }
        throw new IllegalArgumentException("N\u00e3o existe uma situa\u00e7\u00e3o do ponto com o valor " + codigo + ".");
    }

    public static String getLegenda() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < PontoSituacao.values().length; ++i) {
            PontoSituacao ps = PontoSituacao.values()[i];
            if (ps.isNenhum() || ps.isHorasExtras()) continue;
            sb.append(ps.descricaoAbreviada);
            sb.append(" - ");
            sb.append(ps.descricao);
            if (i + 1 >= PontoSituacao.values().length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public boolean isNenhum() {
        return this == NENHUM;
    }

    public boolean isHorasExtras() {
        return this == HORAS_EXTRAS;
    }

    public boolean isFalta() {
        return this == FALTAS;
    }

    public boolean isAnyAfastamento() {
        return this == AFASTAMENTO_APOS_FERIAS || this == AFASTAMENTOS;
    }

    public boolean isFerias() {
        return this == FERIAS;
    }

    public boolean isLicencaPremio() {
        return this == LICENCA_PREMIO;
    }

    public boolean isDemissao() {
        return this == DEMISSAO;
    }

    public boolean isAdmissao() {
        return this == ADMISSAO;
    }
}

