/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.enums.PontoWebTipo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public enum PontoMovimento {
    ENTRADA1("Entrada 1"),
    SAIDA1("Sa\u00edda 1"),
    ENTRADA2("Entrada 2"),
    SAIDA2("Sa\u00edda 2"),
    ENTRADA3("Entrada 3"),
    SAIDA3("Sa\u00edda 3"),
    ENTRADA4("Entrada 4"),
    SAIDA4("Sa\u00edda 4"),
    ENTRADA5("Entrada 5"),
    SAIDA5("Sa\u00edda 5");

    private final String descricao;

    private PontoMovimento(String descricao) {
        this.descricao = descricao;
    }

    public void set(Ponto ponto, String shora) {
        if (!this.isBatidasSame(ponto, shora)) {
            String setMovimento = String.format("set%s", this.capitalize());
            if (shora == null) {
                this.invokeSetWithNullParameter(ponto);
            } else {
                this.invokeMethod(ponto, setMovimento, shora);
            }
        }
    }

    public void set(Ponto ponto, String shora, Date dataReal) {
        if (!this.isBatidasSame(ponto, shora)) {
            String setMovimento = String.format("set%s", this.capitalize());
            String setMovimentoData = String.format("setData%s", this.capitalize());
            if (shora == null) {
                this.invokeSetWithNullParameter(ponto);
                this.invokeSetDataWithNullParameter(ponto);
            } else {
                this.invokeMethod(ponto, setMovimento, shora);
                this.invokeMethod(ponto, setMovimentoData, dataReal);
            }
        }
    }

    public static void setInEmpty(Ponto ponto, String hora, Date data) {
        if (ponto != null) {
            for (PontoMovimento movimento : PontoMovimento.values()) {
                if (movimento.get(ponto) != null) continue;
                movimento.set(ponto, hora, data);
                break;
            }
        }
    }

    public String get(Ponto ponto) {
        String getMovimento = String.format("get%s", this.capitalize());
        return (String)this.invokeMethod(ponto, getMovimento, new Object[0]);
    }

    public boolean isEmpty(Ponto ponto) {
        return StringUtils.isBlank((CharSequence)this.get(ponto));
    }

    public Boolean isAutomatic(Jornada jornada, JornadaDia jornadaDia) {
        try {
            String getMovimentoAutomatico = String.format("get%sAutomatica", this.capitalize());
            return jornada != null && jornadaDia != null ? (Boolean)this.invokeMethod(jornada, getMovimentoAutomatico, new Object[0]) : Boolean.FALSE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public Boolean isAutomatic(Jornada jornada, JornadaDia jornadaDia, Ponto ponto) {
        try {
            Boolean automatico;
            String getMovimentoAutomatico = String.format("get%sAutomatica", this.capitalize());
            Boolean bl = automatico = jornada != null ? (Boolean)this.invokeMethod(jornada, getMovimentoAutomatico, new Object[0]) : Boolean.FALSE;
            if (automatico.booleanValue()) {
                String hora = jornadaDia != null ? (String)this.invokeMethod(jornadaDia, String.format("get%s", this.capitalize()), new Object[0]) : "";
                String horaBatida = ponto != null ? this.get(ponto) : null;
                automatico = hora != null && horaBatida != null ? hora.equals(horaBatida) : Boolean.FALSE.booleanValue();
            }
            return automatico;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public String getAutomatic(JornadaDia jornadaDia) {
        if (jornadaDia == null) {
            return null;
        }
        String getMovimentoAutomatico = String.format("get%s", this.capitalize());
        return (String)this.invokeMethod(jornadaDia, getMovimentoAutomatico, new Object[0]);
    }

    public static List<Map<PontoMovimento, Interval>> getAutomaticIntervals(Jornada jornada, JornadaDia jornadaDia, Date data) {
        ArrayList<Map<PontoMovimento, Interval>> intervals = new ArrayList<Map<PontoMovimento, Interval>>();
        try {
            String firstHour = null;
            PontoMovimento firstMovimento = null;
            for (PontoMovimento movimento : PontoMovimento.values()) {
                if (!movimento.isAutomatic(jornada, jornadaDia).booleanValue()) continue;
                if (firstHour == null && firstMovimento == null) {
                    firstHour = movimento.getAutomatic(jornadaDia);
                    firstMovimento = movimento;
                    continue;
                }
                if (movimento.getAutomatic(jornadaDia) == null) continue;
                HashMap<PontoMovimento, Interval> map = new HashMap<PontoMovimento, Interval>();
                map.put(movimento, new Interval(TimeUtils.toDateTime((Date)data, (String)firstHour).getMillis(), TimeUtils.toDateTime((Date)data, (String)movimento.getAutomatic(jornadaDia)).getMillis()));
                intervals.add(map);
                firstHour = null;
                firstMovimento = null;
            }
            if (firstHour != null && firstMovimento != null) {
                HashMap<PontoMovimento, Interval> map = new HashMap<PontoMovimento, Interval>();
                map.put(firstMovimento, new Interval(TimeUtils.toDateTime((Date)data, firstHour).getMillis(), TimeUtils.toDateTime((Date)data, (String)firstHour).getMillis()));
                intervals.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intervals;
    }

    public boolean isBatidasSame(Ponto ponto, String shora) {
        String valor = this.get(ponto);
        if (shora == null) {
            return valor == null;
        }
        return shora.equals(valor);
    }

    public boolean isBetweenAAndB(JornadaDia jornadaDia, LocalTime batida) {
        String getMovimentoA = String.format("get%sa", this.capitalize());
        String getMovimentoB = String.format("get%sb", this.capitalize());
        String movimentoA = (String)this.invokeMethod(jornadaDia, getMovimentoA, new Object[0]);
        String movimentoB = (String)this.invokeMethod(jornadaDia, getMovimentoB, new Object[0]);
        if (StringUtils.isBlank((CharSequence)movimentoA) || StringUtils.isBlank((CharSequence)movimentoB)) {
            return false;
        }
        LocalTime movimentoADateTime = LocalTime.parse((String)movimentoA);
        LocalTime movimentoBDateTime = LocalTime.parse((String)movimentoB);
        return !(!batida.isAfter((ReadablePartial)movimentoADateTime) && !batida.isEqual((ReadablePartial)movimentoADateTime) || !batida.isBefore((ReadablePartial)movimentoBDateTime) && !batida.isEqual((ReadablePartial)movimentoBDateTime));
    }

    public boolean isPeriodoConfigurado(JornadaDia jornadaDia) throws Exception {
        String movimento = this.name();
        String numero = movimento.substring(movimento.length() - 1);
        if ("1".equals(numero)) {
            return true;
        }
        if (StringUtils.isNumeric((CharSequence)numero)) {
            String getPeriodo = String.format("getPeriodo%s", numero);
            return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.invokeMethod(jornadaDia, getPeriodo, new Object[0])), (boolean)false);
        }
        return false;
    }

    private String capitalize() {
        return StringUtils.capitalize((String)this.name().toLowerCase());
    }

    private Object invokeSetWithNullParameter(Ponto ponto) {
        String setMovimento = String.format("set%s", this.capitalize());
        Method methodMovimento = MethodUtils.getAccessibleMethod(Ponto.class, (String)setMovimento, (Class[])new Class[]{String.class});
        try {
            return methodMovimento.invoke((Object)ponto, new Object[]{null});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String msg = String.format("Ocorreu um erro ao atribuir um valor null pelo m\u00e9todo %s.", setMovimento);
            throw new RuntimeException(msg);
        }
    }

    private Object invokeSetDataWithNullParameter(Ponto ponto) {
        String setMovimentoData = String.format("setData%s", this.capitalize());
        Method methodMovimentoData = MethodUtils.getAccessibleMethod(Ponto.class, (String)setMovimentoData, (Class[])new Class[]{Date.class});
        try {
            return methodMovimentoData.invoke((Object)ponto, new Object[]{null});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String msg = String.format("Ocorreu um erro ao atribuir um valor null pelo m\u00e9todo %s.", setMovimentoData);
            throw new RuntimeException(msg);
        }
    }

    private Object invokeMethod(Object obj, String methodName, Object ... args) {
        try {
            return MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format("Ocorreu um erro ao executar o m\u00e9todo %s no objeto %s.", methodName, obj.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static PontoMovimento[] entradas() {
        return new PontoMovimento[]{ENTRADA1, ENTRADA2, ENTRADA3, ENTRADA4, ENTRADA5};
    }

    public static PontoMovimento[] saidas() {
        return new PontoMovimento[]{SAIDA1, SAIDA2, SAIDA3, SAIDA4, SAIDA5};
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Date getData(Ponto ponto) {
        String getMovimento = String.format("getData%s", this.capitalize());
        return (Date)this.invokeMethod(ponto, getMovimento, new Object[0]);
    }

    public void setData(Ponto ponto, Date data) {
        if (!this.isDataBatidaSame(ponto, data)) {
            String setMovimento = String.format("setData%s", this.capitalize());
            if (data == null) {
                this.invokeSetDataWithNullParameter(ponto);
            } else {
                this.invokeMethod(ponto, setMovimento, data);
            }
        }
    }

    public boolean isDataBatidaSame(Ponto ponto, Date data) {
        Date valor = this.getData(ponto);
        if (valor == null && data != null || data == null && valor != null) {
            return false;
        }
        if (valor == null && data == null) {
            return true;
        }
        return DateUtils.isSameDay((Date)data, (Date)valor);
    }

    public static PontoMovimento getLast() {
        return PontoMovimento.values()[PontoMovimento.values().length - 1];
    }

    public static PontoMovimento getBy(PontoWebTipo pontoWebTipo) {
        if (pontoWebTipo != null) {
            for (PontoMovimento movimento : PontoMovimento.values()) {
                if (movimento.ordinal() != pontoWebTipo.getId() - 1) continue;
                return movimento;
            }
        }
        return null;
    }

    public boolean isEntrada() {
        return Arrays.asList(PontoMovimento.entradas()).contains((Object)this);
    }

    public boolean isSaida() {
        return Arrays.asList(PontoMovimento.saidas()).contains((Object)this);
    }

    public static enum PontoMovimentoIntervalo {
        INTERVALO1(SAIDA1, ENTRADA2),
        INTERVALO2(SAIDA2, ENTRADA3),
        INTERVALO3(SAIDA3, ENTRADA4),
        INTERVALO4(SAIDA4, ENTRADA5);

        private final PontoMovimento saida;
        private final PontoMovimento entrada;

        private PontoMovimentoIntervalo(PontoMovimento saida, PontoMovimento entrada) {
            this.saida = saida;
            this.entrada = entrada;
        }

        public PontoMovimento getSaida() {
            return this.saida;
        }

        public PontoMovimento getEntrada() {
            return this.entrada;
        }

        public static PontoMovimentoIntervalo of(PontoMovimento movimento) {
            for (PontoMovimentoIntervalo intervalo : PontoMovimentoIntervalo.values()) {
                if (!intervalo.getSaida().equals((Object)movimento) && !intervalo.getEntrada().equals((Object)movimento)) continue;
                return intervalo;
            }
            return null;
        }
    }
}

