/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoMotivoOcorrencia;
import br.com.fiorilli.sip.persistence.entity.PontoMovimento;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_MOTIVO")
public class PontoMotivo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_PONTOMOTIVO";
    public static final String FIND_ALL_MOTIVOS_ALTERACAO_VO = "SELECT DISTINCT new br.com.fiorilli.sip.persistence.vo.cartaoponto.PontoMotivoAlteracaoVo(pm.motivo, pm.ocorrencia) FROM PontoMotivo pm ";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="CAMPO")
    private PontoMovimento campo;
    @Size(max=5)
    @Column(name="HBATIDA")
    private String horaBatida;
    @Size(max=150)
    @Column(name="MOTIVO")
    private String motivo;
    @Column(name="OCORRENCIA")
    private Character ocorrencia;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="CODPONTO")
    private Integer pontoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODPONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @Transient
    private String horaBatidaAnterior;

    public PontoMotivo() {
    }

    public PontoMotivo(Integer id) {
        this.id = id;
    }

    public static PontoMotivo of(Ponto ponto, String oldValue) {
        PontoMotivo motivo = new PontoMotivo();
        if (oldValue != null) {
            if (oldValue.equals(ponto.getEntrada1())) {
                motivo.data = ponto.getDataEntrada1();
            } else if (oldValue.equals(ponto.getSaida1())) {
                motivo.data = ponto.getDataSaida1();
            } else if (oldValue.equals(ponto.getEntrada2())) {
                motivo.data = ponto.getDataEntrada2();
            } else if (oldValue.equals(ponto.getSaida2())) {
                motivo.data = ponto.getDataSaida2();
            } else if (oldValue.equals(ponto.getEntrada3())) {
                motivo.data = ponto.getDataEntrada3();
            } else if (oldValue.equals(ponto.getSaida3())) {
                motivo.data = ponto.getDataSaida3();
            } else if (oldValue.equals(ponto.getEntrada4())) {
                motivo.data = ponto.getDataEntrada4();
            } else if (oldValue.equals(ponto.getSaida4())) {
                motivo.data = ponto.getDataSaida4();
            } else if (oldValue.equals(ponto.getEntrada5())) {
                motivo.data = ponto.getDataEntrada5();
            } else if (oldValue.equals(ponto.getSaida5())) {
                motivo.data = ponto.getDataSaida5();
            }
        }
        if (motivo.data == null) {
            motivo.data = ponto.getData();
        }
        motivo.pontoCodigo = ponto.getCodigo();
        motivo.entidadeCodigo = ponto.getEntidadeCodigo();
        motivo.registro = ponto.getRegistro();
        return motivo;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PontoMovimento getCampo() {
        return this.campo;
    }

    public void setCampo(PontoMovimento campo) {
        this.campo = campo;
    }

    public String getHoraBatida() {
        return this.horaBatida;
    }

    public void setHoraBatida(String hbatida) {
        this.horaBatida = hbatida;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public PontoMotivoOcorrencia getOcorrencia() {
        return PontoMotivoOcorrencia.of(this.ocorrencia);
    }

    public void setOcorrencia(PontoMotivoOcorrencia ocorrencia) {
        this.ocorrencia = ocorrencia == null ? null : Character.valueOf(ocorrencia.getCodigo());
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        this.ponto = ponto;
    }

    public Integer getPontoCodigo() {
        return this.pontoCodigo;
    }

    public void setPontoCodigo(Integer pontoCodigo) {
        this.pontoCodigo = pontoCodigo;
    }

    public String getHoraBatidaAnterior() {
        return this.horaBatidaAnterior;
    }

    public void setHoraBatidaAnterior(String horaBatidaAnterior) {
        this.horaBatidaAnterior = horaBatidaAnterior;
    }

    public Date getDataHora() {
        return SIPDateUtil.toDate((String)"dd/MM/yyyy HH:mm", (String)String.format("%s %s", SIPDateUtil.toString((Date)this.data), this.horaBatida));
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PontoMotivo)) {
            return false;
        }
        PontoMotivo other = (PontoMotivo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.PontoMotivo[ id=" + this.id + " ]";
    }
}

