/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.AuditIdentifierField;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CalculoPontoFase;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoMesPK;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.joda.time.Duration;

@Entity
@Table(name="PONTO_MES")
@Audited(insert=false, update=false)
public class PontoMes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_PONTOMES_DO_TRABALHADOR = "select distinct pm from PontoMes pm where pm.pontoMesPK.entidade = :entidade and pm.pontoMesPK.registro = :registro and pm.pontoMesPK.referencia = :referencia and pm.incorporarCalculoFolha = false ";
    public static final String GET_PONTOMES_DEMITIDOS_BY_REFERENCIA = "SELECT pm FROM PontoMes pm join pm.referencia r join pm.trabalhador t WHERE pm.pontoMesPK.entidade = :entidade       AND r.codigo = :referencia       AND (t.dataDemissao IS NOT NULL AND t.dataDemissao < r.primeiroDiaFreq) ";
    @EmbeddedId
    protected PontoMesPK pontoMesPK;
    @Type(type="DoubleAsTime")
    @Column(name="HRNORMAL")
    private Duration horasNormais;
    @Type(type="DoubleAsTime")
    @Column(name="HRTRABALHADA")
    private Duration horasTrabalhadas;
    @Type(type="DoubleAsTime")
    @Column(name="HRNOTURNA")
    private Duration horasNoturnas;
    @Type(type="DoubleAsTime")
    @Column(name="HRAULA")
    private Duration horasAulas;
    @NotNull
    @Size(min=1, max=4)
    @Basic(optional=false)
    @Column(name="CARGO")
    private String cargoCodigo;
    @Size(min=1, max=6)
    @Column(name="DIVISAO")
    private String divisaoCodigo;
    @Size(min=1, max=6)
    @Column(name="SUBDIVISAO")
    private String subdivisaoCodigo;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @Size(min=1, max=2)
    @Column(name="VINCULO")
    private String vinculoCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @Size(min=1, max=6)
    @Column(name="LOCAL_TRABALHO")
    private String localTrabalhoCodigo;
    @Type(type="BooleanTypeSip")
    @Column(name="INCORPORAR_CALCULO_FOLHA")
    private Boolean incorporarCalculoFolha;
    @Column(name="FASE_CALCULO")
    private CalculoPontoFase fase;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Divisao divisao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="SUBDIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Subdivisao subdivisao;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Vinculo vinculo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Jornada jornada;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCAL_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private LocalTrabalho localTrabalho;
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referencia;
    @OneToMany(mappedBy="pontoMes", fetch=FetchType.LAZY)
    private List<Ponto> pontos;
    @Column(name="GRUPO_PONTO")
    private Short grupoPontoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="GRUPO_PONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private GrupoPonto grupoPonto;
    @Transient
    private boolean newPontoMes = false;
    @Transient
    private boolean manuallyAction;

    public PontoMes() {
    }

    public PontoMes(PontoMesPK pontoMesPK) {
        this.pontoMesPK = pontoMesPK;
    }

    public PontoMes(String entidade, String registro, int referencia) {
        this.pontoMesPK = new PontoMesPK(entidade, registro, referencia);
    }

    public PontoMes(Builder builder) {
        PontoMesPK pk = new PontoMesPK(builder.entidade, builder.registro, builder.referencia);
        this.setPontoMesPK(pk);
        this.jornadaCodigo = builder.jornada;
        this.cargoCodigo = builder.cargo;
        this.divisaoCodigo = builder.divisao;
        this.subdivisaoCodigo = builder.subdivisao;
        this.unidadeCodigo = builder.unidade;
        this.vinculoCodigo = builder.vinculo;
        this.localTrabalhoCodigo = builder.localTrabalho;
        this.grupoPontoCodigo = builder.grupoPonto;
        this.horasNormais = builder.horasNormais;
        this.horasTrabalhadas = builder.horasTrabalhadas;
        this.horasNoturnas = builder.horasNoturnas;
        this.horasAulas = builder.horasAulas;
        this.incorporarCalculoFolha = builder.incorporarCalculoFolha;
        this.newPontoMes = builder.newPontoMes;
        if (!this.incorporarCalculoFolha.booleanValue()) {
            this.fase = CalculoPontoFase.NAO_CALCUALDO;
        }
    }

    public static PontoMes createBlankWithIncorporar(boolean b) {
        PontoMes pontoMes = new PontoMes();
        pontoMes.setIncorporarCalculoFolha(true);
        return pontoMes;
    }

    public void setNewPontoMes(boolean newPontoMes) {
        this.newPontoMes = newPontoMes;
    }

    public boolean isNewPontoMes() {
        return this.newPontoMes;
    }

    public PontoMesPK getPontoMesPK() {
        return this.pontoMesPK;
    }

    public void setPontoMesPK(PontoMesPK pontoMesPK) {
        this.pontoMesPK = pontoMesPK;
    }

    public Duration getHorasNormais() {
        return this.horasNormais;
    }

    public void setHorasNormais(Duration hrnormal) {
        this.horasNormais = hrnormal;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    @AuditIdentifierField
    public boolean isManuallyAction() {
        return this.manuallyAction;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pontoMesPK != null ? this.pontoMesPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PontoMes)) {
            return false;
        }
        PontoMes other = (PontoMes)object;
        return (this.pontoMesPK != null || other.pontoMesPK == null) && (this.pontoMesPK == null || this.pontoMesPK.equals(other.pontoMesPK));
    }

    public String toString() {
        return "entity.PontoMes[ pontoMesPK=" + this.pontoMesPK + " ]";
    }

    public Duration getHorasTrabalhadas() {
        return this.horasTrabalhadas;
    }

    public void setHorasTrabalhadas(Duration horaTrabalhada) {
        this.horasTrabalhadas = horaTrabalhada;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public void setDivisaoCodigo(String divisaoCodigo) {
        this.divisaoCodigo = divisaoCodigo;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public void setSubdivisaoCodigo(String subdivisaoCodigo) {
        this.subdivisaoCodigo = subdivisaoCodigo;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculoCodigo) {
        this.vinculoCodigo = vinculoCodigo;
    }

    public String getLocalTrabalhoCodigo() {
        return this.localTrabalhoCodigo;
    }

    public void setLocalTrabalhoCodigo(String localTrabalhoCodigo) {
        this.localTrabalhoCodigo = localTrabalhoCodigo;
    }

    public Duration getHorasNoturnas() {
        return this.horasNoturnas;
    }

    public void setHorasNoturnas(Duration horaNoturna) {
        this.horasNoturnas = horaNoturna;
    }

    public Boolean getIncorporarCalculoFolha() {
        return this.incorporarCalculoFolha;
    }

    public void setIncorporarCalculoFolha(Boolean incorporarCalculoFolha) {
        this.incorporarCalculoFolha = incorporarCalculoFolha;
    }

    public Duration getHorasAulas() {
        return this.horasAulas;
    }

    public void setHorasAulas(Duration horaAula) {
        this.horasAulas = horaAula;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    public Divisao getDivisao() {
        return this.divisao;
    }

    public void setDivisao(Divisao divisao) {
        this.divisao = divisao;
    }

    public Subdivisao getSubdivisao() {
        return this.subdivisao;
    }

    public void setSubdivisao(Subdivisao subdivisao) {
        this.subdivisao = subdivisao;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        this.vinculo = vinculo;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornada = jornada;
    }

    public LocalTrabalho getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalho localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referencia = referencia;
    }

    public List<Ponto> getPontos() {
        return this.pontos;
    }

    public void setPontos(List<Ponto> pontos) {
        this.pontos = pontos;
    }

    public CalculoPontoFase getFase() {
        return this.fase;
    }

    public void setFase(CalculoPontoFase fase) {
        this.fase = fase;
    }

    public Short getGrupoPontoCodigo() {
        return this.grupoPontoCodigo;
    }

    public void setGrupoPontoCodigo(Short grupoPontoCodigo) {
        this.grupoPontoCodigo = grupoPontoCodigo;
    }

    public GrupoPonto getGrupoPonto() {
        return this.grupoPonto;
    }

    public void setGrupoPonto(GrupoPonto grupoPonto) {
        this.grupoPonto = grupoPonto;
    }

    public void setManuallyAction(boolean manuallyAction) {
        this.manuallyAction = manuallyAction;
    }

    public static class Builder {
        private String entidade;
        private String registro;
        private Integer referencia;
        private Short jornada;
        private String cargo;
        private String divisao;
        private String subdivisao;
        private Integer unidade;
        private String vinculo;
        private String localTrabalho;
        private Boolean incorporarCalculoFolha;
        private Short grupoPonto;
        private Duration horasNormais = Duration.ZERO;
        private Duration horasTrabalhadas = Duration.ZERO;
        private Duration horasNoturnas = Duration.ZERO;
        private Duration horasAulas = Duration.ZERO;
        private boolean newPontoMes = false;

        public PontoMes build() {
            return new PontoMes(this);
        }

        public Builder entidade(String entidade) {
            this.entidade = entidade;
            return this;
        }

        public Builder registro(String registro) {
            this.registro = registro;
            return this;
        }

        public Builder referencia(Integer referencia) {
            this.referencia = referencia;
            return this;
        }

        public Builder jornada(Short jornada) {
            this.jornada = jornada;
            return this;
        }

        public Builder cargo(String cargo) {
            this.cargo = cargo;
            return this;
        }

        public Builder divisao(String divisao) {
            this.divisao = divisao;
            return this;
        }

        public Builder subdivisao(String subdivisao) {
            this.subdivisao = subdivisao;
            return this;
        }

        public Builder unidade(Integer unidade) {
            this.unidade = unidade;
            return this;
        }

        public Builder vinculo(String vinculo) {
            this.vinculo = vinculo;
            return this;
        }

        public Builder localTrabalho(String localTrabalho) {
            this.localTrabalho = localTrabalho;
            return this;
        }

        public Builder horaNormal(Duration horasNormais) {
            this.horasNormais = horasNormais;
            return this;
        }

        public Builder horaTrabalhada(Duration horasTrabalhadas) {
            this.horasTrabalhadas = horasTrabalhadas;
            return this;
        }

        public Builder horaNoturna(Duration horasNoturnas) {
            this.horasNoturnas = horasNoturnas;
            return this;
        }

        public Builder horaAula(Duration horasAulas) {
            this.horasAulas = horasAulas;
            return this;
        }

        public Builder incorporarCalculoFolha(Boolean incorporarCalculoFolha) {
            this.incorporarCalculoFolha = incorporarCalculoFolha;
            return this;
        }

        public Builder grupoPonto(Short grupoPonto) {
            this.grupoPonto = grupoPonto;
            return this;
        }

        public Builder newPontoMes(boolean newPontoMes) {
            this.newPontoMes = newPontoMes;
            return this;
        }
    }
}

