/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.PontoColunaExtra;
import br.com.fiorilli.sip.persistence.entity.PontoManutecaoParamColumnLabelTipo;
import br.com.fiorilli.sip.persistence.entity.PontoManutencaoParamPK;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PTO_MANU_PARAM")
@IdClass(value=PontoManutencaoParamPK.class)
@Audited
public class PontoManutencaoParam
implements Serializable {
    private static final long serialVersionUID = 7765757059828293248L;
    @Id
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Id
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Size(max=15)
    @Column(name="COLUMN_LABEL")
    private String columnLabel;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TIPO")
    private PontoManutecaoParamColumnLabelTipo tipo;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="configuracao", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoColunaExtra> colunasExtras;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;
    @Column
    private Integer ordem;

    public PontoManutencaoParam() {
    }

    public PontoManutencaoParam(String entidadeCodigo, Evento evento) {
        this.entidadeCodigo = entidadeCodigo;
        this.setEvento(evento);
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public void setColumnLabel(String columnLabel) {
        this.columnLabel = columnLabel;
    }

    public PontoManutecaoParamColumnLabelTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(PontoManutecaoParamColumnLabelTipo tipo) {
        this.tipo = tipo;
    }

    public List<PontoColunaExtra> getColunasExtras() {
        return this.colunasExtras;
    }

    public void setColunasExtras(List<PontoColunaExtra> colunasExtras) {
        this.colunasExtras = colunasExtras;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento == null) {
            this.eventoCodigo = null;
            this.entidadeCodigo = null;
        } else {
            this.eventoCodigo = evento.getEventoPK().getCodigo();
            this.entidadeCodigo = evento.getEventoPK().getEntidade();
        }
        this.evento = evento;
    }

    public Integer getOrdem() {
        return this.ordem;
    }

    public void setOrdem(Integer ordem) {
        this.ordem = ordem;
    }

    public String toString() {
        return "PontoManutecaoParam [entidadeCodigo=" + this.entidadeCodigo + ", eventoCodigo=" + this.eventoCodigo + ", columnLabel=" + this.columnLabel + ", tipo=" + (Object)((Object)this.tipo) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        result = 31 * result + (this.eventoCodigo == null ? 0 : this.eventoCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PontoManutencaoParam other = (PontoManutencaoParam)obj;
        if (this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo)) {
            return false;
        }
        return !(this.eventoCodigo == null ? other.eventoCodigo != null : !this.eventoCodigo.equals(other.eventoCodigo));
    }

    public PontoManutencaoParamPK getPK() {
        return new PontoManutencaoParamPK(this.entidadeCodigo, this.eventoCodigo);
    }
}

