/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.PontoFacultativo;
import br.com.fiorilli.sip.persistence.entity.PontoFacultativoNominalPK;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_FACULTATIVO_NOMINAL")
@IdClass(value=PontoFacultativoNominalPK.class)
@FilterConfigType(autoFilter=true, rootEntityAlias="pn", query="select $R{[pn.registro], [pn]} from PontoFacultativoNominal pn left join fetch pn.trabalhador tr left join fetch pn.pontoFacultativo pf where 1=1 AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[cargo],[tr.cargo],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[unidade],[tr.unidade],[:unidade]} AND $P{[data], [pn.data], [:data]} ", displayField=6)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, order=1), @FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.NUMBER, order=4), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano", order=5), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=6)})
@Audited
public class PontoFacultativoNominal
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY = "select $R{[pn.registro], [pn]} from PontoFacultativoNominal pn left join fetch pn.trabalhador tr left join fetch pn.pontoFacultativo pf where 1=1 AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[cargo],[tr.cargo],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[unidade],[tr.unidade],[:unidade]} AND $P{[data], [pn.data], [:data]} ";
    @Id
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Id
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Id
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=5)
    @Column(name="PERIODOINICIAL")
    private String periodoInicial;
    @Size(max=5)
    @Column(name="PERIODOFINAL")
    private String periodoFinal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DATA", referencedColumnName="DATA", insertable=false, updatable=false)})
    private PontoFacultativo pontoFacultativo;

    public PontoFacultativoNominal() {
    }

    public PontoFacultativoNominal(String entidadeCodigo, String registro, Date data, String periodoInicial, String periodoFinal) {
        this.entidadeCodigo = entidadeCodigo;
        this.registro = registro;
        this.data = data;
        this.periodoInicial = periodoInicial;
        this.periodoFinal = periodoFinal;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.registro = trabalhador == null ? null : trabalhador.getTrabalhadorPK().getRegistro();
        this.trabalhador = trabalhador;
    }

    public PontoFacultativo getPontoFacultativo() {
        return this.pontoFacultativo;
    }

    public void setPontoFacultativo(PontoFacultativo pontoFacultativo) {
        this.data = pontoFacultativo == null ? null : pontoFacultativo.getPontofacultativoPK().getData();
        this.pontoFacultativo = pontoFacultativo;
    }

    public String getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(String periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    public String getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(String periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PontoFacultativoNominal other = (PontoFacultativoNominal)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo)) {
            return false;
        }
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public String toString() {
        return "PontoFacultativoNominal [entidadeCodigo=" + this.entidadeCodigo + ", registro=" + this.registro + ", data=" + this.data + "]";
    }

    public PontoFacultativoNominalPK getPK() {
        return new PontoFacultativoNominalPK(this.entidadeCodigo, this.registro, this.data);
    }

    public PontoFacultativoNominal withRegistro(String registro) {
        return new PontoFacultativoNominal(this.entidadeCodigo, registro, this.data, this.periodoInicial, this.periodoFinal);
    }
}

