/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.PontoFacultativoNominal;
import br.com.fiorilli.sip.persistence.entity.PontoFacultativoPK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PONTOFACULTATIVO")
@Audited
public class PontoFacultativo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_PERIODO = "SELECT p FROM PontoFacultativo p WHERE p.pontofacultativoPK.data BETWEEN :periodoInicio AND :periodoFim";
    public static final String GET_FETCHED = "SELECT p FROM PontoFacultativo p LEFT JOIN FETCH p.evento LEFT JOIN FETCH p.tipoLegal WHERE p.pontofacultativoPK = :pk";
    @EmbeddedId
    protected PontoFacultativoPK pontofacultativoPK;
    @FilterConfig(label="Motivo", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="MOTIVO")
    private String motivo;
    @Size(max=5)
    @Column(name="PERIODOINICIAL")
    private String periodoInicial;
    @Size(max=5)
    @Column(name="PERIODOFINAL")
    private String periodoFinal;
    @Column(name="DTDOCUMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;
    @Size(max=16)
    @Column(name="NUMDOCUMENTO")
    private String numeroDocumento;
    @Size(max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @OneToMany(mappedBy="pontoFacultativo", fetch=FetchType.LAZY)
    private List<PontoFacultativoNominal> pontoFacultativoNominal;
    @Type(type="BooleanTypeSip")
    @Column(name="APENAS_NOMINAIS")
    private Boolean apenasNominais;
    @Type(type="BooleanTypeSip")
    @Column(name="PAGAR_HORAS_NORMAIS")
    private Boolean pagarHorasNormais;
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidadeCodigo;

    public PontoFacultativo(PontoFacultativoPK pontofacultativoPK, String motivo, String periodoInicial, String periodoFinal, Date dataDocumento, Integer tipoLegalCodigo, String numeroDocumento, String eventoCodigo, Boolean pagarHorasNormais) {
        this.pontofacultativoPK = pontofacultativoPK;
        this.motivo = motivo;
        this.periodoInicial = periodoInicial;
        this.periodoFinal = periodoFinal;
        this.dataDocumento = dataDocumento;
        this.tipoLegalCodigo = tipoLegalCodigo;
        this.numeroDocumento = numeroDocumento;
        this.eventoCodigo = eventoCodigo;
        this.pagarHorasNormais = pagarHorasNormais;
    }

    public PontoFacultativo() {
        this.pontofacultativoPK = new PontoFacultativoPK();
        this.pagarHorasNormais = true;
    }

    public PontoFacultativo(PontoFacultativoPK pontofacultativoPK) {
        this.pontofacultativoPK = pontofacultativoPK;
        this.pagarHorasNormais = true;
    }

    public PontoFacultativo(String entidade, Date data) {
        this.pontofacultativoPK = new PontoFacultativoPK(entidade, data);
        this.pagarHorasNormais = true;
    }

    public PontoFacultativoPK getPontofacultativoPK() {
        return this.pontofacultativoPK;
    }

    public void setPontofacultativoPK(PontoFacultativoPK pontofacultativoPK) {
        this.pontofacultativoPK = pontofacultativoPK;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public String getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(String periodoinicial) {
        this.periodoInicial = periodoinicial;
    }

    public String getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(String periodofinal) {
        this.periodoFinal = periodofinal;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dtdocumento) {
        this.dataDocumento = dtdocumento;
    }

    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipolegal) {
        this.tipoLegalCodigo = tipolegal;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numdocumento) {
        this.numeroDocumento = numdocumento;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String evento) {
        this.eventoCodigo = evento;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pontofacultativoPK != null ? this.pontofacultativoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PontoFacultativo)) {
            return false;
        }
        PontoFacultativo other = (PontoFacultativo)object;
        return (this.pontofacultativoPK != null || other.pontofacultativoPK == null) && (this.pontofacultativoPK == null || this.pontofacultativoPK.equals(other.pontofacultativoPK));
    }

    public String toString() {
        return "entity.Pontofacultativo[ pontofacultativoPK=" + this.pontofacultativoPK + " ]";
    }

    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.getEventoPK().getCodigo() : null;
        this.evento = evento;
    }

    public Interval getInterval() throws IllegalArgumentException {
        DateTime dtStart = TimeUtils.toDateTime((Date)this.pontofacultativoPK.getData(), (String)this.periodoInicial);
        DateTime dtEnd = TimeUtils.toDateTime((Date)this.pontofacultativoPK.getData(), (String)this.periodoFinal);
        if (dtStart != null && dtEnd != null) {
            try {
                return new Interval((ReadableInstant)dtStart, (ReadableInstant)dtEnd);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Erro ao tentar recupera o intervalo de um periodo, onde o periodo inicial \u00e9 maior que o periodo final. |Entidade: " + PontoFacultativo.class.getSimpleName() + " ou " + PontoFacultativoNominal.class.getSimpleName() + "|\n|PK: " + (this.getPontofacultativoPK() == null ? null : this.getPontofacultativoPK()) + "|\n|Periodo Inicial: " + new SimpleDateFormat("dd/MM/yyyy:HH:mm a").format(dtStart.toDate()) + "|" + "\n|Periodo Final: " + new SimpleDateFormat("dd/MM/yyyy:HH:mm a").format(dtEnd.toDate()) + "|" + e.getMessage());
            }
        }
        return null;
    }

    public Interval getInterval12x36() throws IllegalArgumentException {
        DateTime dtStart = TimeUtils.toDateTime((Date)this.pontofacultativoPK.getData(), (String)this.periodoInicial);
        DateTime dtEnd = TimeUtils.toDateTime((Date)this.pontofacultativoPK.getData(), (String)this.periodoFinal);
        DateTime dtNova = dtEnd.plusDays(1);
        if (dtStart != null && dtNova != null) {
            try {
                return new Interval((ReadableInstant)dtStart, (ReadableInstant)dtNova);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Erro ao tentar recupera o intervalo de um periodo, onde o periodo inicial \u00e9 maior que o periodo final. |Entidade: " + PontoFacultativo.class.getSimpleName() + " ou " + PontoFacultativoNominal.class.getSimpleName() + "|\n|PK: " + (this.getPontofacultativoPK() == null ? null : this.getPontofacultativoPK()) + "|\n|Periodo Inicial: " + new SimpleDateFormat("dd/MM/yyyy:HH:mm a").format(dtStart.toDate()) + "|" + "\n|Periodo Final: " + new SimpleDateFormat("dd/MM/yyyy:HH:mm a").format(dtEnd.toDate()) + "|" + e.getMessage());
            }
        }
        return null;
    }

    public Boolean getApenasNominais() {
        return this.apenasNominais;
    }

    public void setApenasNominais(Boolean apenasNominais) {
        this.apenasNominais = apenasNominais;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public Boolean getPagarHorasNormais() {
        return this.pagarHorasNormais;
    }

    public void setPagarHorasNormais(Boolean pagarHorasNormais) {
        this.pagarHorasNormais = pagarHorasNormais;
    }
}

