/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.EventoClassificacao;

public enum PontoEventoTipo {
    HORA_EXTRA('D'),
    FALTA('F'),
    HORA_AULA('G'),
    ADICIONAL_NOTURNO('A'),
    VALE_ALIMENTACAO('V');

    private final char id;

    private PontoEventoTipo(char id) {
        this.id = id;
    }

    public char getId() {
        return this.id;
    }

    public static PontoEventoTipo of(Character id) {
        if (PontoEventoTipo.HORA_EXTRA.id == id.charValue()) {
            return HORA_EXTRA;
        }
        if (PontoEventoTipo.FALTA.id == id.charValue()) {
            return FALTA;
        }
        if (PontoEventoTipo.HORA_AULA.id == id.charValue()) {
            return HORA_AULA;
        }
        if (PontoEventoTipo.ADICIONAL_NOTURNO.id == id.charValue()) {
            return ADICIONAL_NOTURNO;
        }
        if (PontoEventoTipo.VALE_ALIMENTACAO.id == id.charValue()) {
            return VALE_ALIMENTACAO;
        }
        return null;
    }

    public static boolean isAdicionalNoturno(Character id) {
        return PontoEventoTipo.ADICIONAL_NOTURNO.id == id.charValue();
    }

    public static boolean isHoraExtra(Character id) {
        return PontoEventoTipo.HORA_EXTRA.id == id.charValue();
    }

    public static boolean isFalta(Character tipo) {
        return PontoEventoTipo.FALTA.id == tipo.charValue();
    }

    public static boolean isValeAlimentacao(Character id) {
        return PontoEventoTipo.VALE_ALIMENTACAO.id == id.charValue();
    }

    public static PontoEventoTipo of(EventoClassificacao classificacao) {
        if (classificacao.isHoraExtra()) {
            return HORA_EXTRA;
        }
        if (classificacao.isFalta() || classificacao.isFaltaAbonada(true)) {
            return FALTA;
        }
        if (classificacao.isAdicionalNoturno()) {
            return ADICIONAL_NOTURNO;
        }
        if (classificacao.isHoraAula()) {
            return HORA_AULA;
        }
        if (classificacao.isValeAlimentacao()) {
            return VALE_ALIMENTACAO;
        }
        return null;
    }
}

