/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Embeddable
public class PontoEventoPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Column(name="CODPONTO")
    private Integer ponto;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String evento;
    @Transient
    private String eventoOriginal;

    protected void updateEventoOriginal() {
        this.eventoOriginal = this.evento;
    }

    public PontoEventoPK() {
    }

    public PontoEventoPK(Integer codponto, String evento) {
        this.ponto = codponto;
        this.evento = evento;
    }

    public Integer getPonto() {
        return this.ponto;
    }

    public void setPonto(Integer codponto) {
        this.ponto = codponto;
    }

    public String getEvento() {
        return this.evento;
    }

    public void setEvento(String evento) {
        this.evento = evento;
    }

    public String getEventoOriginal() {
        return this.eventoOriginal;
    }

    public boolean isChanged() {
        return !this.evento.equals(this.eventoOriginal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoEventoPK that = (PontoEventoPK)o;
        return this.ponto.equals(that.ponto) && this.evento.equals(that.evento);
    }

    public int hashCode() {
        return Objects.hash(this.ponto, this.evento);
    }

    public String toString() {
        return "PontoEventoPK{ponto=" + this.ponto + ", evento='" + this.evento + '\'' + ", eventoOriginal='" + this.eventoOriginal + '\'' + '}';
    }
}

