/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.AuditIdentifierField;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BancoHorasParametros;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoEventoPK;
import br.com.fiorilli.sip.persistence.entity.PontoEventoTipo;
import br.com.fiorilli.sip.persistence.entity.PontoMes;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.enums.StatusEventosPonto;
import br.com.fiorilli.sip.persistence.enums.ponto.PontoEventoDestino;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Entity
@Table(name="PONTO_EVENTOS")
@FilterConfigType(autoFilter=true, displayField=5)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", fieldPath="trabalhador.", label="Matricula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", fieldPath="trabalhador.", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", fieldPath="trabalhador.", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=4), @FilterConfigParameter(fieldClass=Evento.class, id="evento", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome", order=5), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", fieldPath="trabalhador.", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", fieldPath="trabalhador.", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", fieldPath="trabalhador.", label="SubDivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", fieldPath="trabalhador.", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo")})
@Audited
public class PontoEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_HORAS_EXTRAS_VO = "SELECT t.matricula, t.nome, d.nome, e.nome, pt.data, p.quantidade FROM Ponto pt JOIN pt.eventos p JOIN p.trabalhador t JOIN p.evento e JOIN t.divisao d WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND e.classificacao = '01' AND pt.data BETWEEN :periodoInicio AND :periodoFim AND COALESCE(:matricula, t.matricula) = t.matricula  ORDER BY t.matricula";
    public static final String SUM_QUANTIDADE = "SELECT COALESCE(SUM(pe.quantidade), 0) FROM PontoEvento pe LEFT JOIN pe.ponto po LEFT JOIN po.trabalhador tr LEFT JOIN pe.evento ev WHERE tr = :trabalhador AND po.data BETWEEN :dataInicio AND :dataFim AND ev = :evento AND tr.bancoHorasTrabalhador = 'S' AND ev.bancoHorasEvento = 'S'";
    public static final String FIND_ACJEF = "SELECT pe.pontoEventoPK.ponto AS pontoCodigo, ev.classificacao AS classificacao, pe.quantidade AS quantidade, COALESCE(ev.formula.percentual, 0.0) AS percentual FROM PontoEvento pe LEFT JOIN pe.evento ev WHERE pe.pontoEventoPK.ponto BETWEEN :de AND :ate ORDER BY pe.registro ";
    @EmbeddedId
    protected PontoEventoPK pontoEventoPK;
    @Type(type="DoubleAsTime")
    @Column(name="QTDE")
    private Duration quantidade;
    @Column(name="QUANTIDADE_MILLIS")
    private Long quantidadeMillis;
    @Type(type="DoubleAsTime")
    @Column(name="QTD_ANTIGA")
    private Duration quantidadeAntiga;
    @Column(name="TIPO")
    private Character tipo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="REFERENCIA")
    private Integer referenciaCodigo;
    @Size(min=1, max=3)
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String eventoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    @FilterConfigJoin(type=FilterJoinType.INNER, fetch=true)
    private Trabalhador trabalhador;
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private Referencia referencia;
    @JoinColumn(name="CODPONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    @FilterConfigJoin(type=FilterJoinType.INNER, fetch=true)
    private Ponto ponto;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    @FilterConfigJoin(type=FilterJoinType.INNER, fetch=true)
    private Evento evento;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="REFERENCIA", referencedColumnName="REFERENCIA", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private PontoMes pontoMes;
    @Type(type="BooleanTypeSip")
    @Column(name="INSERIDO_MANUAL")
    private Boolean inseridoManual;
    @Column(name="STATUS")
    private String status;
    @Column(name="IDDOCDIGITAL")
    private Integer idDocDigital;
    @Column(name="DATA_INCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataInclusao;
    @Column(name="DATA_ALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAlteracao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @Column(name="USUARIO_INCLUSAO")
    private Integer usuarioInclusaoCodigo;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @Column(name="USUARIO_ALTERACAO")
    private Integer usuarioAlteracaoCodigo;
    @Column(name="QUANTIDADE_DIA")
    private Double quantidadeDia;
    @Type(type="DoubleAsTime")
    @Column(name="HORAS_REPROVADAS")
    private Duration quantidadeHorasReprovadas;
    @Basic
    @Column(name="REFERENCIA_PAGTO")
    private Integer referenciaPagtoCodigo;
    @JoinColumn(name="REFERENCIA_PAGTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private Referencia referenciaPagto;
    @Basic
    @Column(name="DESTINO")
    private Short destino;
    @Column(name="VIGENCIA")
    private Integer vigencia;
    @ManyToOne
    @JoinColumn(name="VIGENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private BancoHorasParametros bancoHorasVigencia;
    @Transient
    private boolean manuallyAction;
    public static final String UPDATE_STATUS_OF_HORA_EXTRA_TO_REPROVADO_LIST_BY = "UPDATE         PontoEvento pe SET         pe.status = '" + StatusEventosPonto.REPROVADO.getId() + "'" + "WHERE " + "        pe.entidadeCodigo   = :entidadeCodigo " + "AND     pe.status           = :status " + "AND     pe.referenciaCodigo = :referencia " + "AND     pe.registro IN :registros " + "AND     pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "'";
    public static final String UPDATE_STATUS_OF_HORA_EXTRA_TO_APROVADO_LIST_BY = "UPDATE         PontoEvento pe SET         pe.status = '" + StatusEventosPonto.APROVADO.getId() + "'" + "WHERE " + "        pe.entidadeCodigo   = :entidadeCodigo " + "AND     pe.status           = :status " + "AND     pe.referenciaCodigo = :referencia " + "AND     pe.registro IN :registros " + "AND     pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "'";
    public static final String UPDATE_STATUS_AND_DOCDIGITAL_AND_REFERENCIA_PAGTO_AND_DESTINO_BY_PARAMS = "UPDATE         PontoEvento pe SET         pe.status                 = :status      ,         pe.idDocDigital           = :idDocDigital,         pe.usuarioAlteracaoCodigo = :idUsuario   ,         pe.dataAlteracao          = CURRENT_TIMESTAMP,         pe.quantidade             = :quantidade,         pe.quantidadeMillis        = :quantidadeMillis,         pe.quantidadeHorasReprovadas = :quantidadeHorasReprovadas,         pe.referenciaPagtoCodigo = :referencia,         pe.destino = :destino,         pe.vigencia = :vigencia WHERE         pe.pontoEventoPK.ponto  = :codPonto AND     pe.pontoEventoPK.evento = :codEvento";
    public static final String UPDATE_IDDOCDIGITAL_BY_PK = "UPDATE         PontoEvento p SET         p.idDocDigital = :idDocDigital WHERE         p.pontoEventoPK.ponto  = :codPonto AND     p.pontoEventoPK.evento = :codEvento";

    @PostLoad
    @PostPersist
    @PostUpdate
    protected void updateEventoOriginal() {
        this.pontoEventoPK.updateEventoOriginal();
    }

    public PontoEvento() {
        this.pontoEventoPK = new PontoEventoPK();
    }

    public PontoEvento(PontoEventoPK pontoEventosPK) {
        this.pontoEventoPK = pontoEventosPK;
    }

    public PontoEvento(int codponto, String evento) {
        this.pontoEventoPK = new PontoEventoPK(codponto, evento);
    }

    public PontoEvento(Builder builder) {
        this.pontoEventoPK = new PontoEventoPK();
        this.pontoEventoPK.setEvento(builder.eventoCodigo);
        this.pontoEventoPK.setPonto(builder.pontoCodigo);
        this.eventoCodigo = builder.eventoCodigo;
        this.entidadeCodigo = builder.entidade;
        this.registro = builder.registro;
        this.referenciaCodigo = builder.referencia;
        this.setQuantidade(builder.quantidade);
        this.quantidadeMillis = builder.quantidadeMillis;
        this.tipo = Character.valueOf(builder.tipo.getId());
        this.inseridoManual = builder.inseridoManualmente;
        this.status = builder.status.getId();
        this.setUsuarioInclusao(builder.usuarioInclusao);
        this.setUsuarioAlteracao(builder.usuarioAlteracao);
        this.setQuantidadeDia(builder.quantidadeDia);
        this.setEvento(builder.evento);
        this.setPonto(builder.ponto);
    }

    public void addQuantidade(Duration duration) {
        this.setQuantidade(this.quantidade.plus((ReadableDuration)duration));
    }

    public void removeQuantidade(Duration duration) {
        if (this.quantidade.getMillis() <= duration.getMillis()) {
            this.setQuantidade(Duration.ZERO);
        } else {
            this.setQuantidade(this.quantidade.minus((ReadableDuration)duration));
        }
    }

    public void setMaxQuantidade(Duration duration) {
        if (this.quantidade.getMillis() > duration.getMillis()) {
            this.setQuantidade(duration);
        }
    }

    public PontoEventoPK getPontoEventoPK() {
        return this.pontoEventoPK;
    }

    public void setPontoEventoPK(PontoEventoPK pontoEventosPK) {
        this.pontoEventoPK = pontoEventosPK;
    }

    public Duration getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Duration qtde) {
        if (qtde == null) {
            this.quantidadeMillis = null;
        } else {
            this.quantidadeMillis = qtde.getMillis();
            try {
                if (this.ponto != null) {
                    Long qtdeMinutes = qtde.getStandardMinutes();
                    Long diaMinutes = this.ponto.getHorasNormais() != null ? this.ponto.getHorasNormais().getStandardMinutes() : 0L;
                    this.setQuantidadeDia(diaMinutes > 0L ? qtdeMinutes.doubleValue() / diaMinutes.doubleValue() : 0.0);
                }
            }
            catch (Exception e) {
                this.setQuantidadeDia(0.0);
            }
        }
        this.quantidade = qtde;
    }

    public Character getTipo() {
        return this.tipo;
    }

    public void setTipo(Character tipo) {
        this.tipo = tipo;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
        } else {
            this.registro = null;
            this.entidadeCodigo = null;
        }
        this.trabalhador = trabalhador;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referenciaCodigo = referencia != null ? referencia.getCodigo() : null;
        this.referencia = referencia;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        if (ponto != null) {
            this.pontoEventoPK.setPonto(ponto.getCodigo());
        }
        this.ponto = ponto;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.pontoEventoPK.setEvento(evento.getEventoPK().getCodigo());
            this.eventoCodigo = evento.getEventoPK().getCodigo();
            this.updateTipo(evento);
        }
        this.evento = evento;
    }

    private void updateTipo(Evento evento) {
        this.tipo = evento.getClassificacao().isHoraExtra() ? Character.valueOf(PontoEventoTipo.HORA_EXTRA.getId()) : (evento.getClassificacao().isFalta() ? Character.valueOf(PontoEventoTipo.FALTA.getId()) : (evento.getClassificacao().isAdicionalNoturno() ? Character.valueOf(PontoEventoTipo.ADICIONAL_NOTURNO.getId()) : (evento.getClassificacao().isValeAlimentacao() ? Character.valueOf(PontoEventoTipo.VALE_ALIMENTACAO.getId()) : Character.valueOf(PontoEventoTipo.HORA_AULA.getId()))));
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public PontoMes getPontoMes() {
        return this.pontoMes;
    }

    public void setPontoMes(PontoMes pontoMes) {
        this.pontoMes = pontoMes;
    }

    public Long getQuantidadeMillis() {
        return this.quantidadeMillis;
    }

    public void setQuantidadeMillis(Long quantidadeMillis) {
        this.quantidade = quantidadeMillis == null ? null : Duration.millis((long)quantidadeMillis);
        this.quantidadeMillis = quantidadeMillis;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
        this.pontoEventoPK.setEvento(eventoCodigo);
    }

    public PontoEventoPK getChaveOriginal() {
        return new PontoEventoPK(this.pontoEventoPK.getPonto(), this.pontoEventoPK.getEventoOriginal());
    }

    public Boolean getInseridoManual() {
        return this.inseridoManual;
    }

    public void setInseridoManual(Boolean inseridoManual) {
        this.inseridoManual = inseridoManual;
    }

    public boolean isHoraExtra() {
        return this.tipo.charValue() == PontoEventoTipo.HORA_EXTRA.getId();
    }

    public boolean isFalta() {
        return this.tipo.charValue() == PontoEventoTipo.FALTA.getId();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public StatusEventosPonto getStatusEnum() {
        return this.status != null ? StatusEventosPonto.getBy(this.status) : null;
    }

    public void setStatusEnum(StatusEventosPonto status) {
        if (status != null) {
            this.setStatus(status.getId());
        }
    }

    public Integer getIdDocDigital() {
        return this.idDocDigital;
    }

    public void setIdDocDigital(Integer idDocDigital) {
        this.idDocDigital = idDocDigital;
    }

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Date getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(Date dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        if (usuarioInclusao != null) {
            this.setUsuarioInclusaoCodigo(usuarioInclusao.getCodigo());
        } else {
            this.setUsuarioInclusaoCodigo(null);
        }
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        if (usuarioAlteracao != null) {
            this.setUsuarioAlteracaoCodigo(usuarioAlteracao.getCodigo());
        } else {
            this.setUsuarioAlteracaoCodigo(null);
        }
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Integer getUsuarioInclusaoCodigo() {
        return this.usuarioInclusaoCodigo;
    }

    public void setUsuarioInclusaoCodigo(Integer usuarioInclusaoCodigo) {
        this.usuarioInclusaoCodigo = usuarioInclusaoCodigo;
    }

    public Integer getUsuarioAlteracaoCodigo() {
        return this.usuarioAlteracaoCodigo;
    }

    public String getQuantidadeString() {
        return this.quantidade == null ? "00:00" : TimeUtils.durationToString((Duration)this.quantidade);
    }

    public void setUsuarioAlteracaoCodigo(Integer usuarioAlteracaoCodigo) {
        this.usuarioAlteracaoCodigo = usuarioAlteracaoCodigo;
    }

    public Duration getQuantidadeAntiga() {
        return this.quantidadeAntiga;
    }

    public void setQuantidadeAntiga(Duration quantidadeAntiga) {
        this.quantidadeAntiga = quantidadeAntiga;
    }

    public Double getQuantidadeDia() {
        return this.quantidadeDia;
    }

    public void setQuantidadeDia(Double quantidadeDia) {
        this.quantidadeDia = quantidadeDia;
    }

    public Duration getQuantidadeHorasReprovadas() {
        return this.quantidadeHorasReprovadas;
    }

    public void setQuantidadeHorasReprovadas(Duration quantidadeHorasReprovadas) {
        this.quantidadeHorasReprovadas = quantidadeHorasReprovadas;
    }

    public Integer getReferenciaPagtoCodigo() {
        return this.referenciaPagtoCodigo;
    }

    public void setReferenciaPagtoCodigo(Integer referenciaPagtoCodigo) {
        this.referenciaPagtoCodigo = referenciaPagtoCodigo;
    }

    public Referencia getReferenciaPagto() {
        return this.referenciaPagto;
    }

    public void setReferenciaPagto(Referencia referenciaPagto) {
        this.referenciaPagto = referenciaPagto;
    }

    public Short getDestino() {
        return this.destino;
    }

    public void setDestino(Short destino) {
        this.destino = destino;
    }

    public PontoEventoDestino getDestinoEnum() {
        return PontoEventoDestino.getBy(this.destino);
    }

    public Integer getVigencia() {
        return this.vigencia;
    }

    public void setVigencia(Integer vigencia) {
        this.vigencia = vigencia;
    }

    public BancoHorasParametros getBancoHorasVigencia() {
        return this.bancoHorasVigencia;
    }

    public void setBancoHorasVigencia(BancoHorasParametros bancoHorasVigencia) {
        this.bancoHorasVigencia = bancoHorasVigencia;
    }

    @AuditIdentifierField
    public boolean isManuallyAction() {
        return this.manuallyAction || this.inseridoManual != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoEvento that = (PontoEvento)o;
        return this.pontoEventoPK.equals(that.pontoEventoPK);
    }

    public int hashCode() {
        return Objects.hash(this.pontoEventoPK);
    }

    public String toString() {
        return "PontoEvento{entidadeCodigo='" + this.entidadeCodigo + '\'' + ", referenciaCodigo=" + this.referenciaCodigo + ", eventoCodigo='" + this.eventoCodigo + '\'' + ", registro='" + this.registro + '\'' + ", quantidade=" + this.quantidade + ", tipo=" + this.tipo + ", inseridoManual=" + this.inseridoManual + '}';
    }

    @PrePersist
    public void insereAuditoria() {
        this.dataInclusao = new Date();
    }

    @PreUpdate
    public void alteraAuditoria() {
        this.dataAlteracao = new Date();
    }

    public void setManuallyAction(boolean manuallyAction) {
        this.manuallyAction = manuallyAction;
    }

    public static class Builder {
        private Integer pontoCodigo;
        private String eventoCodigo;
        private String registro;
        private String entidade;
        private Integer referencia;
        private Duration quantidade = Duration.ZERO;
        private Long quantidadeMillis = 0L;
        private PontoEventoTipo tipo = PontoEventoTipo.HORA_EXTRA;
        private boolean inseridoManualmente = false;
        private StatusEventosPonto status;
        private Usuario usuarioInclusao;
        private Usuario usuarioAlteracao;
        private Double quantidadeDia;
        private Duration quantidadeHorasReprovadas = Duration.ZERO;
        private Evento evento;
        private Ponto ponto;

        public PontoEvento build() {
            return new PontoEvento(this);
        }

        public Builder pontoCodigo(Integer pontoCodigo) {
            this.pontoCodigo = pontoCodigo;
            return this;
        }

        public Builder ponto(Ponto ponto) {
            this.pontoCodigo = ponto.getCodigo();
            this.ponto = ponto;
            return this;
        }

        public Builder evento(String eventoCodigo) {
            this.eventoCodigo = eventoCodigo;
            return this;
        }

        public Builder evento(Evento evento) {
            this.evento = evento;
            return this;
        }

        public Builder registro(String registro) {
            this.registro = registro;
            return this;
        }

        public Builder entidade(String entidade) {
            this.entidade = entidade;
            return this;
        }

        public Builder referencia(Integer referencia) {
            this.referencia = referencia;
            return this;
        }

        public Builder quantidade(Duration quantidade) {
            if (quantidade == null) {
                this.quantidadeMillis = null;
            } else {
                this.quantidadeMillis = quantidade.getMillis();
                try {
                    if (this.ponto != null) {
                        Long qtdeMinutes = quantidade.getStandardMinutes();
                        Long diaMinutes = this.ponto.getHorasNormais() != null ? this.ponto.getHorasNormais().getStandardMinutes() : 0L;
                        this.quantidadeDia = diaMinutes > 0L ? qtdeMinutes.doubleValue() / diaMinutes.doubleValue() : 0.0;
                    }
                }
                catch (Exception e) {
                    this.quantidadeDia = 0.0;
                }
            }
            this.quantidade = quantidade;
            return this;
        }

        public Builder quantidadeMillis(Long quantidadeMillis) {
            this.quantidadeMillis = quantidadeMillis;
            this.quantidade = quantidadeMillis == null ? null : new Duration((Object)quantidadeMillis);
            return this;
        }

        public Builder status(StatusEventosPonto status) {
            this.status = status;
            return this;
        }

        public Builder tipo(PontoEventoTipo tipo) {
            this.tipo = tipo;
            return this;
        }

        public Builder asHoraExtra() {
            this.tipo = PontoEventoTipo.HORA_EXTRA;
            return this;
        }

        public Builder asFalta() {
            this.tipo = PontoEventoTipo.FALTA;
            return this;
        }

        public Builder asAdicionalNoturno() {
            this.tipo = PontoEventoTipo.ADICIONAL_NOTURNO;
            return this;
        }

        public Builder asValeAlimentacao() {
            this.tipo = PontoEventoTipo.VALE_ALIMENTACAO;
            return this;
        }

        public Builder isInseridoManualmente() {
            this.inseridoManualmente = true;
            return this;
        }

        public Builder usuarioInclusao(Usuario usuarioInclusao) {
            this.usuarioInclusao = usuarioInclusao;
            return this;
        }

        public Builder usuarioAlteracao(Usuario usuarioAlteracao) {
            this.usuarioAlteracao = usuarioAlteracao;
            return this;
        }

        public Builder quantidadeDia(Double quantidadeDia) {
            this.quantidadeDia = quantidadeDia;
            return this;
        }

        public Builder quantidadeHorasReprovadas(Duration quantidadeHorasReprovadas) {
            this.quantidadeHorasReprovadas = quantidadeHorasReprovadas;
            return this;
        }
    }
}

