/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.ParametroHoraExtraDiaSemanaDSR;
import java.util.Calendar;
import java.util.Date;

public enum PontoDiaSemana {
    SEGUNDA_FEIRA("seg", "Segunda-feira", 2),
    TERCA_FEIRA("ter", "Ter\u00e7a-feira", 3),
    QUARTA_FEIRA("qua", "Quarta-feira", 4),
    QUINTA_FEIRA("qui", "Quinta-feira", 5),
    SEXTA_FEIRA("sex", "Sexta-feira", 6),
    SABADO("s\u00e1b", "S\u00e1bado", 7),
    DOMINGO("dom", "Domingo", 1);

    private final String abreviatura;
    private final String nome;
    private final int ordinal;

    private PontoDiaSemana(String abreviatura, String nome, int ordinal) {
        this.abreviatura = abreviatura;
        this.nome = nome;
        this.ordinal = ordinal;
    }

    public String getAbreviatura() {
        return this.abreviatura;
    }

    public String getNome() {
        return this.nome;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static PontoDiaSemana of(String abreviatura) {
        for (PontoDiaSemana pontoDia : PontoDiaSemana.values()) {
            if (!pontoDia.getAbreviatura().equals(abreviatura)) continue;
            return pontoDia;
        }
        return null;
    }

    public static PontoDiaSemana of(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        return PontoDiaSemana.of(dayOfWeek);
    }

    public static PontoDiaSemana of(int ordinal) {
        for (PontoDiaSemana diaSemana : PontoDiaSemana.values()) {
            if (diaSemana.getOrdinal() != ordinal) continue;
            return diaSemana;
        }
        throw new IllegalArgumentException(ordinal + " n\u00e3o \u00e9 um ordinal v\u00e1lido para PontoDiaSemana.");
    }

    public boolean isEqual(ParametroHoraExtraDiaSemanaDSR dia) {
        if (dia != null) {
            switch (dia) {
                case SEGUNDA_FEIRA: {
                    return this.equals((Object)SEGUNDA_FEIRA);
                }
                case TERCA_FEIRA: {
                    return this.equals((Object)TERCA_FEIRA);
                }
                case QUARTA_FEIRA: {
                    return this.equals((Object)QUARTA_FEIRA);
                }
                case QUINTA_FEIRA: {
                    return this.equals((Object)QUINTA_FEIRA);
                }
                case SEXTA_FEIRA: {
                    return this.equals((Object)SEXTA_FEIRA);
                }
                case SABADO: {
                    return this.equals((Object)SABADO);
                }
                case DOMINGO: {
                    return this.equals((Object)DOMINGO);
                }
            }
        }
        return false;
    }
}

