/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoColunaExtraPK;
import br.com.fiorilli.sip.persistence.entity.PontoManutencaoParam;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PTO_COLUMN_PARAM")
@IdClass(value=PontoColunaExtraPK.class)
@Audited
public class PontoColunaExtra {
    @Id
    @NotNull
    @Column(name="PONTO_ID")
    private Integer pontoId;
    @Id
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Id
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Size(max=5)
    @Column(name="QUANTIDADE")
    private String quantidade;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PONTO_ID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="EVENTO", insertable=false, updatable=false)})
    private PontoManutencaoParam configuracao;

    public PontoColunaExtra() {
    }

    public PontoColunaExtra(Integer pontoId, String entidadeCodigo, String eventoCodigo, String quantidade) {
        this.pontoId = pontoId;
        this.entidadeCodigo = entidadeCodigo;
        this.eventoCodigo = eventoCodigo;
        this.quantidade = quantidade;
    }

    public Integer getPontoId() {
        return this.pontoId;
    }

    public void setPontoId(Integer pontoId) {
        this.pontoId = pontoId;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(String quantidade) {
        this.quantidade = quantidade;
    }

    public PontoManutencaoParam getConfiguracao() {
        return this.configuracao;
    }

    public void setConfiguracao(PontoManutencaoParam configuracao) {
        this.configuracao = configuracao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        result = 31 * result + (this.eventoCodigo == null ? 0 : this.eventoCodigo.hashCode());
        result = 31 * result + (this.pontoId == null ? 0 : this.pontoId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PontoColunaExtra other = (PontoColunaExtra)obj;
        if (this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo)) {
            return false;
        }
        if (this.eventoCodigo == null ? other.eventoCodigo != null : !this.eventoCodigo.equals(other.eventoCodigo)) {
            return false;
        }
        return !(this.pontoId == null ? other.pontoId != null : !this.pontoId.equals(other.pontoId));
    }

    public String toString() {
        return "PontoColuna [pontoId=" + this.pontoId + ", entidadeCodigo=" + this.entidadeCodigo + ", eventoCodigo=" + this.eventoCodigo + ", quantidade=" + this.quantidade + "]";
    }
}

