/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoAvisoFase;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PONTO_AVISOS")
public class PontoAviso
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_PONTO_AVISOS";
    @Id
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=200)
    @Column(name="AVISO")
    private String aviso;
    @Type(type="BooleanTypeSip")
    @Column(name="USUARIO")
    private Boolean usuario;
    @Size(max=10)
    @Column(name="DATASTR")
    private String dataString;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODPONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Ponto ponto;
    @Column(name="CODPONTO")
    private Integer pontoCodigo;
    @Enumerated
    @Column(name="FASE")
    private PontoAvisoFase fase;

    public PontoAviso() {
    }

    public PontoAviso(Builder builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.entidade = builder.entidade;
        this.registro = builder.registro;
        this.aviso = builder.msg;
        this.dataString = builder.dataString;
        this.usuario = builder.usuario;
        this.pontoCodigo = builder.pontoCodigo;
        this.fase = builder.fase;
    }

    public String getAviso() {
        return this.aviso;
    }

    public void setAviso(String aviso) {
        this.aviso = aviso;
    }

    public Boolean getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Boolean usuario) {
        this.usuario = usuario;
    }

    public String getDataString() {
        return this.dataString;
    }

    public void setDataString(String datastr) {
        this.dataString = datastr;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public void setPonto(Ponto ponto) {
        this.ponto = ponto;
        this.pontoCodigo = ponto == null ? null : ponto.getCodigo();
    }

    public Integer getPontoCodigo() {
        return this.pontoCodigo;
    }

    public void setPontoCodigo(Integer pontoCodigo) {
        this.pontoCodigo = pontoCodigo;
    }

    public PontoAvisoFase getFase() {
        return this.fase;
    }

    public void setFase(PontoAvisoFase tipo) {
        this.fase = tipo;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoAviso that = (PontoAviso)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.entidade, that.entidade) && Objects.equals(this.registro, that.registro) && Objects.equals(this.data, that.data) && Objects.equals(this.aviso, that.aviso) && Objects.equals(this.usuario, that.usuario) && Objects.equals(this.dataString, that.dataString) && Objects.equals(this.ponto, that.ponto) && Objects.equals(this.pontoCodigo, that.pontoCodigo) && this.fase == that.fase;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.entidade, this.registro, this.data, this.aviso, this.usuario, this.dataString, this.ponto, this.pontoCodigo, this.fase});
    }

    public String toString() {
        return "PontoAviso{id=" + this.id + ", entidade='" + this.entidade + '\'' + ", registro='" + this.registro + '\'' + ", data=" + this.data + ", aviso='" + this.aviso + '\'' + ", usuario=" + this.usuario + ", dataString='" + this.dataString + '\'' + ", ponto=" + this.ponto + ", pontoCodigo=" + this.pontoCodigo + ", fase=" + (Object)((Object)this.fase) + '}';
    }

    public static class Builder {
        private Integer id;
        private final String entidade;
        private final String registro;
        private final Date data;
        private final String dataString;
        final Integer pontoCodigo;
        private String msg = "";
        private Boolean usuario = false;
        private PontoAvisoFase fase = null;

        public Builder(Ponto ponto) {
            Validate.notNull((Object)ponto);
            this.entidade = ponto.getEntidadeCodigo();
            this.registro = ponto.getRegistro();
            this.data = ponto.getData();
            this.dataString = SIPDateUtil.toString((Date)this.data);
            this.pontoCodigo = ponto.getCodigo();
        }

        public Builder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder usuario(Boolean usuario) {
            this.usuario = usuario;
            return this;
        }

        public Builder fase(PontoAvisoFase fase) {
            this.fase = fase;
            return this;
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public PontoAviso build() {
            return new PontoAviso(this);
        }
    }
}

