/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.entity.PontoAfdBatidas;
import br.com.fiorilli.sip.persistence.entity.PontoAfdEmpregado;
import br.com.fiorilli.sip.persistence.entity.PontoAfdEntidade;
import br.com.fiorilli.sip.persistence.entity.PontoAfdRelogio;
import br.com.fiorilli.sip.persistence.entity.PontoAfdRodape;
import br.com.fiorilli.sip.persistence.entity.RepConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PONTO_AFD_CABECALHO")
public class PontoAfdCabecalho
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERAROR = "GEN_PONTO_AFD_CABECALHO";
    @Id
    @NotNull
    @Column(name="ID_PONTO_AFD_CABECALHO")
    private Integer id;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @FilterConfig(label="N\u00fam. Fabr. REP")
    @Size(max=17)
    @Column(name="NUM_FABRICACAO_REP")
    private String numeroFabricacaoREP;
    @JoinColumn(name="num_fabricacao_rep", referencedColumnName="numero_rep", insertable=false, updatable=false)
    @ManyToOne(optional=true)
    private RepConfig repConfig;
    @FilterConfig(label="Dt. Inicial", inputType=FilterInputType.CALENDAR, order=2)
    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicial;
    @FilterConfig(label="Dt. Final", inputType=FilterInputType.CALENDAR, order=3)
    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataFinal;
    @Column(name="DATA_HORA_GERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraGeracao;
    @FilterConfig(label="Nome do Arquivo", condition=FilterCondition.COMECE)
    @Size(max=2048)
    @Column(name="ARQUIVO")
    private String arquivo;
    @Size(max=4)
    @Column(name="ANO")
    private String ano;
    @Size(max=2)
    @Column(name="MES")
    private String mes;
    @Size(max=64)
    @Column(name="HASH")
    private String hash;
    @FilterConfig(label="Dt. Importa\u00e7\u00e3o", inputType=FilterInputType.CALENDAR, order=1)
    @Column(name="DATA_HORA_IMPORTACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraImportacao;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="cabecalho", fetch=FetchType.LAZY, orphanRemoval=true)
    private PontoAfdRodape rodape;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cabecalho", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoAfdBatidas> batidas;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cabecalho", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoAfdEntidade> entidades;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cabecalho", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoAfdRelogio> relogios;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cabecalho", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoAfdEmpregado> empregados;

    @PrePersist
    private void prePersist() {
        this.dataHoraImportacao = new Date();
    }

    public void setRodape(PontoAfdRodape pontoAfdRodape) {
        if (pontoAfdRodape != null) {
            pontoAfdRodape.setCabecalho(this);
        }
        this.rodape = pontoAfdRodape;
    }

    public void addBatida(PontoAfdBatidas batida) {
        if (this.batidas == null) {
            this.batidas = new ArrayList<PontoAfdBatidas>();
        }
        batida.setCabecalho(this);
        this.batidas.add(batida);
    }

    public void addEntidade(PontoAfdEntidade pontoEntidade) {
        if (this.entidades == null) {
            this.entidades = new ArrayList<PontoAfdEntidade>();
        }
        this.entidades.add(pontoEntidade);
        pontoEntidade.setCabecalho(this);
    }

    public void addRelogio(PontoAfdRelogio relogio) {
        if (this.relogios == null) {
            this.relogios = new ArrayList<PontoAfdRelogio>();
        }
        this.relogios.add(relogio);
        relogio.setCabecalho(this);
    }

    public void addEmpregado(PontoAfdEmpregado empregado) {
        if (this.empregados == null) {
            this.empregados = new ArrayList<PontoAfdEmpregado>();
        }
        this.empregados.add(empregado);
        empregado.setCabecalho(this);
    }

    public static PontoAfdCabecalhoBuilder builder() {
        return new PontoAfdCabecalhoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public String getNumeroFabricacaoREP() {
        return this.numeroFabricacaoREP;
    }

    public RepConfig getRepConfig() {
        return this.repConfig;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public Date getDataHoraGeracao() {
        return this.dataHoraGeracao;
    }

    public String getArquivo() {
        return this.arquivo;
    }

    public String getAno() {
        return this.ano;
    }

    public String getMes() {
        return this.mes;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getDataHoraImportacao() {
        return this.dataHoraImportacao;
    }

    public PontoAfdRodape getRodape() {
        return this.rodape;
    }

    public List<PontoAfdBatidas> getBatidas() {
        return this.batidas;
    }

    public List<PontoAfdEntidade> getEntidades() {
        return this.entidades;
    }

    public List<PontoAfdRelogio> getRelogios() {
        return this.relogios;
    }

    public List<PontoAfdEmpregado> getEmpregados() {
        return this.empregados;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public void setNumeroFabricacaoREP(String numeroFabricacaoREP) {
        this.numeroFabricacaoREP = numeroFabricacaoREP;
    }

    public void setRepConfig(RepConfig repConfig) {
        this.repConfig = repConfig;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setDataHoraGeracao(Date dataHoraGeracao) {
        this.dataHoraGeracao = dataHoraGeracao;
    }

    public void setArquivo(String arquivo) {
        this.arquivo = arquivo;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setDataHoraImportacao(Date dataHoraImportacao) {
        this.dataHoraImportacao = dataHoraImportacao;
    }

    public void setBatidas(List<PontoAfdBatidas> batidas) {
        this.batidas = batidas;
    }

    public void setEntidades(List<PontoAfdEntidade> entidades) {
        this.entidades = entidades;
    }

    public void setRelogios(List<PontoAfdRelogio> relogios) {
        this.relogios = relogios;
    }

    public void setEmpregados(List<PontoAfdEmpregado> empregados) {
        this.empregados = empregados;
    }

    public PontoAfdCabecalho(Integer id, String entidadeCodigo, String numeroFabricacaoREP, RepConfig repConfig, Date dataInicial, Date dataFinal, Date dataHoraGeracao, String arquivo, String ano, String mes, String hash, Date dataHoraImportacao, PontoAfdRodape rodape, List<PontoAfdBatidas> batidas, List<PontoAfdEntidade> entidades, List<PontoAfdRelogio> relogios, List<PontoAfdEmpregado> empregados) {
        this.id = id;
        this.entidadeCodigo = entidadeCodigo;
        this.numeroFabricacaoREP = numeroFabricacaoREP;
        this.repConfig = repConfig;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.dataHoraGeracao = dataHoraGeracao;
        this.arquivo = arquivo;
        this.ano = ano;
        this.mes = mes;
        this.hash = hash;
        this.dataHoraImportacao = dataHoraImportacao;
        this.rodape = rodape;
        this.batidas = batidas;
        this.entidades = entidades;
        this.relogios = relogios;
        this.empregados = empregados;
    }

    public PontoAfdCabecalho() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PontoAfdCabecalho)) {
            return false;
        }
        PontoAfdCabecalho other = (PontoAfdCabecalho)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PontoAfdCabecalho;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "PontoAfdCabecalho(id=" + this.getId() + ", entidadeCodigo=" + this.getEntidadeCodigo() + ", numeroFabricacaoREP=" + this.getNumeroFabricacaoREP() + ", repConfig=" + this.getRepConfig() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", dataHoraGeracao=" + this.getDataHoraGeracao() + ", arquivo=" + this.getArquivo() + ", ano=" + this.getAno() + ", mes=" + this.getMes() + ", hash=" + this.getHash() + ", dataHoraImportacao=" + this.getDataHoraImportacao() + ")";
    }

    public static class PontoAfdCabecalhoBuilder {
        private Integer id;
        private String entidadeCodigo;
        private String numeroFabricacaoREP;
        private RepConfig repConfig;
        private Date dataInicial;
        private Date dataFinal;
        private Date dataHoraGeracao;
        private String arquivo;
        private String ano;
        private String mes;
        private String hash;
        private Date dataHoraImportacao;
        private PontoAfdRodape rodape;
        private List<PontoAfdBatidas> batidas;
        private List<PontoAfdEntidade> entidades;
        private List<PontoAfdRelogio> relogios;
        private List<PontoAfdEmpregado> empregados;

        PontoAfdCabecalhoBuilder() {
        }

        public PontoAfdCabecalhoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public PontoAfdCabecalhoBuilder entidadeCodigo(String entidadeCodigo) {
            this.entidadeCodigo = entidadeCodigo;
            return this;
        }

        public PontoAfdCabecalhoBuilder numeroFabricacaoREP(String numeroFabricacaoREP) {
            this.numeroFabricacaoREP = numeroFabricacaoREP;
            return this;
        }

        public PontoAfdCabecalhoBuilder repConfig(RepConfig repConfig) {
            this.repConfig = repConfig;
            return this;
        }

        public PontoAfdCabecalhoBuilder dataInicial(Date dataInicial) {
            this.dataInicial = dataInicial;
            return this;
        }

        public PontoAfdCabecalhoBuilder dataFinal(Date dataFinal) {
            this.dataFinal = dataFinal;
            return this;
        }

        public PontoAfdCabecalhoBuilder dataHoraGeracao(Date dataHoraGeracao) {
            this.dataHoraGeracao = dataHoraGeracao;
            return this;
        }

        public PontoAfdCabecalhoBuilder arquivo(String arquivo) {
            this.arquivo = arquivo;
            return this;
        }

        public PontoAfdCabecalhoBuilder ano(String ano) {
            this.ano = ano;
            return this;
        }

        public PontoAfdCabecalhoBuilder mes(String mes) {
            this.mes = mes;
            return this;
        }

        public PontoAfdCabecalhoBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public PontoAfdCabecalhoBuilder dataHoraImportacao(Date dataHoraImportacao) {
            this.dataHoraImportacao = dataHoraImportacao;
            return this;
        }

        public PontoAfdCabecalhoBuilder rodape(PontoAfdRodape rodape) {
            this.rodape = rodape;
            return this;
        }

        public PontoAfdCabecalhoBuilder batidas(List<PontoAfdBatidas> batidas) {
            this.batidas = batidas;
            return this;
        }

        public PontoAfdCabecalhoBuilder entidades(List<PontoAfdEntidade> entidades) {
            this.entidades = entidades;
            return this;
        }

        public PontoAfdCabecalhoBuilder relogios(List<PontoAfdRelogio> relogios) {
            this.relogios = relogios;
            return this;
        }

        public PontoAfdCabecalhoBuilder empregados(List<PontoAfdEmpregado> empregados) {
            this.empregados = empregados;
            return this;
        }

        public PontoAfdCabecalho build() {
            return new PontoAfdCabecalho(this.id, this.entidadeCodigo, this.numeroFabricacaoREP, this.repConfig, this.dataInicial, this.dataFinal, this.dataHoraGeracao, this.arquivo, this.ano, this.mes, this.hash, this.dataHoraImportacao, this.rodape, this.batidas, this.entidades, this.relogios, this.empregados);
        }

        public String toString() {
            return "PontoAfdCabecalho.PontoAfdCabecalhoBuilder(id=" + this.id + ", entidadeCodigo=" + this.entidadeCodigo + ", numeroFabricacaoREP=" + this.numeroFabricacaoREP + ", repConfig=" + this.repConfig + ", dataInicial=" + this.dataInicial + ", dataFinal=" + this.dataFinal + ", dataHoraGeracao=" + this.dataHoraGeracao + ", arquivo=" + this.arquivo + ", ano=" + this.ano + ", mes=" + this.mes + ", hash=" + this.hash + ", dataHoraImportacao=" + this.dataHoraImportacao + ", rodape=" + this.rodape + ", batidas=" + this.batidas + ", entidades=" + this.entidades + ", relogios=" + this.relogios + ", empregados=" + this.empregados + ")";
        }
    }
}

