/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.Ponto;
import br.com.fiorilli.sip.persistence.entity.PontoAfdBatidasOcorrencia;
import br.com.fiorilli.sip.persistence.entity.PontoAfdBatidasPK;
import br.com.fiorilli.sip.persistence.entity.PontoAfdCabecalho;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PONTO_AFD_BATIDAS")
@IdClass(value=PontoAfdBatidasPK.class)
public class PontoAfdBatidas
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UPDATE_SET_PONTO_NATIVE = "UPDATE \tPONTO_AFD_BATIDAS SET \tID_PONTO_AFDT =( \t\tSELECT FIRST 1 \t\t\tponto1_.CODIGO \t\tFROM \t\t\tPONTO ponto1_ \t\tWHERE \t\t\tponto1_.EMPRESA = :entidadeCodigo \t\t\tAND ponto1_.REGISTRO = :registro \t\t\tAND( \t\t\t\tponto1_.DATA BETWEEN PONTO_AFD_BATIDAS.DATA - 1 AND PONTO_AFD_BATIDAS.DATA + 1 \t\t\t) \t\t\tAND( \t\t\t\tPONTO_AFD_BATIDAS.DATA IN( \t\t\t\t\tponto1_.DATA_ENTRADA1, \t\t\t\t\tponto1_.DATA_SAIDA1, \t\t\t\t\tponto1_.DATA_ENTRADA2, \t\t\t\t\tponto1_.DATA_SAIDA2, \t\t\t\t\tponto1_.DATA_ENTRADA3, \t\t\t\t\tponto1_.DATA_SAIDA3, \t\t\t\t\tponto1_.DATA_ENTRADA4, \t\t\t\t\tponto1_.DATA_SAIDA4, \t\t\t\t\tponto1_.DATA_ENTRADA5, \t\t\t\t\tponto1_.DATA_SAIDA5 \t\t\t\t) \t\t\t) \t\t\tAND( \t\t\t\tPONTO_AFD_BATIDAS.SHORA IN( \t\t\t\t\tponto1_.ENTRADA1, \t\t\t\t\tponto1_.SAIDA1, \t\t\t\t\tponto1_.ENTRADA2, \t\t\t\t\tponto1_.SAIDA2, \t\t\t\t\tponto1_.ENTRADA3, \t\t\t\t\tponto1_.SAIDA3, \t\t\t\t\tponto1_.ENTRADA4, \t\t\t\t\tponto1_.SAIDA4, \t\t\t\t\tponto1_.ENTRADA5, \t\t\t\t\tponto1_.SAIDA5 \t\t\t\t) \t\t\t) \t) WHERE \tEMPRESA = :entidadeCodigo \tAND REGISTRO = :registro \tAND( \t\tDATA BETWEEN :inicio AND :fim \t) \tAND NOT( \t\tEXISTS( \t\t\tSELECT \t\t\t\tFIRST 1 1 \t\t\tFROM \t\t\t\tPONTO_AFD_BATIDAS pontoafdba2_ \t\t\tWHERE \t\t\t\tpontoafdba2_.EMPRESA = PONTO_AFD_BATIDAS.EMPRESA \t\t\t\tAND pontoafdba2_.REGISTRO = PONTO_AFD_BATIDAS.REGISTRO \t\t\t\tAND pontoafdba2_.DATA = PONTO_AFD_BATIDAS.DATA \t\t\t\tAND pontoafdba2_.SHORA = PONTO_AFD_BATIDAS.SHORA \t\t\t\tAND pontoafdba2_.CABECALHO > PONTO_AFD_BATIDAS.CABECALHO \t\t) \t)";
    public static final String FIND_BY_REGISTRO_AND_PERIODO_WITH_NSR = "SELECT NEW br.com.fiorilli.sipweb.vo.PontoOfTrabalhadorVo(ba.nsr , ba.dataHora) FROM PontoAfdBatidas ba WHERE ba.entidadeCodigo = :entidadeCodigo AND ba.registro = :registro AND ba.data BETWEEN :periodoInicio AND :periodoFim ORDER BY ba.dataHora ";
    public static final String UPDATE_SET_NULL_PONTO = "update PontoAfdBatidas ba set ba.pontoCodigo = null where ba.entidadeCodigo = :entidadeCodigo and ba.registro = :registro and ba.data between :dataInicial and :dataFinal and ba.pontoCodigo is not null";
    @Id
    @NotNull
    @Column(name="CABECALHO")
    private Integer cabecalhoId;
    @Id
    @NotNull
    @Column(name="NSR")
    private Integer nsr;
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Column(name="HORA")
    @Temporal(value=TemporalType.TIME)
    private Date hora;
    @Size(max=5)
    @Column(name="SHORA")
    private String shora;
    @Size(max=1)
    @Column(name="INDICADOR")
    private String indicador;
    @Column(name="DATAHORA_REAL")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHora;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Column(name="ID_PONTO_AFDT")
    private Integer pontoCodigo;
    @Column
    private String pis;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CABECALHO", referencedColumnName="ID_PONTO_AFD_CABECALHO", insertable=false, updatable=false)
    private PontoAfdCabecalho cabecalho;
    @JoinColumn(name="ID_PONTO_AFDT", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Ponto ponto;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="CABECALHO", referencedColumnName="CABECALHO", insertable=false, updatable=false), @JoinColumn(name="NSR", referencedColumnName="NSR", insertable=false, updatable=false)})
    private PontoAfdBatidasOcorrencia ocorrencia;

    public PontoAfdBatidas(Integer cabecalhoId, Integer nsr, Date data, Date hora, String shora, String indicador, Date dataHora, String entidadeCodigo, String registro, Integer pontoCodigo, String pis) {
        this.cabecalhoId = cabecalhoId;
        this.nsr = nsr;
        this.data = data;
        this.hora = hora;
        this.shora = shora;
        this.indicador = indicador;
        this.dataHora = dataHora;
        this.entidadeCodigo = entidadeCodigo;
        this.registro = registro;
        this.pontoCodigo = pontoCodigo;
        this.pis = pis;
    }

    public void setOcorrencia(PontoAfdBatidasOcorrencia ocorrencia) {
        if (ocorrencia != null) {
            ocorrencia.setCabecalhoId(this.cabecalhoId);
            ocorrencia.setNsr(this.nsr);
            ocorrencia.setBatida(this);
            this.ocorrencia = ocorrencia;
        }
    }

    public static PontoAfdBatidasBuilder builder() {
        return new PontoAfdBatidasBuilder();
    }

    public Integer getCabecalhoId() {
        return this.cabecalhoId;
    }

    public Integer getNsr() {
        return this.nsr;
    }

    public Date getData() {
        return this.data;
    }

    public Date getHora() {
        return this.hora;
    }

    public String getShora() {
        return this.shora;
    }

    public String getIndicador() {
        return this.indicador;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getPontoCodigo() {
        return this.pontoCodigo;
    }

    public String getPis() {
        return this.pis;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public PontoAfdCabecalho getCabecalho() {
        return this.cabecalho;
    }

    public Ponto getPonto() {
        return this.ponto;
    }

    public PontoAfdBatidasOcorrencia getOcorrencia() {
        return this.ocorrencia;
    }

    public void setCabecalhoId(Integer cabecalhoId) {
        this.cabecalhoId = cabecalhoId;
    }

    public void setNsr(Integer nsr) {
        this.nsr = nsr;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setHora(Date hora) {
        this.hora = hora;
    }

    public void setShora(String shora) {
        this.shora = shora;
    }

    public void setIndicador(String indicador) {
        this.indicador = indicador;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setPontoCodigo(Integer pontoCodigo) {
        this.pontoCodigo = pontoCodigo;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public void setCabecalho(PontoAfdCabecalho cabecalho) {
        this.cabecalho = cabecalho;
    }

    public void setPonto(Ponto ponto) {
        this.ponto = ponto;
    }

    public PontoAfdBatidas() {
    }

    public PontoAfdBatidas(Integer cabecalhoId, Integer nsr, Date data, Date hora, String shora, String indicador, Date dataHora, String entidadeCodigo, String registro, Integer pontoCodigo, String pis, Trabalhador trabalhador, PontoAfdCabecalho cabecalho, Ponto ponto, PontoAfdBatidasOcorrencia ocorrencia) {
        this.cabecalhoId = cabecalhoId;
        this.nsr = nsr;
        this.data = data;
        this.hora = hora;
        this.shora = shora;
        this.indicador = indicador;
        this.dataHora = dataHora;
        this.entidadeCodigo = entidadeCodigo;
        this.registro = registro;
        this.pontoCodigo = pontoCodigo;
        this.pis = pis;
        this.trabalhador = trabalhador;
        this.cabecalho = cabecalho;
        this.ponto = ponto;
        this.ocorrencia = ocorrencia;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PontoAfdBatidas)) {
            return false;
        }
        PontoAfdBatidas other = (PontoAfdBatidas)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cabecalhoId = this.getCabecalhoId();
        Integer other$cabecalhoId = other.getCabecalhoId();
        if (this$cabecalhoId == null ? other$cabecalhoId != null : !((Object)this$cabecalhoId).equals(other$cabecalhoId)) {
            return false;
        }
        Integer this$nsr = this.getNsr();
        Integer other$nsr = other.getNsr();
        return !(this$nsr == null ? other$nsr != null : !((Object)this$nsr).equals(other$nsr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PontoAfdBatidas;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cabecalhoId = this.getCabecalhoId();
        result = result * 59 + ($cabecalhoId == null ? 43 : ((Object)$cabecalhoId).hashCode());
        Integer $nsr = this.getNsr();
        result = result * 59 + ($nsr == null ? 43 : ((Object)$nsr).hashCode());
        return result;
    }

    public String toString() {
        return "PontoAfdBatidas(cabecalhoId=" + this.getCabecalhoId() + ", nsr=" + this.getNsr() + ", data=" + this.getData() + ", hora=" + this.getHora() + ", shora=" + this.getShora() + ", indicador=" + this.getIndicador() + ", dataHora=" + this.getDataHora() + ", entidadeCodigo=" + this.getEntidadeCodigo() + ", registro=" + this.getRegistro() + ", pontoCodigo=" + this.getPontoCodigo() + ", pis=" + this.getPis() + ", ocorrencia=" + this.getOcorrencia() + ")";
    }

    public static class PontoAfdBatidasBuilder {
        private Integer cabecalhoId;
        private Integer nsr;
        private Date data;
        private Date hora;
        private String shora;
        private String indicador;
        private Date dataHora;
        private String entidadeCodigo;
        private String registro;
        private Integer pontoCodigo;
        private String pis;
        private Trabalhador trabalhador;
        private PontoAfdCabecalho cabecalho;
        private Ponto ponto;
        private PontoAfdBatidasOcorrencia ocorrencia;

        PontoAfdBatidasBuilder() {
        }

        public PontoAfdBatidasBuilder cabecalhoId(Integer cabecalhoId) {
            this.cabecalhoId = cabecalhoId;
            return this;
        }

        public PontoAfdBatidasBuilder nsr(Integer nsr) {
            this.nsr = nsr;
            return this;
        }

        public PontoAfdBatidasBuilder data(Date data) {
            this.data = data;
            return this;
        }

        public PontoAfdBatidasBuilder hora(Date hora) {
            this.hora = hora;
            return this;
        }

        public PontoAfdBatidasBuilder shora(String shora) {
            this.shora = shora;
            return this;
        }

        public PontoAfdBatidasBuilder indicador(String indicador) {
            this.indicador = indicador;
            return this;
        }

        public PontoAfdBatidasBuilder dataHora(Date dataHora) {
            this.dataHora = dataHora;
            return this;
        }

        public PontoAfdBatidasBuilder entidadeCodigo(String entidadeCodigo) {
            this.entidadeCodigo = entidadeCodigo;
            return this;
        }

        public PontoAfdBatidasBuilder registro(String registro) {
            this.registro = registro;
            return this;
        }

        public PontoAfdBatidasBuilder pontoCodigo(Integer pontoCodigo) {
            this.pontoCodigo = pontoCodigo;
            return this;
        }

        public PontoAfdBatidasBuilder pis(String pis) {
            this.pis = pis;
            return this;
        }

        public PontoAfdBatidasBuilder trabalhador(Trabalhador trabalhador) {
            this.trabalhador = trabalhador;
            return this;
        }

        public PontoAfdBatidasBuilder cabecalho(PontoAfdCabecalho cabecalho) {
            this.cabecalho = cabecalho;
            return this;
        }

        public PontoAfdBatidasBuilder ponto(Ponto ponto) {
            this.ponto = ponto;
            return this;
        }

        public PontoAfdBatidasBuilder ocorrencia(PontoAfdBatidasOcorrencia ocorrencia) {
            this.ocorrencia = ocorrencia;
            return this;
        }

        public PontoAfdBatidas build() {
            return new PontoAfdBatidas(this.cabecalhoId, this.nsr, this.data, this.hora, this.shora, this.indicador, this.dataHora, this.entidadeCodigo, this.registro, this.pontoCodigo, this.pis, this.trabalhador, this.cabecalho, this.ponto, this.ocorrencia);
        }

        public String toString() {
            return "PontoAfdBatidas.PontoAfdBatidasBuilder(cabecalhoId=" + this.cabecalhoId + ", nsr=" + this.nsr + ", data=" + this.data + ", hora=" + this.hora + ", shora=" + this.shora + ", indicador=" + this.indicador + ", dataHora=" + this.dataHora + ", entidadeCodigo=" + this.entidadeCodigo + ", registro=" + this.registro + ", pontoCodigo=" + this.pontoCodigo + ", pis=" + this.pis + ", trabalhador=" + this.trabalhador + ", cabecalho=" + this.cabecalho + ", ponto=" + this.ponto + ", ocorrencia=" + this.ocorrencia + ")";
        }
    }
}

