/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.AuditIdentifierField;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CalculoPontoFase;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.PontoAfdBatidas;
import br.com.fiorilli.sip.persistence.entity.PontoAviso;
import br.com.fiorilli.sip.persistence.entity.PontoBatidaSituacao;
import br.com.fiorilli.sip.persistence.entity.PontoColunaExtra;
import br.com.fiorilli.sip.persistence.entity.PontoDiaSemana;
import br.com.fiorilli.sip.persistence.entity.PontoEvento;
import br.com.fiorilli.sip.persistence.entity.PontoMes;
import br.com.fiorilli.sip.persistence.entity.PontoMotivo;
import br.com.fiorilli.sip.persistence.entity.PontoMovimento;
import br.com.fiorilli.sip.persistence.entity.PontoSituacao;
import br.com.fiorilli.sip.persistence.entity.PontoTipoOcorrencia;
import br.com.fiorilli.sip.persistence.entity.PontoTrabAlteracao;
import br.com.fiorilli.sip.persistence.entity.PontoTrabOcorrencia;
import br.com.fiorilli.sip.persistence.entity.PontoWeb;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Entity
@Table(name="PONTO")
@Audited(insert=false)
public class Ponto
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXISTS_BY_JORNADA = "SELECT CASE WHEN COALESCE(COUNT(p.codigo), 0) > 0 THEN TRUE ELSE FALSE END FROM Ponto p WHERE p.entidadeCodigo = :entidadeCodigo AND p.jornadaCodigo = :jornadaCodigo";
    public static final String EXISTS_BY_JORNADA_DIA = "SELECT CASE WHEN COALESCE(COUNT(p.codigo), 0) > 0 THEN TRUE ELSE FALSE END FROM Ponto p JOIN p.jornadaDia j WHERE j.jornadaDiaPK = :jornadaDiaPK";
    public static final String FIND_REGISTRO_FOR_EXPORTACAO = "SELECT distinct tr.documentosPessoais.pis AS pis, pt.data AS data, pt.entrada1 AS entrada1, pt.saida1 AS saida1, pt.entrada2 AS entrada2, pt.saida2 AS saida2, pt.entrada3 AS entrada3, pt.saida3 AS saida3, pt.entrada4 AS entrada4, pt.saida4 AS saida4, pt.entrada5 AS entrada5, pt.saida5 AS saida5, COALESCE(pt.entrada1Situacao, 'O') AS entrada1Situacao, COALESCE(pt.saida1Situacao, 'O') AS saida1Situacao, COALESCE(pt.entrada2Situacao, 'O') AS entrada2Situacao, COALESCE(pt.saida2Situacao, 'O') AS saida2Situacao, COALESCE(pt.entrada2Situacao, 'O') AS entrada3Situacao, COALESCE(pt.saida2Situacao, 'O') AS saida3Situacao, COALESCE(pt.entrada2Situacao, 'O') AS entrada4Situacao, COALESCE(pt.saida2Situacao, 'O') AS saida4Situacao, COALESCE(pt.entrada2Situacao, 'O') AS entrada5Situacao, COALESCE(pt.saida2Situacao, 'O') AS saida5Situacao, max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA1' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS entrada1Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA2' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS entrada2Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA3' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS entrada3Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA4' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS entrada4Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA5' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS entrada5Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA1' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS saida1Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA2' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS saida2Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA3' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS saida3Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA4' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS saida4Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA5' AND pt.data = mo.data THEN mo.horaBatida ELSE null END) AS saida5Alteracao,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA1' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS entrada1Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA2' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS entrada2Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA3' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS entrada3Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA4' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS entrada4Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA5' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS entrada5Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA1' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS saida1Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA2' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS saida2Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA3' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS saida3Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA4' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS saida4Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA5' AND pt.data = mo.data THEN mo.motivo ELSE '' END) AS saida5Motivo,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA1' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS entrada1Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA2' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS entrada2Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA3' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS entrada3Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA4' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS entrada4Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'ENTRADA5' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS entrada5Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA1' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS saida1Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA2' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS saida2Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA3' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS saida3Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA4' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS saida4Ocorrencia,max(CASE WHEN mo IS NOT NULL AND mo.campo = 'SAIDA5' AND pt.data = mo.data THEN mo.ocorrencia ELSE '' END) AS saida5Ocorrencia, max(case when pt.entrada1 = ba.shora then ca.numeroFabricacaoREP else null end) as entrada1Numrep,max(case when pt.entrada2 = ba.shora then ca.numeroFabricacaoREP else null end) as entrada2Numrep,max(case when pt.entrada3 = ba.shora then ca.numeroFabricacaoREP else null end) as entrada3Numrep,max(case when pt.entrada4 = ba.shora then ca.numeroFabricacaoREP else null end) as entrada4Numrep,max(case when pt.entrada5 = ba.shora then ca.numeroFabricacaoREP else null end) as entrada5Numrep,max(case when pt.saida1 = ba.shora then ca.numeroFabricacaoREP else null end) as saida1Numrep,max(case when pt.saida2 = ba.shora then ca.numeroFabricacaoREP else null end) as saida2Numrep,max(case when pt.saida3 = ba.shora then ca.numeroFabricacaoREP else null end) as saida3Numrep,max(case when pt.saida4 = ba.shora then ca.numeroFabricacaoREP else null end) as saida4Numrep,max(case when pt.saida5 = ba.shora then ca.numeroFabricacaoREP else null end) as saida5Numrep FROM Ponto pt LEFT JOIN pt.batidas ba LEFT JOIN ba.cabecalho ca LEFT JOIN pt.trabalhador tr LEFT JOIN pt.motivos mo WHERE pt.entidadeCodigo = :entidadeCodigo AND tr.documentosPessoais.pis IS NOT NULL AND pt.data BETWEEN :periodoInicio AND :periodoFim and mo.motivo is not null group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22ORDER BY  pt.data, tr.documentosPessoais.pis";
    public static final String FIND_ACJEF = "SELECT pt.codigo AS pontoCodigo, tr.trabalhadorPK AS trabalhadorPK, COALESCE(tr.documentosPessoais.pis, '') AS pis, pt.data AS data, pt.entrada1 AS entrada1, jd.jornadaDiaPK AS jornadaDiaPK, pt.horasTrabalhadas AS horasTrabalhadas, pt.horasNoturnas AS horasNoturnas FROM Ponto pt LEFT JOIN pt.trabalhador tr LEFT JOIN pt.jornadaDia jd WHERE pt.referencia.codigo = :referenciaCodigo ORDER BY pt.registro, pt.data ";
    public static final String FIND_ACJEF_COUNT = "SELECT COALESCE(COUNT(pt.codigo), 0) FROM Ponto pt WHERE pt.referencia.codigo = :referenciaCodigo";
    public static final String FIND_BY_REGISTRO_AND_PERIODO_WITH_AVISOS = "SELECT DISTINCT pt FROM Ponto pt WHERE pt.entidadeCodigo = :entidadeCodigo AND pt.registro = :registro AND pt.data BETWEEN :dataInicial AND :dataFinal AND pt.referencia.codigo = :referencia ORDER BY pt.data";
    public static final String FIND_BY_REGISTRO_AND_PERIODO = "SELECT distinct pt FROM Ponto pt WHERE pt.entidadeCodigo = :entidadeCodigo AND pt.registro = :registro AND pt.data BETWEEN :dataInicial AND :dataFinal ORDER BY pt.data";
    public static final String FIND_TO_AEJ = "SELECT p FROM Ponto p WHERE p.entidadeCodigo = :entidadeCodigo    AND p.data BETWEEN :dataInicial AND :dataFinal    AND ((:cpf IS NULL) OR ((:cpf IS NOT NULL) AND (p.trabalhador.documentosPessoais.cpf = :cpf))) ORDER BY p.data, p.registro";
    public static final String GENERATOR = "GEN_PONTO";
    @Transient
    private DateTime[] entradas = null;
    @Transient
    private DateTime[] saidas = null;
    @Transient
    private Interval[] intervalOfEntradasAndSaidas;
    @Transient
    private Boolean dsr = Boolean.FALSE;
    @Transient
    private boolean newPonto = false;
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Size(max=5)
    @Column(name="ENTRADA1")
    private String entrada1;
    @Size(max=5)
    @Column(name="ENTRADA2")
    private String entrada2;
    @Size(max=5)
    @Column(name="ENTRADA3")
    private String entrada3;
    @Size(max=5)
    @Column(name="ENTRADA4")
    private String entrada4;
    @Size(max=5)
    @Column(name="ENTRADA5")
    private String entrada5;
    @Size(max=5)
    @Column(name="SAIDA1")
    private String saida1;
    @Size(max=5)
    @Column(name="SAIDA2")
    private String saida2;
    @Size(max=5)
    @Column(name="SAIDA3")
    private String saida3;
    @Size(max=5)
    @Column(name="SAIDA4")
    private String saida4;
    @Size(max=5)
    @Column(name="SAIDA5")
    private String saida5;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA1")
    private Date dataEntrada1;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA2")
    private Date dataEntrada2;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA3")
    private Date dataEntrada3;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA4")
    private Date dataEntrada4;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA5")
    private Date dataEntrada5;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA1")
    private Date dataSaida1;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA2")
    private Date dataSaida2;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA3")
    private Date dataSaida3;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA4")
    private Date dataSaida4;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA5")
    private Date dataSaida5;
    @Type(type="DoubleAsTime")
    @Column(name="HRNORMAL")
    private Duration horasNormais;
    @Type(type="DoubleAsTime")
    @Column(name="HRNORMAL_ANTIGA")
    private Duration horasNormaisAntigas;
    @Type(type="DoubleAsTime")
    @Column(name="HRTRABALHADA")
    private Duration horasTrabalhadas;
    @Type(type="DoubleAsTime")
    @Column(name="HRTRABALHADA_ANTIGA")
    private Duration horasTrabalhadasAntigas;
    @Type(type="DoubleAsTime")
    @Column(name="HRNOTURNA")
    private Duration horasNoturnas;
    @Type(type="DoubleAsTime")
    @Column(name="HRAULA")
    private Duration horasAulas;
    @Type(type="DoubleAsTime")
    @Column(name="HRCOMPENSACAO")
    private Duration horasCompensacao;
    @Column(name="SITUACAO_ENTRADA1")
    private Character entrada1Situacao;
    @Column(name="SITUACAO_SAIDA1")
    private Character saida1Situacao;
    @Column(name="SITUACAO_ENTRADA2")
    private Character entrada2Situacao;
    @Column(name="SITUACAO_SAIDA2")
    private Character saida2Situacao;
    @Column(name="SITUACAO_ENTRADA3")
    private Character entrada3Situacao;
    @Column(name="SITUACAO_SAIDA3")
    private Character saida3Situacao;
    @Column(name="SITUACAO_ENTRADA4")
    private Character entrada4Situacao;
    @Column(name="SITUACAO_SAIDA4")
    private Character saida4Situacao;
    @Column(name="SITUACAO_ENTRADA5")
    private Character entrada5Situacao;
    @Column(name="SITUACAO_SAIDA5")
    private Character saida5Situacao;
    @Size(max=3)
    @Column(name="DIASEMANA")
    private String diaSemana;
    @Type(type="BooleanTypeSip")
    @Column(name="FERIADO")
    private Boolean feriado;
    @Type(type="BooleanTypeSip")
    @Column(name="PONTO_FACULTATIVO")
    private Boolean pontoFacultativo;
    @Type(type="BooleanTypeSip")
    @Column(name="CONGELAR")
    private Boolean congelar;
    @Type(type="BooleanTypeSip")
    @Column(name="CONGELAR_CALC")
    private Boolean congelarCalculo;
    @Type(type="BooleanTypeSip")
    @Column(name="FAZ_PARTE_JORNADA")
    private Boolean fazParteJornada;
    @Column(name="SITUACAO")
    private Short situacao;
    @Column(name="OBS")
    private String obs;
    @Column(name="REFERENCIA")
    @NotNull
    private Integer referenciaCodigo;
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referencia;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="REFERENCIA", referencedColumnName="REFERENCIA", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private PontoMes pontoMes;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Basic(optional=false)
    @Column(name="JORNADA_DIA")
    private Integer jornadaDiaCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="JORNADA", insertable=false, updatable=false), @JoinColumn(name="JORNADA_DIA", referencedColumnName="DIA", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private JornadaDia jornadaDia;
    @Basic(optional=false)
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Jornada jornada;
    @Column(name="FASE_CALCULO")
    private CalculoPontoFase fase;
    @OneToMany(mappedBy="ponto", fetch=FetchType.LAZY)
    private List<PontoAfdBatidas> batidas;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY)
    private List<PontoEvento> eventos;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoAviso> avisos;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoMotivo> motivos;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoColunaExtra> colunasExtras;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoTipoOcorrencia> ocorrencias;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoTrabAlteracao> trabAlteracoes = new ArrayList<PontoTrabAlteracao>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="ponto", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<PontoTrabOcorrencia> trabOcorrencias = new ArrayList<PontoTrabOcorrencia>();
    @OneToMany(cascade={CascadeType.MERGE}, mappedBy="ponto", fetch=FetchType.LAZY)
    private List<PontoWeb> pontosWeb;
    @Transient
    private boolean manuallyAction = true;

    public Ponto() {
    }

    public Ponto(Builder builder) {
        if (builder != null) {
            this.setRegistro(builder.registro);
            this.setData(builder.data);
            this.setReferenciaCodigo(builder.referenciaCodigo);
            this.setPontoMes(builder.pontoMes);
            this.setCongelar(builder.congelar);
            this.setCongelarCalculo(builder.congelarCalculo);
        }
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        if (data != null) {
            PontoDiaSemana diaSemana = PontoDiaSemana.of(data);
            this.setDiaSemana(diaSemana);
        }
        this.data = data;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public void setEntrada1(String entrada1) {
        this.entrada1 = entrada1;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public void setSaida1(String saida1) {
        this.saida1 = saida1;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public void setEntrada2(String entrada2) {
        this.entrada2 = entrada2;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public void setSaida2(String saida2) {
        this.saida2 = saida2;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public void setEntrada3(String entrada3) {
        this.entrada3 = entrada3;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public void setSaida3(String saida3) {
        this.saida3 = saida3;
    }

    public Duration getHorasNormais() {
        return this.horasNormais;
    }

    public void setHorasNormais(Duration horasNormais) {
        this.horasNormais = horasNormais;
    }

    public Duration getHorasNoturnas() {
        return this.horasNoturnas;
    }

    public void setHorasNoturnas(Duration horasNoturnas) {
        this.horasNoturnas = horasNoturnas;
    }

    public PontoBatidaSituacao getEntrada1Situacao() {
        return PontoBatidaSituacao.of(this.entrada1Situacao);
    }

    public void setEntrada1Situacao(PontoBatidaSituacao entrada1Situacao) {
        this.entrada1Situacao = entrada1Situacao != null ? entrada1Situacao.getCodigo() : null;
    }

    public PontoBatidaSituacao getSaida1Situacao() {
        return PontoBatidaSituacao.of(this.saida1Situacao);
    }

    public void setSaida1Situacao(PontoBatidaSituacao saida1Situacao) {
        this.saida1Situacao = saida1Situacao != null ? saida1Situacao.getCodigo() : null;
    }

    public PontoBatidaSituacao getEntrada2Situacao() {
        return PontoBatidaSituacao.of(this.entrada2Situacao);
    }

    public void setEntrada2Situacao(PontoBatidaSituacao entrada2Situacao) {
        this.entrada2Situacao = entrada2Situacao != null ? entrada2Situacao.getCodigo() : null;
    }

    public PontoBatidaSituacao getSaida2Situacao() {
        return PontoBatidaSituacao.of(this.saida2Situacao);
    }

    public void setSaida2Situacao(PontoBatidaSituacao saida2Situacao) {
        this.saida2Situacao = saida2Situacao != null ? saida2Situacao.getCodigo() : null;
    }

    public PontoDiaSemana getDiaSemana() {
        return PontoDiaSemana.of(this.diaSemana);
    }

    public void setDiaSemana(PontoDiaSemana diaSemana) {
        this.diaSemana = diaSemana == null ? null : diaSemana.getAbreviatura();
    }

    public Duration getHorasTrabalhadas() {
        return this.horasTrabalhadas;
    }

    public void setHorasTrabalhadas(Duration horasTrabalhadas) {
        this.horasTrabalhadas = horasTrabalhadas;
    }

    public Boolean getFeriado() {
        return this.feriado;
    }

    public void setFeriado(Boolean feriado) {
        this.feriado = feriado;
    }

    public Boolean getCongelar() {
        return this.congelar;
    }

    public void setCongelar(Boolean congelar) {
        this.congelar = congelar;
    }

    public Boolean getFazParteJornada() {
        return this.fazParteJornada;
    }

    public void setFazParteJornada(Boolean fazParteJornada) {
        this.fazParteJornada = fazParteJornada;
    }

    public PontoSituacao getSituacao() {
        return PontoSituacao.of(this.situacao);
    }

    public void setSituacao(PontoSituacao situacao) {
        this.situacao = situacao != null ? Short.valueOf(situacao.getCodigo()) : null;
    }

    public List<PontoAfdBatidas> getBatidas() {
        return this.batidas;
    }

    public void setBatidas(List<PontoAfdBatidas> pontoAfdBatidasList) {
        this.batidas = pontoAfdBatidasList;
    }

    public List<PontoEvento> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<PontoEvento> eventos) {
        this.eventos = eventos;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referenciaCodigo = referencia != null ? referencia.getCodigo() : null;
        this.referencia = referencia;
    }

    public PontoMes getPontoMes() {
        return this.pontoMes;
    }

    public void setPontoMes(PontoMes pontoMes) {
        if (pontoMes != null) {
            this.entidadeCodigo = pontoMes.getPontoMesPK().getEntidade();
            this.registro = pontoMes.getPontoMesPK().getRegistro();
            this.referenciaCodigo = pontoMes.getPontoMesPK().getReferencia();
        } else {
            this.entidadeCodigo = null;
            this.registro = null;
            this.referenciaCodigo = null;
        }
        this.pontoMes = pontoMes;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.registro = trabalhador != null ? trabalhador.getTrabalhadorPK().getRegistro() : null;
        this.trabalhador = trabalhador;
    }

    public JornadaDia getJornadaDia() {
        return this.jornadaDia;
    }

    public void setJornadaDia(JornadaDia jornadaDia) {
        this.jornadaDiaCodigo = jornadaDia != null ? Integer.valueOf(jornadaDia.getJornadaDiasPK().getDia().getCodigo()) : null;
        this.jornadaDia = jornadaDia;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Integer getJornadaDiaCodigo() {
        return this.jornadaDiaCodigo;
    }

    public void setJornadaDiaCodigo(Integer jornadaDiaCodigo) {
        this.jornadaDiaCodigo = jornadaDiaCodigo;
    }

    public Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public String getEntrada4() {
        return this.entrada4;
    }

    public void setEntrada4(String entrada4) {
        this.entrada4 = entrada4;
    }

    public String getSaida4() {
        return this.saida4;
    }

    public void setSaida4(String saida4) {
        this.saida4 = saida4;
    }

    public String getEntrada5() {
        return this.entrada5;
    }

    public void setEntrada5(String entrada5) {
        this.entrada5 = entrada5;
    }

    public String getSaida5() {
        return this.saida5;
    }

    public void setSaida5(String saida5) {
        this.saida5 = saida5;
    }

    public List<PontoMotivo> getMotivos() {
        return this.motivos;
    }

    public void setMotivos(List<PontoMotivo> motivos) {
        this.motivos = motivos;
    }

    public List<PontoAviso> getAvisos() {
        return this.avisos;
    }

    public void setAvisos(List<PontoAviso> avisos) {
        this.avisos = avisos;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada != null ? jornada.getJornadaPK().getCodigo() : null;
        this.jornada = jornada;
    }

    public void addAviso(PontoAviso aviso) {
        if (this.avisos == null) {
            this.avisos = new ArrayList<PontoAviso>();
        }
        this.avisos.add(aviso);
        aviso.setPonto(this);
    }

    public boolean removeAviso(PontoAviso aviso) {
        if (this.avisos != null) {
            boolean remove = this.avisos.remove(aviso);
            if (remove) {
                aviso.setPonto(null);
            }
            return remove;
        }
        return false;
    }

    public void addPontoWeb(PontoWeb pontoWeb) {
        if (this.pontosWeb == null) {
            this.pontosWeb = new ArrayList<PontoWeb>();
        }
        this.pontosWeb.add(pontoWeb);
        pontoWeb.setPonto(this);
    }

    public Duration getHorasAulas() {
        return this.horasAulas;
    }

    public void setHorasAulas(Duration horasAulas) {
        this.horasAulas = horasAulas;
    }

    public DateTime[] getEntradas() {
        if (this.entradas == null) {
            this.loadMovimentos();
        }
        return this.entradas;
    }

    public DateTime[] getSaidas() {
        if (this.saidas == null) {
            this.loadMovimentos();
        }
        return this.saidas;
    }

    private void loadMovimentos() {
        try {
            this.entradas = new DateTime[5];
            this.saidas = new DateTime[5];
            PontoMovimento[] movimentosOfEntrada = PontoMovimento.entradas();
            PontoMovimento[] movimentosOfSaida = PontoMovimento.saidas();
            for (int index = 0; index < 5; ++index) {
                Date _data;
                String time;
                Date dataSaida;
                String entrada = movimentosOfEntrada[index].get(this);
                String saida = movimentosOfSaida[index].get(this);
                Date dataEntrada = movimentosOfEntrada[index].getData(this);
                if (dataEntrada == null) {
                    dataEntrada = this.data;
                }
                if ((dataSaida = movimentosOfSaida[index].getData(this)) == null) {
                    dataSaida = this.data;
                }
                DateTime dateTimeEntrada = TimeUtils.toDateTime((Date)dataEntrada, (String)entrada);
                DateTime dateTimeSaida = TimeUtils.toDateTime((Date)dataSaida, (String)saida);
                try {
                    String offsetSaida;
                    SimpleDateFormat offsetFormat;
                    String offsetEntrada;
                    if (dateTimeEntrada != null && dateTimeSaida != null && !(offsetEntrada = (offsetFormat = new SimpleDateFormat("X")).format(dateTimeEntrada.toDate())).equals(offsetSaida = offsetFormat.format(dateTimeSaida.toDate()))) {
                        int hourTimeZoneEnt = Integer.parseInt(offsetEntrada);
                        int hourTimeZoneSai = Integer.parseInt(offsetSaida);
                        dateTimeSaida = dateTimeSaida.withZone(DateTimeZone.forOffsetHours((int)hourTimeZoneEnt));
                        dateTimeSaida = (hourTimeZoneEnt *= -1) < (hourTimeZoneSai *= -1) ? dateTimeSaida.minusHours(hourTimeZoneSai - hourTimeZoneEnt) : dateTimeSaida.plusHours(hourTimeZoneEnt - hourTimeZoneSai);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (dateTimeEntrada != null && index > 0) {
                    for (int t = index - 1; t >= 0; --t) {
                        time = movimentosOfSaida[t].get(this);
                        _data = movimentosOfSaida[t].getData(this);
                        if (time != null) {
                            DateTime dateTime = TimeUtils.toDateTime((Date)_data, (String)time);
                            if (dateTime == null || !dateTime.isAfter((ReadableInstant)dateTimeEntrada)) break;
                            dateTimeEntrada = dateTimeEntrada.plusDays(1);
                            break;
                        }
                        time = movimentosOfEntrada[t].get(this);
                        _data = movimentosOfEntrada[t].getData(this);
                        if (time == null) continue;
                        DateTime dateTime = TimeUtils.toDateTime((Date)_data, (String)time);
                        if (dateTime == null || !dateTime.isAfter((ReadableInstant)dateTimeEntrada)) break;
                        dateTimeEntrada = dateTimeEntrada.plusDays(1);
                        break;
                    }
                }
                if (dateTimeSaida != null) {
                    for (int t = index; t >= 0; --t) {
                        if (dateTimeEntrada != null) {
                            if (!dateTimeEntrada.isAfter((ReadableInstant)dateTimeSaida)) continue;
                            dateTimeSaida = dateTimeSaida.plusDays(1);
                            continue;
                        }
                        time = movimentosOfEntrada[t].get(this);
                        _data = movimentosOfEntrada[t].getData(this);
                        if (time != null) {
                            DateTime dateTime = TimeUtils.toDateTime((Date)_data, (String)time);
                            if (dateTime == null || !dateTime.isAfter((ReadableInstant)dateTimeSaida)) break;
                            dateTimeSaida = dateTimeSaida.plusDays(1);
                            break;
                        }
                        if (t == index) continue;
                        time = movimentosOfSaida[t].get(this);
                        _data = movimentosOfSaida[t].getData(this);
                        if (time == null) continue;
                        DateTime dateTime = TimeUtils.toDateTime((Date)_data, (String)time);
                        if (dateTime == null || !dateTime.isAfter((ReadableInstant)dateTimeSaida)) break;
                        dateTimeSaida = dateTimeSaida.plusDays(1);
                        break;
                    }
                }
                this.entradas[index] = dateTimeEntrada;
                this.saidas[index] = dateTimeSaida;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Boolean getPontoFacultativo() {
        return this.pontoFacultativo;
    }

    public void setPontoFacultativo(Boolean pontoFacultativo) {
        this.pontoFacultativo = pontoFacultativo;
    }

    public Interval[] getIntervalOfEntradasAndSaidas() {
        if (this.intervalOfEntradasAndSaidas == null) {
            this.loadIntervalOfEntradasAndSaidas();
        }
        return this.intervalOfEntradasAndSaidas;
    }

    private void loadIntervalOfEntradasAndSaidas() {
        this.intervalOfEntradasAndSaidas = new Interval[5];
        for (int index = 0; index < this.getEntradas().length; ++index) {
            Interval intervalOfEntradaAndSaida = null;
            DateTime dateTimeEntrada = this.getEntradas()[index];
            DateTime dateTimeSaida = this.getSaidas()[index];
            if (dateTimeEntrada != null && dateTimeSaida != null) {
                if (dateTimeSaida.isBefore((ReadableInstant)dateTimeEntrada)) {
                    throw new ContextedRuntimeException("Batida inconsistente").addContextValue("Registro: ", (Object)this.registro).addContextValue("Data", (Object)this.data).addContextValue("Batida", (Object)dateTimeEntrada);
                }
                intervalOfEntradaAndSaida = new Interval((ReadableInstant)dateTimeEntrada, (ReadableInstant)dateTimeSaida);
            }
            this.intervalOfEntradasAndSaidas[index] = intervalOfEntradaAndSaida;
        }
    }

    public void addMotivo(PontoMotivo motivo) {
        Validate.notNull((Object)motivo);
        if (this.motivos == null) {
            this.motivos = new ArrayList<PontoMotivo>();
        }
        motivo.setPonto(this);
        this.motivos.add(motivo);
        if (!DateUtils.isSameDay((Date)this.data, (Date)motivo.getData())) {
            motivo.getCampo().setData(this, motivo.getData());
        }
    }

    public Date getDataEntrada1() {
        return this.dataEntrada1;
    }

    public void setDataEntrada1(Date dataEntrada1) {
        this.dataEntrada1 = dataEntrada1;
    }

    public Date getDataEntrada2() {
        return this.dataEntrada2;
    }

    public void setDataEntrada2(Date dataEntrada2) {
        this.dataEntrada2 = dataEntrada2;
    }

    public Date getDataEntrada3() {
        return this.dataEntrada3;
    }

    public void setDataEntrada3(Date dataEntrada3) {
        this.dataEntrada3 = dataEntrada3;
    }

    public Date getDataEntrada4() {
        return this.dataEntrada4;
    }

    public void setDataEntrada4(Date dataEntrada4) {
        this.dataEntrada4 = dataEntrada4;
    }

    public Date getDataEntrada5() {
        return this.dataEntrada5;
    }

    public void setDataEntrada5(Date dataEntrada5) {
        this.dataEntrada5 = dataEntrada5;
    }

    public Date getDataSaida1() {
        return this.dataSaida1;
    }

    public void setDataSaida1(Date dataSaida1) {
        this.dataSaida1 = dataSaida1;
    }

    public Date getDataSaida2() {
        return this.dataSaida2;
    }

    public void setDataSaida2(Date dataSaida2) {
        this.dataSaida2 = dataSaida2;
    }

    public Date getDataSaida3() {
        return this.dataSaida3;
    }

    public void setDataSaida3(Date dataSaida3) {
        this.dataSaida3 = dataSaida3;
    }

    public Date getDataSaida4() {
        return this.dataSaida4;
    }

    public void setDataSaida4(Date dataSaida4) {
        this.dataSaida4 = dataSaida4;
    }

    public Date getDataSaida5() {
        return this.dataSaida5;
    }

    public void setDataSaida5(Date dataSaida5) {
        this.dataSaida5 = dataSaida5;
    }

    public List<PontoColunaExtra> getColunasExtras() {
        return this.colunasExtras;
    }

    public List<PontoWeb> getPontosWeb() {
        return this.pontosWeb;
    }

    public void setPontosWeb(List<PontoWeb> pontosWeb) {
        this.pontosWeb = pontosWeb;
    }

    public void addTrabAlteracao(PontoTrabAlteracao alteracao) {
        if (alteracao != null) {
            if (!alteracao.getPonto().equals(this)) {
                alteracao.setPonto(this);
            }
            this.trabAlteracoes.add(alteracao);
        }
    }

    @AuditIdentifierField
    public boolean isManuallyAction() {
        return this.manuallyAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ponto ponto = (Ponto)o;
        return Objects.equals(this.codigo, ponto.codigo);
    }

    public int hashCode() {
        return Objects.hash(this.codigo);
    }

    public String toString() {
        return "Ponto{codigo=" + this.codigo + ", data=" + this.data + ", entidadeCodigo='" + this.entidadeCodigo + '\'' + ", referenciaCodigo=" + this.referenciaCodigo + ", registro='" + this.registro + '\'' + '}';
    }

    public Boolean getDsr() {
        return this.dsr;
    }

    public void setDsr(Boolean dsr) {
        this.dsr = dsr;
    }

    public void limparEntradasSaidas() {
        PontoMovimento[] values;
        for (PontoMovimento pontoMovimento : values = PontoMovimento.values()) {
            pontoMovimento.set(this, null, null);
        }
    }

    public void ordernarEntradasSaidas() {
        TreeMap<DateTime, String> batidasMap = new TreeMap<DateTime, String>();
        for (PontoMovimento movimento : PontoMovimento.values()) {
            Date dataOfPonto = SIPDateUtil.coalesce((Date[])new Date[]{movimento.getData(this), this.data});
            String hora = movimento.get(this);
            if (dataOfPonto == null || hora == null) continue;
            batidasMap.put(TimeUtils.toDateTime((Date)dataOfPonto, (String)hora), hora);
            movimento.set(this, null, null);
        }
        int i = 0;
        for (DateTime dataOfBatida : batidasMap.keySet()) {
            PontoMovimento.values()[i].set(this, (String)batidasMap.get(dataOfBatida), dataOfBatida.toDate());
            ++i;
        }
    }

    public Boolean getCongelarCalculo() {
        return this.congelarCalculo;
    }

    public void setCongelarCalculo(Boolean congelarCalculo) {
        this.congelarCalculo = congelarCalculo;
        if (congelarCalculo.booleanValue()) {
            this.congelar = true;
        }
    }

    public DateTime getLastSaida() {
        if (this.saida5 != null) {
            return TimeUtils.toDateTime((Date)this.dataSaida5, (String)this.saida5);
        }
        if (this.saida4 != null) {
            return TimeUtils.toDateTime((Date)this.dataSaida4, (String)this.saida4);
        }
        if (this.saida3 != null) {
            return TimeUtils.toDateTime((Date)this.dataSaida3, (String)this.saida3);
        }
        if (this.saida2 != null) {
            return TimeUtils.toDateTime((Date)this.dataSaida2, (String)this.saida2);
        }
        if (this.saida1 != null) {
            return TimeUtils.toDateTime((Date)this.dataSaida1, (String)this.saida1);
        }
        return null;
    }

    public DateTime getFirstEntrada() {
        if (this.entrada1 != null) {
            return TimeUtils.toDateTime((Date)this.dataEntrada1, (String)this.entrada1);
        }
        if (this.entrada2 != null) {
            return TimeUtils.toDateTime((Date)this.dataEntrada2, (String)this.entrada2);
        }
        if (this.entrada3 != null) {
            return TimeUtils.toDateTime((Date)this.dataEntrada3, (String)this.entrada3);
        }
        if (this.entrada4 != null) {
            return TimeUtils.toDateTime((Date)this.dataEntrada4, (String)this.entrada4);
        }
        if (this.entrada5 != null) {
            return TimeUtils.toDateTime((Date)this.dataEntrada5, (String)this.entrada5);
        }
        return null;
    }

    public List<Interval> getIntervalsBeteewnBatidas() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Interval interval = this.getIntervalBetweenBatidas(this.dataSaida1, this.saida1, this.dataEntrada2, this.entrada2);
        if (interval != null) {
            intervals.add(interval);
        }
        if ((interval = this.getIntervalBetweenBatidas(this.dataSaida2, this.saida2, this.dataEntrada3, this.entrada3)) != null) {
            intervals.add(interval);
        }
        if ((interval = this.getIntervalBetweenBatidas(this.dataSaida3, this.saida3, this.dataEntrada4, this.entrada4)) != null) {
            intervals.add(interval);
        }
        if ((interval = this.getIntervalBetweenBatidas(this.dataSaida4, this.saida4, this.dataEntrada5, this.entrada5)) != null) {
            intervals.add(interval);
        }
        return intervals;
    }

    private Interval getIntervalBetweenBatidas(Date dataSaida, String horaSaida, Date dataEntrada, String horaEntrada) {
        try {
            if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{horaSaida, horaEntrada})) {
                DateTime end;
                DateTime start = TimeUtils.toDateTime((Date)dataSaida, (String)horaSaida);
                if (start.isAfter((ReadableInstant)(end = TimeUtils.toDateTime((Date)dataEntrada, (String)horaEntrada)))) {
                    end = end.plusDays(1);
                }
                return new Interval((ReadableInstant)start, (ReadableInstant)end);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public CalculoPontoFase getFase() {
        if (this.fase == null) {
            return CalculoPontoFase.NAO_CALCUALDO;
        }
        return this.fase;
    }

    public void setFase(CalculoPontoFase fase) {
        this.fase = fase;
    }

    public List<Interval> getIntervals() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (Interval interval : this.getIntervalOfEntradasAndSaidas()) {
            if (interval == null) continue;
            intervals.add(interval);
        }
        return intervals;
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.entrada1) && StringUtils.isBlank((CharSequence)this.saida1) && StringUtils.isBlank((CharSequence)this.entrada2) && StringUtils.isBlank((CharSequence)this.saida2) && StringUtils.isBlank((CharSequence)this.entrada3) && StringUtils.isBlank((CharSequence)this.saida3) && StringUtils.isBlank((CharSequence)this.entrada4) && StringUtils.isBlank((CharSequence)this.saida4) && StringUtils.isBlank((CharSequence)this.entrada5) && StringUtils.isBlank((CharSequence)this.saida5);
    }

    public boolean isImpar() {
        int count = this.countBatidas();
        return count % 2 > 0;
    }

    public void setNewPonto(boolean newPonto) {
        this.newPonto = newPonto;
    }

    public boolean isNewPonto() {
        return this.newPonto;
    }

    public void removeBatida(String shora, Date data) {
        for (PontoMovimento movimento : PontoMovimento.values()) {
            if (!shora.equals(movimento.get(this)) || !data.equals(movimento.getData(this))) continue;
            movimento.set(this, null, null);
            break;
        }
    }

    public PontoEvento getPontoEventoIfExists(String evento) {
        for (PontoEvento pontoEvento : this.getEventos()) {
            if (!pontoEvento.getEventoCodigo().equals(evento)) continue;
            return pontoEvento;
        }
        return null;
    }

    public int countBatidas() {
        int count = 0;
        if (StringUtils.isNotBlank((CharSequence)this.entrada1)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.entrada2)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.entrada3)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.entrada4)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.entrada5)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.saida1)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.saida2)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.saida3)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.saida4)) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)this.saida5)) {
            ++count;
        }
        return count;
    }

    public Duration getHorasNormaisAntigas() {
        return this.horasNormaisAntigas;
    }

    public void setHorasNormaisAntigas(Duration horasNormaisAntigas) {
        this.horasNormaisAntigas = horasNormaisAntigas;
    }

    public Duration getHorasTrabalhadasAntigas() {
        return this.horasTrabalhadasAntigas;
    }

    public void setHorasTrabalhadasAntigas(Duration horasTrabalhadasAntigas) {
        this.horasTrabalhadasAntigas = horasTrabalhadasAntigas;
    }

    public Duration getHorasCompensacao() {
        return this.horasCompensacao;
    }

    public void setHorasCompensacao(Duration horasCompensacao) {
        this.horasCompensacao = horasCompensacao;
    }

    public List<PontoTrabAlteracao> getTrabAlteracoes() {
        return this.trabAlteracoes;
    }

    public List<PontoTrabOcorrencia> getTrabOcorrencias() {
        return this.trabOcorrencias;
    }

    public void setManuallyAction(boolean manuallyAction) {
        this.manuallyAction = manuallyAction;
    }

    public static class PontoSql {
        public static final String COUNT_BY_ENTIDADE_REGISTRO_DATA_BATIDAS = " SELECT COUNT(p.codigo)  FROM Ponto p  WHERE p.entidadeCodigo = :entidade  AND p.registro = :registro  AND p.data = :data  AND (p.entrada1 IS NOT NULL  OR p.saida1 IS NOT NULL  AND p.entrada2 IS NOT NULL  OR p.saida2 IS NOT NULL  AND p.entrada3 IS NOT NULL  OR p.saida3 IS NOT NULL  AND p.entrada4 IS NOT NULL  OR p.saida4 IS NOT NULL  AND p.entrada5 IS NOT NULL  OR p.saida5 IS NOT NULL) ";
        public static final String FIND_BY_TRABALHADORPK_DATA_REFERENCIA = "SELECT         p FROM         Ponto p WHERE         p.entidadeCodigo   = :entidade AND     p.data             = :data AND     p.referenciaCodigo = :referenciaCodigo AND     p.registro         = :registro ";
        public static final String FIND_BY_TRABALHADORPK_DATA = "SELECT         p FROM         Ponto p WHERE         p.entidadeCodigo   = :entidade AND     p.registro         = :registro AND     p.data             = :data ";
        public static final String UPDATE_CONGELAR_BY_CODIGO = "UPDATE Ponto p SET p.congelar = true, p.congelarCalculo = true WHERE p.codigo IN :codigos ";
    }

    public static class Builder {
        private String entidadeCodigo;
        private String registro;
        private Date data;
        private Integer referenciaCodigo;
        private PontoMes pontoMes;
        private boolean congelar;
        private boolean congelarCalculo;

        public Ponto build() {
            return new Ponto(this);
        }

        public Builder entidadeCodigo(String entidadeCodigo) {
            this.entidadeCodigo = entidadeCodigo;
            return this;
        }

        public Builder registro(String registro) {
            this.registro = registro;
            return this;
        }

        public Builder data(Date data) {
            this.data = data;
            return this;
        }

        public Builder referenciaCodigo(Integer referenciaCodigo) {
            this.referenciaCodigo = referenciaCodigo;
            return this;
        }

        public Builder pontoMes(PontoMes pontoMes) {
            this.pontoMes = pontoMes;
            return this;
        }

        public Builder congelar(boolean congelar) {
            this.congelar = congelar;
            return this;
        }

        public Builder congelarCalculo(boolean congelarCalculo) {
            this.congelarCalculo = congelarCalculo;
            return this;
        }
    }
}

