/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CargoSalario;
import br.com.fiorilli.sip.persistence.entity.PlanoCargo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PLANOCARGOSCARGO")
@Audited
public class PlanoCargosCargo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_PLANOCARGOSCARGO";
    public static final String FIND_BY_PLANO = "SELECT DISTINCT p FROM PlanoCargosCargo p LEFT JOIN FETCH p.cargo LEFT JOIN FETCH p.cargoSalarioList cs LEFT JOIN FETCH cs.salario WHERE p.planoCargoId = :planoCargoId";
    public static final String FIND_BY_PLANO_COUNT = "SELECT COALESCE(COUNT(DISTINCT p.id), 0) FROM PlanoCargosCargo p WHERE p.planoCargoId = :planoCargoId";
    public static final String IS_THERE_BY_PLANO_AND_CARGO = "SELECT CASE WHEN  COALESCE(COUNT(DISTINCT p.id), 0) > 0 THEN TRUE ELSE FALSE END FROM PlanoCargosCargo p WHERE p.planoCargoId = :planoCargoId AND p.cargo.cargoPK = :cargoPK";
    public static final String GET_MAX_SALARIO_REFERENCIA = "SELECT p.id, COUNT(s.cargoSalarioId) AS qtd FROM PlanoCargosCargo p LEFT JOIN p.cargoSalarioList s WHERE p.planoCargoId = :planoCargoId GROUP BY p.id ORDER BY qtd DESC";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDPLANOCARGOSCARGO")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="CLASSE")
    private String classe;
    @NotNull
    @Column(name="IDPLANOCARGOS", nullable=false)
    private Integer planoCargoId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDPLANOCARGOS", referencedColumnName="IDPLANOCARGOS", insertable=false, updatable=false)
    private PlanoCargo planoCargo;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @NotNull
    @Size(min=1, max=4)
    @Column(name="CARGO")
    private String cargoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Cargo cargo;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="planoCargosCargo", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<CargoSalario> cargoSalarioList;

    public PlanoCargosCargo() {
        this.cargoSalarioList = new ArrayList<CargoSalario>();
    }

    public PlanoCargosCargo(Integer id) {
        this.id = id;
    }

    public PlanoCargosCargo(Integer id, String classe) {
        this.id = id;
        this.classe = classe;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getClasse() {
        return this.classe;
    }

    public void setClasse(String classe) {
        this.classe = classe;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargos) {
        if (cargos != null) {
            this.cargoCodigo = cargos.getCargoPK().getCodigo();
            this.entidade = cargos.getCargoPK().getEntidade();
        } else {
            this.cargoCodigo = null;
            this.entidade = null;
        }
        this.cargo = cargos;
    }

    public List<CargoSalario> getCargoSalarioList() {
        return this.cargoSalarioList;
    }

    public void setCargoSalarioList(List<CargoSalario> cargosalList) {
        this.cargoSalarioList = cargosalList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlanoCargosCargo)) {
            return false;
        }
        PlanoCargosCargo other = (PlanoCargosCargo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Planocargoscargo[ id=" + this.id + " ]";
    }

    public Integer getPlanoCargoId() {
        return this.planoCargoId;
    }

    public void setPlanoCargoId(Integer planoCargoId) {
        this.planoCargoId = planoCargoId;
    }

    public PlanoCargo getPlanoCargo() {
        return this.planoCargo;
    }

    public void setPlanoCargo(PlanoCargo planoCargo) {
        this.planoCargoId = planoCargo != null ? planoCargo.getId() : null;
        this.planoCargo = planoCargo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }
}

