/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.PlanoCargoTipoSequencia;
import br.com.fiorilli.sip.persistence.entity.PlanoCargosCargo;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PLANOCARGOS")
@FilterConfigType(autoFilter=true)
@Audited
public class PlanoCargo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_ATIVOS = "SELECT p FROM PlanoCargo p where p.entidadeCodigo = :entidadeCodigo AND p.ativo = 'S' ORDER BY p.id DESC";
    public static final String GENERATOR = "GEN_PLANOCARGOS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDPLANOCARGOS")
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    private Integer id;
    @Size(max=60)
    @Column(name="NOME")
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    private String nome;
    @Type(type="BooleanTypeSip")
    @Column(name="PLANOCARGOSATIVO")
    private Boolean ativo;
    @Enumerated
    @Column(name="TipoSequencia")
    private PlanoCargoTipoSequencia tipoSequencia;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Column(name="DOCID")
    private Integer documentoDigitalID;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DOCID", referencedColumnName="IDDOCDIGITAL", insertable=false, updatable=false)
    private DocumentoDigital documentoDigital;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="planoCargo", fetch=FetchType.LAZY)
    private List<PlanoCargosCargo> planoCargosCargoList;

    public PlanoCargo() {
    }

    public PlanoCargo(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public PlanoCargoTipoSequencia getTipoSequencia() {
        return this.tipoSequencia;
    }

    public void setTipoSequencia(PlanoCargoTipoSequencia tipoSequencia) {
        this.tipoSequencia = tipoSequencia;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public Integer getDocumentoDigitalID() {
        return this.documentoDigitalID;
    }

    public void setDocumentoDigitalID(Integer docDigitalId) {
        this.documentoDigitalID = docDigitalId;
    }

    public List<PlanoCargosCargo> getPlanoCargosCargoList() {
        return this.planoCargosCargoList;
    }

    public void setPlanoCargosCargoList(List<PlanoCargosCargo> planoCargosCargoList) {
        this.planoCargosCargoList = planoCargosCargoList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlanoCargo)) {
            return false;
        }
        PlanoCargo other = (PlanoCargo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Planocargos[ id=" + this.id + " ]";
    }

    public DocumentoDigital getDocumentoDigital() {
        return this.documentoDigital;
    }

    public void setDocumentoDigital(DocumentoDigital documentoDigital) {
        this.documentoDigitalID = documentoDigital != null ? documentoDigital.getId() : null;
        this.documentoDigital = documentoDigital;
    }
}

