/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.vo.ma.tce.Cpf;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="CADPORTARIA")
@FilterConfigType(autoFilter=true, displayField=2)
@Audited
public class PessoaPortaria
implements Serializable {
    public static final String GENERATOR = "GEN_CADPORTARIA_ID";
    private static final long serialVersionUID = -8724127452483962338L;
    @SearchCodigo
    @FilterConfig(label="C\u00f3digo", order=1, inputType=FilterInputType.NUMBER, condition=FilterCondition.IGUAL)
    @Id
    @NotNull
    @Column(name="IDCADPORTARIA")
    private Integer id;
    @SearchNome
    @FilterConfig(label="Nome", order=2, condition=FilterCondition.CONTENHA)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=60)
    @Column(name="NOME")
    private String nome;
    @Cpf
    @FilterConfig(label="CPF", order=2, condition=FilterCondition.IGUAL)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=11)
    @Column(name="CPF")
    private String cpf;
    @Basic(optional=false)
    @NotNull
    @Column(name="TIPO")
    private Integer tipo;
    @Embedded
    private Endereco endereco;
    @FilterConfig(label="Telefone", condition=FilterCondition.CONTENHA)
    @Size(max=13)
    @Column(name="TELEFONE")
    private String telefone;
    @FilterConfig(label="Celular", condition=FilterCondition.CONTENHA)
    @Size(max=14)
    @Column(name="CELULAR")
    private String celular;
    @OneToMany(mappedBy="pessoaPortaria", fetch=FetchType.LAZY)
    private List<Trabalhador> trabalhador;

    public PessoaPortaria() {
    }

    public PessoaPortaria(Integer id) {
        this.id = id;
    }

    public PessoaPortaria(Integer id, String nome, String cpf, int tipo) {
        this.id = id;
        this.nome = nome;
        this.cpf = cpf;
        this.tipo = tipo;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer idcadportaria) {
        this.id = idcadportaria;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        if (telefone != null && telefone.contains("(") && telefone.contains(")") && telefone.contains("-")) {
            this.telefone = telefone.replace("(", "");
            this.telefone = this.telefone.replace(")", "");
            this.telefone = this.telefone.replace("-", "");
        } else {
            this.telefone = telefone;
        }
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        if (celular != null && celular.contains("(") && celular.contains(")") && celular.contains("-")) {
            this.celular = celular.replace("(", "");
            this.celular = this.celular.replace(")", "");
            this.celular = this.celular.replace("-", "");
        } else {
            this.celular = celular;
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PessoaPortaria)) {
            return false;
        }
        PessoaPortaria other = (PessoaPortaria)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Cadportaria[ idcadportaria=" + this.id + " ]";
    }
}

