/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PESSOA_BIOMETRIA")
public class PessoaBiometria
implements Serializable,
GenericEntity {
    @Id
    @NotNull
    private Integer id;
    @Column(name="CPF")
    @NotNull
    @Basic(optional=false)
    @Size(max=11)
    private String cpf;
    @Column(name="DEDO")
    @NotNull
    private Integer dedo;
    @Column(name="DIGITAL")
    @Size(max=6144)
    private String digital;
    @ManyToOne
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    private Pessoa pessoa;
    @OneToOne(mappedBy="biometria", fetch=FetchType.EAGER)
    private Trabalhador trabalhador;

    @Override
    public String getHashId() {
        return String.valueOf(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PessoaBiometria biometria = (PessoaBiometria)o;
        return this.id.equals(biometria.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Integer getId() {
        return this.id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public Integer getDedo() {
        return this.dedo;
    }

    public String getDigital() {
        return this.digital;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }
}

