/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CursoExtraCurricular;
import br.com.fiorilli.sip.persistence.entity.DeficienciaRais;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.EmpregoAnterior;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.EnsinoSuperior;
import br.com.fiorilli.sip.persistence.entity.EstadoCivil;
import br.com.fiorilli.sip.persistence.entity.ForcaArmada;
import br.com.fiorilli.sip.persistence.entity.Instrucao;
import br.com.fiorilli.sip.persistence.entity.Nacionalidade;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.PessoaBiometria;
import br.com.fiorilli.sip.persistence.entity.PessoaCertificado;
import br.com.fiorilli.sip.persistence.entity.Raca;
import br.com.fiorilli.sip.persistence.entity.Sexo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorIdioma;
import br.com.fiorilli.sip.persistence.entity.UF;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.swing.text.MaskFormatter;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=Pessoa.class)
@Entity
@Table(name="PESSOA")
@Audited
public class Pessoa
implements Serializable,
GenericEntity {
    public static final String FIND_BY_NOME = "SELECT p FROM Pessoa p WHERE p.nome LIKE :nome||'%' ORDER BY p.nome";
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    @Basic(optional=false)
    @Column(name="CPF")
    @Size(max=11)
    private String cpf;
    @Column(name="ALERGIAMEDICAMENTOS")
    @Size(max=90)
    private String alergiamedicamentos;
    @Column(name="ALTURA")
    private Double altura;
    @Column(name="ANOCHEGADA")
    @Size(max=4)
    private String anochegada;
    @Column(name="CATEGORIA_RESERVISTA")
    @Size(max=6)
    private String categoriaReservista;
    @Column(name="CELULAR")
    @Size(max=11)
    private String celular;
    @Column(name="CNH_CATEGORIA")
    @Size(max=5)
    private String cnhCategoria;
    @Temporal(value=TemporalType.DATE)
    @Column(name="CNH_DTEXPEDIDA")
    private Date cnhDtexpedida;
    @Temporal(value=TemporalType.DATE)
    @Column(name="CNH_DTVALIDADE")
    private Date cnhDtvalidade;
    @Column(name="CNH_NUMERO")
    @Size(max=14)
    private String cnhNumero;
    @Column(name="CNH_UF")
    @Size(max=2)
    private String cnhUf;
    @Column(name="CORCABELOS")
    @Size(max=20)
    private String corcabelos;
    @Column(name="COROLHOS")
    @Size(max=20)
    private String corolhos;
    @Column(name="CPF_MAE")
    @Size(max=11)
    private String cpfMae;
    @Column(name="CPF_PAI")
    @Size(max=11)
    private String cpfPai;
    @Column(name="CTCDATA")
    @Temporal(value=TemporalType.DATE)
    private Date ctcdata;
    @Column(name="CTCNUMERO")
    @Size(max=21)
    private String ctcnumero;
    @Column(name="CTPS")
    @Size(max=7)
    private String ctps;
    @Column(name="CUTIS")
    @Size(max=30)
    private String cutis;
    @Column(name="DATAHORA_ENTRAGA_OBITO")
    private Date datahoraEntragaObito;
    @Column(name="DATAHORA_OBITO")
    private Date datahoraObito;
    @Column(name="DEFICIENCIAFISICA")
    @Size(max=60)
    private String deficienciafisica;
    @Enumerated
    @Column(name="DEFICIENCIARAIS")
    private DeficienciaRais deficienciaRais;
    @Type(type="BooleanTypeSip")
    @Column(name="DOADOR")
    private Boolean doador;
    @Column(name="DOCUMENTO_NUMERO")
    @Size(max=15)
    private String documentoNumero;
    @Column(name="DOCUMENTO_TIPO")
    @Size(max=25)
    private String documentoTipo;
    @Column(name="DOCUMENTO_UF")
    @Size(max=2)
    private String documentoUf;
    @Column(name="DTEMISSAOCTPS")
    @Temporal(value=TemporalType.DATE)
    private Date dtemissaoctps;
    @Column(name="DTNASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dtnascimento;
    @Column(name="DTRG")
    @Temporal(value=TemporalType.DATE)
    private Date dtrg;
    @Column(name="ELEITOR")
    @Size(max=13)
    private String eleitor;
    @Column(name="EMAIL")
    @Size(max=60)
    private String email;
    @Embedded
    private Endereco endereco;
    @Column(name="ESCOLA_TECNICA")
    private Integer escolaTecnica;
    @NotNull
    @Column(name="ESTADOCIVIL")
    private Character estadoCivil;
    @Column(name="ID_CADUNICO")
    private Double idCadunico;
    @Column(name="IDCADPORTARIA")
    private Integer idcadportaria;
    @JoinColumn(name="INSTRUCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Instrucao instrucao;
    @Column(name="INSTRUCAO")
    @Size(max=2)
    private String codigoInstrucao;
    @Column(name="LETRA_SEXO")
    @Size(max=1)
    private String letraSexo;
    @Column(name="MATRICULA_OBITO_CARTORIO")
    @Size(max=32)
    private String matriculaObitoCartorio;
    @Column(name="MATRICULACEF")
    @Size(max=11)
    private String matriculacef;
    @Column(name="MESANO_MOLESTIA_GRAVE")
    @Size(max=6)
    private String mesanoMolestiaGrave;
    @Type(type="BooleanTypeSip")
    @Column(name="MOLESTIA_GRAVE")
    private Boolean molestiaGrave;
    @JoinColumn(name="NACIONALIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Nacionalidade nacionalidade;
    @Column(name="NACIONALIDADE")
    @Size(max=2)
    private String codigoNacionalidade;
    @NotNull
    @Column(name="NOME")
    @Size(max=60)
    private String nome;
    @Column(name="NOME_FONETICA")
    @Size(max=60)
    private String nomeFonetica;
    @Column(name="NOMEMAE")
    @Size(max=60)
    private String nomemae;
    @Column(name="NOMEPAI")
    @Size(max=60)
    private String nomepai;
    @Column(name="NUMEROPROFISSIONAL")
    @Size(max=15)
    private String numeroprofissional;
    @Column(name="PESO")
    private Double peso;
    @Column(name="PIS")
    @Size(max=11)
    private String pis;
    @NotNull
    @Column(name="RACA")
    private Character raca;
    @Column(name="REGISTRO_UNICO_CARTORIO")
    @Size(max=32)
    private String registroUnicoCartorio;
    @Column(name="RESERVISTA")
    @Size(max=15)
    private String reservista;
    @Column(name="RESERVISTA_ARMA")
    @Enumerated
    private ForcaArmada forcaArmada;
    @Column(name="RG")
    @Size(max=15)
    private String rg;
    @Column(name="RGORGAOEMISSOR")
    @Size(max=8)
    private String rgorgaoemissor;
    @Column(name="RGPS_ANOS")
    private Short rgpsAnos;
    @Column(name="RGPS_ANOS_PRIVADO")
    private Short rgpsAnosPrivado;
    @Column(name="RGPS_ANOS_PUBLICO")
    private Short rgpsAnosPublico;
    @Column(name="RGPS_DIAS")
    private Short rgpsDias;
    @Column(name="RGPS_DIAS_PRIVADO")
    private Short rgpsDiasPrivado;
    @Column(name="RGPS_DIAS_PUBLICO")
    private Short rgpsDiasPublico;
    @Column(name="RGPS_MESES")
    private Short rgpsMeses;
    @Column(name="RGPS_MESES_PRIVADO")
    private Short rgpsMesesPrivado;
    @Column(name="RGPS_MESES_PUBLICO")
    private Short rgpsMesesPublico;
    @Column(name="RN_CIDADE")
    @Size(max=30)
    private String rnCidade;
    @Column(name="RN_CIDADE_TCEMS")
    private Integer rnCidadeTcems;
    @Column(name="RN_FOLHA")
    @Size(max=10)
    private String rnFolha;
    @Column(name="RN_LIVRO")
    @Size(max=10)
    private String rnLivro;
    @Column(name="RN_REGISTRO_NASCIMENTO")
    @Size(max=15)
    private String rnRegistroNascimento;
    @Column(name="RN_UF")
    @Size(max=2)
    private String rnUf;
    @Column(name="RPPS_ANOS")
    private Short rppsAnos;
    @Column(name="RPPS_DIAS")
    private Short rppsDias;
    @Column(name="RPPS_MESES")
    private Short rppsMeses;
    @Column(name="SECAOELEITORAL")
    @Size(max=5)
    private String secaoeleitoral;
    @Column(name="SENHAWEB")
    @Size(max=32)
    private String senhaweb;
    @Column(name="SERIE")
    @Size(max=5)
    private String serie;
    @Column(name="SEXO")
    @Enumerated(value=EnumType.STRING)
    private Sexo sexo;
    @Column(name="SINAIS")
    @Size(max=90)
    private String sinais;
    @Column(name="SIPWEB_ULTIMO_ACESSO")
    private Timestamp sipwebUltimoAcesso;
    @Column(name="TELEFONE")
    @Size(max=11)
    private String telefone;
    @Column(name="TIPOSANGUE")
    private String tiposangue;
    @Column(name="UFCTPS")
    @Size(max=2)
    private String ufctps;
    @Column(name="UFELEITOR")
    @Size(max=2)
    private String ufeleitor;
    @Column(name="UFRG")
    @Enumerated(value=EnumType.STRING)
    private UF ufrg;
    @Column(name="USUARIO_WEB")
    @Size(max=60)
    private String usuarioWeb;
    @Column(name="ZONAELEITORAL")
    @Size(max=3)
    private String zonaeleitoral;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<CursoExtraCurricular> cursoExtraCurricular = new ArrayList<CursoExtraCurricular>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<EnsinoSuperior> ensinoSuperior = new ArrayList<EnsinoSuperior>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<EmpregoAnterior> empregoAnterior = new ArrayList<EmpregoAnterior>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<TrabalhadorIdioma> idiomas = new ArrayList<TrabalhadorIdioma>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<PessoaBiometria> biometrias = new ArrayList<PessoaBiometria>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="pessoa", fetch=FetchType.LAZY)
    private List<PericiaNova> pericias = new ArrayList<PericiaNova>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="responsavel", fetch=FetchType.LAZY)
    private List<DocumentoDigital> documentosDigitais = new ArrayList<DocumentoDigital>();
    @OneToOne(mappedBy="pessoa", cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn
    private PessoaCertificado certificado;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public Pessoa() {
    }

    public Pessoa(String cpf) {
        this.cpf = cpf;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getAlergiamedicamentos() {
        return this.alergiamedicamentos;
    }

    public void setAlergiamedicamentos(String alergiamedicamentos) {
        this.alergiamedicamentos = alergiamedicamentos;
    }

    public Double getAltura() {
        return this.altura;
    }

    public void setAltura(Double altura) {
        this.altura = altura;
    }

    public String getAnochegada() {
        return this.anochegada;
    }

    public void setAnochegada(String anochegada) {
        this.anochegada = anochegada;
    }

    public String getCategoriaReservista() {
        return this.categoriaReservista;
    }

    public void setCategoriaReservista(String categoriaReservista) {
        this.categoriaReservista = categoriaReservista;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getCnhCategoria() {
        return this.cnhCategoria;
    }

    public void setCnhCategoria(String cnhCategoria) {
        this.cnhCategoria = cnhCategoria;
    }

    public Date getCnhDtexpedida() {
        return this.cnhDtexpedida;
    }

    public void setCnhDtexpedida(Date cnhDtexpedida) {
        this.cnhDtexpedida = cnhDtexpedida;
    }

    public Date getCnhDtvalidade() {
        return this.cnhDtvalidade;
    }

    public void setCnhDtvalidade(Date cnhDtvalidade) {
        this.cnhDtvalidade = cnhDtvalidade;
    }

    public String getCnhNumero() {
        return this.cnhNumero;
    }

    public void setCnhNumero(String cnhNumero) {
        this.cnhNumero = cnhNumero;
    }

    public String getCnhUf() {
        return this.cnhUf;
    }

    public void setCnhUf(String cnhUf) {
        this.cnhUf = cnhUf;
    }

    public String getCorcabelos() {
        return this.corcabelos;
    }

    public void setCorcabelos(String corcabelos) {
        this.corcabelos = corcabelos;
    }

    public String getCorolhos() {
        return this.corolhos;
    }

    public void setCorolhos(String corolhos) {
        this.corolhos = corolhos;
    }

    public String getCpfMae() {
        return this.cpfMae;
    }

    public void setCpfMae(String cpfMae) {
        this.cpfMae = cpfMae;
    }

    public String getCpfPai() {
        return this.cpfPai;
    }

    public void setCpfPai(String cpfPai) {
        this.cpfPai = cpfPai;
    }

    public Date getCtcdata() {
        return this.ctcdata;
    }

    public void setCtcdata(Date ctcdata) {
        this.ctcdata = ctcdata;
    }

    public String getCtcnumero() {
        return this.ctcnumero;
    }

    public void setCtcnumero(String ctcnumero) {
        this.ctcnumero = ctcnumero;
    }

    public String getCtps() {
        return this.ctps;
    }

    public void setCtps(String ctps) {
        this.ctps = ctps;
    }

    public String getCutis() {
        return this.cutis;
    }

    public void setCutis(String cutis) {
        this.cutis = cutis;
    }

    public Date getDatahoraEntragaObito() {
        return this.datahoraEntragaObito;
    }

    public void setDatahoraEntragaObito(Date datahoraEntragaObito) {
        this.datahoraEntragaObito = datahoraEntragaObito;
    }

    public Date getDatahoraObito() {
        return this.datahoraObito;
    }

    public void setDatahoraObito(Date datahoraObito) {
        this.datahoraObito = datahoraObito;
    }

    public String getDeficienciafisica() {
        return this.deficienciafisica;
    }

    public void setDeficienciafisica(String deficienciafisica) {
        this.deficienciafisica = deficienciafisica;
    }

    public DeficienciaRais getDeficienciaRais() {
        return this.deficienciaRais;
    }

    public void setDeficienciaRais(DeficienciaRais deficienciaRais) {
        this.deficienciaRais = deficienciaRais;
    }

    public Boolean getDoador() {
        return this.doador;
    }

    public void setDoador(Boolean doador) {
        this.doador = doador;
    }

    public String getDocumentoNumero() {
        return this.documentoNumero;
    }

    public void setDocumentoNumero(String documentoNumero) {
        this.documentoNumero = documentoNumero;
    }

    public String getDocumentoTipo() {
        return this.documentoTipo;
    }

    public void setDocumentoTipo(String documentoTipo) {
        this.documentoTipo = documentoTipo;
    }

    public String getDocumentoUf() {
        return this.documentoUf;
    }

    public void setDocumentoUf(String documentoUf) {
        this.documentoUf = documentoUf;
    }

    public Date getDtemissaoctps() {
        return this.dtemissaoctps;
    }

    public void setDtemissaoctps(Date dtemissaoctps) {
        this.dtemissaoctps = dtemissaoctps;
    }

    public Date getDtnascimento() {
        return this.dtnascimento;
    }

    public void setDtnascimento(Date dtnascimento) {
        this.dtnascimento = dtnascimento;
    }

    public Date getDtrg() {
        return this.dtrg;
    }

    public void setDtrg(Date dtrg) {
        this.dtrg = dtrg;
    }

    public String getEleitor() {
        return this.eleitor;
    }

    public void setEleitor(String eleitor) {
        this.eleitor = eleitor;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public Integer getEscolaTecnica() {
        return this.escolaTecnica;
    }

    public void setEscolaTecnica(Integer escolaTecnica) {
        this.escolaTecnica = escolaTecnica;
    }

    public EstadoCivil getEstadoCivil() {
        if (this.estadoCivil == null) {
            return EstadoCivil.SOLTEIRO;
        }
        return EstadoCivil.of(this.estadoCivil);
    }

    public void setEstadoCivil(EstadoCivil estadocivil) {
        this.estadoCivil = estadocivil.getCodigo();
    }

    public Double getIdCadunico() {
        return this.idCadunico;
    }

    public void setIdCadunico(Double idCadunico) {
        this.idCadunico = idCadunico;
    }

    public Integer getIdcadportaria() {
        return this.idcadportaria;
    }

    public void setIdcadportaria(Integer idcadportaria) {
        this.idcadportaria = idcadportaria;
    }

    public Instrucao getInstrucao() {
        return this.instrucao;
    }

    public void setInstrucao(Instrucao instrucao) {
        this.codigoInstrucao = instrucao != null ? instrucao.getCodigo() : null;
        this.instrucao = instrucao;
    }

    public String getCodigoInstrucao() {
        return this.codigoInstrucao;
    }

    public void setCodigoInstrucao(String codigoInstrucao) {
        this.codigoInstrucao = codigoInstrucao;
    }

    public String getLetraSexo() {
        return this.letraSexo;
    }

    public void setLetraSexo(String letraSexo) {
        this.letraSexo = letraSexo;
    }

    public String getMatriculaObitoCartorio() {
        return this.matriculaObitoCartorio;
    }

    public void setMatriculaObitoCartorio(String matriculaObitoCartorio) {
        this.matriculaObitoCartorio = matriculaObitoCartorio;
    }

    public String getMatriculacef() {
        return this.matriculacef;
    }

    public void setMatriculacef(String matriculacef) {
        this.matriculacef = matriculacef;
    }

    public String getMesanoMolestiaGrave() {
        return this.mesanoMolestiaGrave;
    }

    public void setMesanoMolestiaGrave(String mesanoMolestiaGrave) {
        this.mesanoMolestiaGrave = mesanoMolestiaGrave;
    }

    public Boolean getMolestiaGrave() {
        return this.molestiaGrave;
    }

    public void setMolestiaGrave(Boolean molestiaGrave) {
        this.molestiaGrave = molestiaGrave;
    }

    public Nacionalidade getNacionalidade() {
        return this.nacionalidade;
    }

    public void setNacionalidade(Nacionalidade nacionalidade) {
        this.codigoNacionalidade = nacionalidade != null ? nacionalidade.getCodigo() : null;
        this.nacionalidade = nacionalidade;
    }

    public String getCodigoNacionalidade() {
        return this.codigoNacionalidade;
    }

    public void setCodigoNacionalidade(String codigoNacionalidade) {
        this.codigoNacionalidade = codigoNacionalidade;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeFonetica() {
        return this.nomeFonetica;
    }

    public void setNomeFonetica(String nomeFonetica) {
        this.nomeFonetica = nomeFonetica;
    }

    public String getNomemae() {
        return this.nomemae;
    }

    public void setNomemae(String nomemae) {
        this.nomemae = nomemae;
    }

    public String getNomepai() {
        return this.nomepai;
    }

    public void setNomepai(String nomepai) {
        this.nomepai = nomepai;
    }

    public String getNumeroprofissional() {
        return this.numeroprofissional;
    }

    public void setNumeroprofissional(String numeroprofissional) {
        this.numeroprofissional = numeroprofissional;
    }

    public Double getPeso() {
        return this.peso;
    }

    public void setPeso(Double peso) {
        this.peso = peso;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public Raca getRaca() {
        return Raca.of(this.raca);
    }

    public void setRaca(Raca raca) {
        this.raca = raca.getId();
    }

    public String getRegistroUnicoCartorio() {
        return this.registroUnicoCartorio;
    }

    public void setRegistroUnicoCartorio(String registroUnicoCartorio) {
        this.registroUnicoCartorio = registroUnicoCartorio;
    }

    public String getReservista() {
        return this.reservista;
    }

    public void setReservista(String reservista) {
        this.reservista = reservista;
    }

    public ForcaArmada getForcaArmada() {
        return this.forcaArmada;
    }

    public void setForcaArmada(ForcaArmada forcaArmada) {
        this.forcaArmada = forcaArmada;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getRgorgaoemissor() {
        return this.rgorgaoemissor;
    }

    public void setRgorgaoemissor(String rgorgaoemissor) {
        this.rgorgaoemissor = rgorgaoemissor;
    }

    public Short getRgpsAnos() {
        return this.rgpsAnos;
    }

    public void setRgpsAnos(Short rgpsAnos) {
        this.rgpsAnos = rgpsAnos;
    }

    public Short getRgpsAnosPrivado() {
        return this.rgpsAnosPrivado;
    }

    public void setRgpsAnosPrivado(Short rgpsAnosPrivado) {
        this.rgpsAnosPrivado = rgpsAnosPrivado;
    }

    public Short getRgpsAnosPublico() {
        return this.rgpsAnosPublico;
    }

    public void setRgpsAnosPublico(Short rgpsAnosPublico) {
        this.rgpsAnosPublico = rgpsAnosPublico;
    }

    public Short getRgpsDias() {
        return this.rgpsDias;
    }

    public void setRgpsDias(Short rgpsDias) {
        this.rgpsDias = rgpsDias;
    }

    public Short getRgpsDiasPrivado() {
        return this.rgpsDiasPrivado;
    }

    public void setRgpsDiasPrivado(Short rgpsDiasPrivado) {
        this.rgpsDiasPrivado = rgpsDiasPrivado;
    }

    public Short getRgpsDiasPublico() {
        return this.rgpsDiasPublico;
    }

    public void setRgpsDiasPublico(Short rgpsDiasPublico) {
        this.rgpsDiasPublico = rgpsDiasPublico;
    }

    public Short getRgpsMeses() {
        return this.rgpsMeses;
    }

    public void setRgpsMeses(Short rgpsMeses) {
        this.rgpsMeses = rgpsMeses;
    }

    public Short getRgpsMesesPrivado() {
        return this.rgpsMesesPrivado;
    }

    public void setRgpsMesesPrivado(Short rgpsMesesPrivado) {
        this.rgpsMesesPrivado = rgpsMesesPrivado;
    }

    public Short getRgpsMesesPublico() {
        return this.rgpsMesesPublico;
    }

    public void setRgpsMesesPublico(Short rgpsMesesPublico) {
        this.rgpsMesesPublico = rgpsMesesPublico;
    }

    public String getRnCidade() {
        return this.rnCidade;
    }

    public void setRnCidade(String rnCidade) {
        this.rnCidade = rnCidade;
    }

    public Integer getRnCidadeTcems() {
        return this.rnCidadeTcems;
    }

    public void setRnCidadeTcems(Integer rnCidadeTcems) {
        this.rnCidadeTcems = rnCidadeTcems;
    }

    public String getRnFolha() {
        return this.rnFolha;
    }

    public void setRnFolha(String rnFolha) {
        this.rnFolha = rnFolha;
    }

    public String getRnLivro() {
        return this.rnLivro;
    }

    public void setRnLivro(String rnLivro) {
        this.rnLivro = rnLivro;
    }

    public String getRnRegistroNascimento() {
        return this.rnRegistroNascimento;
    }

    public void setRnRegistroNascimento(String rnRegistroNascimento) {
        this.rnRegistroNascimento = rnRegistroNascimento;
    }

    public String getRnUf() {
        return this.rnUf;
    }

    public void setRnUf(String rnUf) {
        this.rnUf = rnUf;
    }

    public Short getRppsAnos() {
        return this.rppsAnos;
    }

    public void setRppsAnos(Short rppsAnos) {
        this.rppsAnos = rppsAnos;
    }

    public Short getRppsDias() {
        return this.rppsDias;
    }

    public void setRppsDias(Short rppsDias) {
        this.rppsDias = rppsDias;
    }

    public Short getRppsMeses() {
        return this.rppsMeses;
    }

    public void setRppsMeses(Short rppsMeses) {
        this.rppsMeses = rppsMeses;
    }

    public String getSecaoeleitoral() {
        return this.secaoeleitoral;
    }

    public void setSecaoeleitoral(String secaoeleitoral) {
        this.secaoeleitoral = secaoeleitoral;
    }

    public String getSenhaweb() {
        return this.senhaweb;
    }

    public void setSenhaweb(String senhaweb) {
        this.senhaweb = senhaweb;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    public Sexo getSexo() {
        return this.sexo;
    }

    public void setSexo(Sexo sexo) {
        this.sexo = sexo;
    }

    public String getSinais() {
        return this.sinais;
    }

    public void setSinais(String sinais) {
        this.sinais = sinais;
    }

    public Timestamp getSipwebUltimoAcesso() {
        return this.sipwebUltimoAcesso;
    }

    public void setSipwebUltimoAcesso(Timestamp sipwebUltimoAcesso) {
        this.sipwebUltimoAcesso = sipwebUltimoAcesso;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getTiposangue() {
        return this.tiposangue;
    }

    public void setTiposangue(String tiposangue) {
        this.tiposangue = tiposangue;
    }

    public String getUfctps() {
        return this.ufctps;
    }

    public void setUfctps(String ufctps) {
        this.ufctps = ufctps;
    }

    public String getUfeleitor() {
        return this.ufeleitor;
    }

    public void setUfeleitor(String ufeleitor) {
        this.ufeleitor = ufeleitor;
    }

    public UF getUfrg() {
        return this.ufrg;
    }

    public void setUfrg(UF ufrg) {
        this.ufrg = ufrg;
    }

    public String getUsuarioWeb() {
        return this.usuarioWeb;
    }

    public void setUsuarioWeb(String usuarioWeb) {
        this.usuarioWeb = usuarioWeb;
    }

    public String getZonaeleitoral() {
        return this.zonaeleitoral;
    }

    public void setZonaeleitoral(String zonaeleitoral) {
        this.zonaeleitoral = zonaeleitoral;
    }

    public List<PericiaNova> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<PericiaNova> pericias) {
        this.pericias = pericias;
    }

    public List<DocumentoDigital> getDocumentosDigitais() {
        return this.documentosDigitais;
    }

    public void setDocumentosDigitais(List<DocumentoDigital> documentosDigitais) {
        this.documentosDigitais = documentosDigitais;
    }

    public PessoaCertificado getCertificado() {
        return this.certificado;
    }

    public void setCertificado(PessoaCertificado certificado) {
        this.certificado = certificado;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cpf == null ? 0 : this.cpf.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)obj;
        return !(this.getCpf() == null ? other.getCpf() != null : !this.getCpf().equals(other.getCpf()));
    }

    public String toString() {
        return "Pessoa [cpf=" + this.cpf + "]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.cpf);
    }

    public List<CursoExtraCurricular> getCursoExtraCurricular() {
        return this.cursoExtraCurricular;
    }

    public void setCursoExtraCurricular(List<CursoExtraCurricular> cursoExtraCurricular) {
        this.cursoExtraCurricular = cursoExtraCurricular;
    }

    public List<EnsinoSuperior> getEnsinoSuperior() {
        return this.ensinoSuperior;
    }

    public void setEnsinoSuperior(List<EnsinoSuperior> ensinoSuperior) {
        this.ensinoSuperior = ensinoSuperior;
    }

    public List<EmpregoAnterior> getEmpregoAnterior() {
        return this.empregoAnterior;
    }

    public void setEmpregoAnterior(List<EmpregoAnterior> empregoAnterior) {
        this.empregoAnterior = empregoAnterior;
    }

    public List<TrabalhadorIdioma> getIdiomas() {
        return this.idiomas;
    }

    public void setIdiomas(List<TrabalhadorIdioma> idiomas) {
        this.idiomas = idiomas;
    }

    public void addCursoExtraCurricular(CursoExtraCurricular cursoExtraCurricular) {
        if (this.getCursoExtraCurricular().contains(cursoExtraCurricular)) {
            this.getCursoExtraCurricular().remove(cursoExtraCurricular);
            this.getCursoExtraCurricular().add(cursoExtraCurricular);
            cursoExtraCurricular.setPessoa(this);
        } else {
            this.getCursoExtraCurricular().add(cursoExtraCurricular);
            cursoExtraCurricular.setPessoa(this);
        }
    }

    public void removeCursoExtraCurricular(CursoExtraCurricular cursoExtraCurricular) {
        this.getCursoExtraCurricular().remove(cursoExtraCurricular);
        cursoExtraCurricular.setPessoa(null);
    }

    public void addEnsinoSuperior(EnsinoSuperior ensinoSuperior) {
        if (this.getEnsinoSuperior().contains(ensinoSuperior)) {
            this.getEnsinoSuperior().remove(ensinoSuperior);
            this.getEnsinoSuperior().add(ensinoSuperior);
            ensinoSuperior.setPessoa(this);
        } else {
            this.getEnsinoSuperior().add(ensinoSuperior);
            ensinoSuperior.setPessoa(this);
        }
    }

    public void removeEnsinoSuperior(EnsinoSuperior ensinoSuperior) {
        this.getEnsinoSuperior().remove(ensinoSuperior);
        ensinoSuperior.setPessoa(null);
    }

    public void addIdioma(TrabalhadorIdioma idioma) {
        if (this.getIdiomas().contains(idioma)) {
            this.getIdiomas().remove(idioma);
            this.getIdiomas().add(idioma);
            idioma.setPessoa(this);
        } else {
            this.getIdiomas().add(idioma);
            idioma.setPessoa(this);
        }
    }

    public void removeIdioma(TrabalhadorIdioma idioma) {
        this.getIdiomas().remove(idioma);
        idioma.setPessoa(null);
    }

    public void addEmpregoAnterior(EmpregoAnterior empregoAnterior) {
        if (this.getEmpregoAnterior().contains(empregoAnterior)) {
            this.getEmpregoAnterior().remove(empregoAnterior);
            this.getEmpregoAnterior().add(empregoAnterior);
            empregoAnterior.setPessoa(this);
        } else {
            this.getEmpregoAnterior().add(empregoAnterior);
            empregoAnterior.setPessoa(this);
        }
    }

    public void removeEmpregoAnterior(EmpregoAnterior empregoAnterior) {
        this.getEmpregoAnterior().remove(empregoAnterior);
        empregoAnterior.setPessoa(null);
    }

    public String getCpfFormatted() {
        try {
            MaskFormatter mf = new MaskFormatter("###.###.###-##");
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(this.cpf);
        }
        catch (Exception e) {
            return this.cpf;
        }
    }
}

