/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.PerfilUsuarios;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilEventoPK;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="PERMISSOES_PERFIL_EVENTOS")
@Audited
public class PermissoesPerfilEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO_NOME = "SELECT DISTINCT ev FROM PermissoesPerfilEvento pp JOIN pp.evento ev WHERE pp.permissoesPerfilEventoPK.entidade = :entidadeCodigo AND pp.permissoesPerfilEventoPK.perfil IN (:perfisId) AND (pp.evento.nome LIKE :nome) ORDER BY pp.evento.nome";
    public static final String FIND_BY_EVENTO_CODIGO = "SELECT DISTINCT ev FROM PermissoesPerfilEvento pp JOIN pp.evento ev WHERE pp.permissoesPerfilEventoPK.entidade = :entidadeCodigo AND pp.permissoesPerfilEventoPK.perfil IN (:perfisId) AND (pp.permissoesPerfilEventoPK.evento = :codigo) ORDER BY pp.permissoesPerfilEventoPK.evento ";
    public static final String FIND_PK_BY_ENTIDADE_PERFILLIST = " SELECT pfe.permissoesPerfilEventoPK  FROM PermissoesPerfilEvento pfe  WHERE pfe.permissoesPerfilEventoPK.entidade = :entidade  AND pfe.permissoesPerfilEventoPK.perfil IN :perfilList ";
    @EmbeddedId
    protected PermissoesPerfilEventoPK permissoesPerfilEventoPK;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @JoinColumn(name="PERFIL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private PerfilUsuarios perfil;

    public PermissoesPerfilEvento() {
    }

    public PermissoesPerfilEvento(PermissoesPerfilEventoPK permissoesPerfilEventoPK) {
        this.permissoesPerfilEventoPK = permissoesPerfilEventoPK;
    }

    public PermissoesPerfilEvento(int perfil, String entidade, String evento) {
        this.permissoesPerfilEventoPK = new PermissoesPerfilEventoPK(perfil, entidade, evento);
    }

    public PermissoesPerfilEventoPK getPermissoesPerfilEventoPK() {
        if (this.permissoesPerfilEventoPK == null) {
            this.permissoesPerfilEventoPK = new PermissoesPerfilEventoPK();
        }
        return this.permissoesPerfilEventoPK;
    }

    public void setPermissoesPerfilEventoPK(PermissoesPerfilEventoPK permissoesPerfilEventoPK) {
        this.permissoesPerfilEventoPK = permissoesPerfilEventoPK;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
        if (evento != null) {
            this.getPermissoesPerfilEventoPK().setEntidade(evento.getEventoPK().getEntidade());
            this.getPermissoesPerfilEventoPK().setEvento(evento.getEventoPK().getCodigo());
        } else {
            this.getPermissoesPerfilEventoPK().setEntidade(null);
            this.getPermissoesPerfilEventoPK().setEvento(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.permissoesPerfilEventoPK != null ? this.permissoesPerfilEventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PermissoesPerfilEvento)) {
            return false;
        }
        PermissoesPerfilEvento other = (PermissoesPerfilEvento)object;
        return (this.permissoesPerfilEventoPK != null || other.permissoesPerfilEventoPK == null) && (this.permissoesPerfilEventoPK == null || this.permissoesPerfilEventoPK.equals(other.permissoesPerfilEventoPK));
    }

    public String toString() {
        return "entity.PermissoesPerfilEventos[ permissoesPerfilEventoPK=" + this.permissoesPerfilEventoPK + " ]";
    }

    public PerfilUsuarios getPerfil() {
        return this.perfil;
    }

    public void setPerfil(PerfilUsuarios perfil) {
        this.perfil = perfil;
        if (perfil != null) {
            this.getPermissoesPerfilEventoPK().setPerfil(perfil.getCodigo());
        } else {
            this.getPermissoesPerfilEventoPK().setPerfil(null);
        }
    }
}

