/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PERMISSOES_LIMITE_ACESSO")
@Audited
public class PermissaoLimiteAcesso
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_PERMISSAO_LIMITE_ACESSO";
    @Id
    @Basic(optional=false)
    @NotNull
    private Integer id;
    @FilterConfig(label="Usu\u00e1rio", inputType=FilterInputType.NUMBER, order=1)
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @ManyToOne
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Usuario usuario;
    @FilterConfig(label="Data", inputType=FilterInputType.CALENDAR, order=2)
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date dataAutorizar;
    @FilterConfig(label="Hora In\u00edcio", inputType=FilterInputType.NUMBER, order=3)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HORA_INICIO")
    private String horaInicio;
    @FilterConfig(label="Hora Fim", inputType=FilterInputType.NUMBER, order=4)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=5)
    @Column(name="HORA_FIM")
    private String horaFim;
    @FilterConfig(label="Tipo", inputType=FilterInputType.NUMBER, order=5)
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @ManyToOne
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;
    @FilterConfig(label="N\u00famero", inputType=FilterInputType.NUMBER, order=6)
    @Basic(optional=false)
    @NotNull
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @FilterConfig(label="Data", inputType=FilterInputType.CALENDAR, order=7)
    @Basic(optional=false)
    @NotNull
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=512)
    @Column(name="MOTIVO")
    private String motivo;

    public PermissaoLimiteAcesso() {
    }

    public PermissaoLimiteAcesso(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getDataAutorizar() {
        return this.dataAutorizar;
    }

    public void setDataAutorizar(Date data) {
        this.dataAutorizar = data;
    }

    public String getHoraInicio() {
        return this.horaInicio;
    }

    public void setHoraInicio(String horaInicio) {
        this.horaInicio = horaInicio;
    }

    public String getHoraFim() {
        return this.horaFim;
    }

    public void setHoraFim(String horaFim) {
        this.horaFim = horaFim;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuarioCodigo = usuario != null ? usuario.getCodigo() : null;
        this.usuario = usuario;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PermissaoLimiteAcesso)) {
            return false;
        }
        PermissaoLimiteAcesso other = (PermissaoLimiteAcesso)obj;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.PermissoesLimiteAcesso [id=" + this.id + "]";
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoDocLegal) {
        this.tipoLegalCodigo = tipoDocLegal != null ? tipoDocLegal.getCodigo() : null;
        this.tipoLegal = tipoDocLegal;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

