/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cid;
import br.com.fiorilli.sip.persistence.entity.PericiaAgendaNova;
import br.com.fiorilli.sip.persistence.entity.PericiaCidPerito;
import br.com.fiorilli.sip.persistence.entity.PericiaForm;
import br.com.fiorilli.sip.persistence.entity.PericiaFormResposta;
import br.com.fiorilli.sip.persistence.entity.PericiaSima;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@Entity
@FilterConfigType(autoFilter=true)
@Table(name="PERICIA_RESPOSTA")
@Audited
public class PericiaResposta
implements Serializable {
    public static final String FIND_BY_ID = "SELECT re FROM PericiaResposta re JOIN FETCH re.periciaAgendaNova WHERE re.periciaAgendaNova.id = :id";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="IDPERICIARESPOSTA", unique=true, nullable=false)
    private Integer id;
    @Column(name="PERICIA_AGENDA", nullable=false)
    private Integer periciaAgendaNovaId;
    @OneToOne
    @JoinColumn(name="PERICIA_AGENDA", referencedColumnName="ID", insertable=false, updatable=false)
    private PericiaAgendaNova periciaAgendaNova;
    @Column(name="OBS")
    private String observacao;
    @Column(name="DIAS_AFASTAMENTO_PERICIA")
    private Integer diasAfastamento;
    @Column(name="DATA_RETORNO")
    @Temporal(value=TemporalType.DATE)
    private Date dataRetorno;
    @OneToMany(mappedBy="periciaResposta", fetch=FetchType.LAZY)
    private List<PericiaCidPerito> periciaCidPeritoList;
    @Transient
    private List<Cid> cids;
    @OneToMany(mappedBy="periciaResposta", fetch=FetchType.LAZY)
    private List<PericiaFormResposta> respostas;
    @Transient
    private List<PericiaForm> forms;
    @OneToMany(mappedBy="periciaResposta", fetch=FetchType.LAZY)
    private List<PericiaSima> periciaSimas;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getPericiaAgendaNovaId() {
        return this.periciaAgendaNovaId;
    }

    public void setPericiaAgendaNovaId(Integer periciaAgendaNovaId) {
        this.periciaAgendaNovaId = periciaAgendaNovaId;
    }

    public PericiaAgendaNova getPericiaAgendaNova() {
        return this.periciaAgendaNova;
    }

    public void setPericiaAgendaNova(PericiaAgendaNova periciaAgendaNova) {
        this.periciaAgendaNova = periciaAgendaNova;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Integer getDiasAfastamento() {
        return this.diasAfastamento;
    }

    public void setDiasAfastamento(Integer diasAfastamento) {
        this.diasAfastamento = diasAfastamento;
    }

    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    public List<PericiaCidPerito> getPericiaCidPeritoList() {
        return this.periciaCidPeritoList;
    }

    public void setPericiaCidPeritoList(List<PericiaCidPerito> periciaCidPeritoList) {
        this.periciaCidPeritoList = periciaCidPeritoList;
    }

    public List<Cid> getCids() {
        return this.cids;
    }

    public void setCids(List<Cid> cids) {
        this.cids = cids;
    }

    public List<PericiaFormResposta> getRespostas() {
        return this.respostas;
    }

    public void setRespostas(List<PericiaFormResposta> respostas) {
        this.respostas = respostas;
    }

    public List<PericiaSima> getPericiaSimas() {
        return this.periciaSimas;
    }

    public void setPericiaSimas(List<PericiaSima> periciaSimas) {
        this.periciaSimas = periciaSimas;
    }

    public List<PericiaForm> getForms() {
        return this.forms;
    }

    public void setForms(List<PericiaForm> forms) {
        this.forms = forms;
    }

    public String getCidsPeritoString(String separator) {
        ArrayList<Cid> cidList = new ArrayList<Cid>();
        if (this.periciaCidPeritoList != null) {
            for (PericiaCidPerito cidPerito : this.periciaCidPeritoList) {
                cidList.add(cidPerito.getCid());
            }
        }
        return this.cidListToString(cidList, separator, true);
    }

    public String getCidsString(String separator, boolean withDescription) {
        return this.cidListToString(this.cids, separator, withDescription);
    }

    private String cidListToString(List<Cid> cids, String separator, boolean withDescription) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (cids != null && !cids.isEmpty()) {
            for (Cid cid : cids) {
                returnList.add(withDescription ? cid.getCodigo().trim().concat(" ").concat(cid.getNome()) : cid.getCodigo().trim());
            }
        }
        return StringUtils.join(returnList, (String)separator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PericiaResposta that = (PericiaResposta)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PericiaResposta{id=" + this.id + ", periciaAgendaNovaId=" + this.periciaAgendaNovaId + ", periciaAgendaNova=" + this.periciaAgendaNova + ", observacao='" + this.observacao + '\'' + ", diasAfastamento=" + this.diasAfastamento + ", periciaCidPeritoList=" + this.periciaCidPeritoList + ", cids=" + this.cids + ", respostas=" + this.respostas + '}';
    }
}

