/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AmbienteTrabalho;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.PericiaExame;
import br.com.fiorilli.sip.persistence.entity.PericiaSituacaoTrabalhador;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.TipoExame;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="PERICIA")
@Audited
public class PericiaNova
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private Integer id;
    @Column(name="DATA_HORA", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHora;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne
    @JoinColumn(name="TIPOEXAME", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoExame tipoExame;
    @Column(name="SITUACAOTRABALHADOR")
    private Integer situacaoTrabalhador;
    @ManyToOne
    @JoinColumn(name="SITUACAOTRABALHADOR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private PericiaSituacaoTrabalhador periciaSituacaoTrabalhador;
    @Column(name="DIAS_AFAST_MEDICO")
    private Integer diasAfastamentoMedico;
    @Column(name="CPF_PESSOA")
    private String cpfPessoa;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="CPF_PESSOA", referencedColumnName="CPF", insertable=false, updatable=false)
    private Pessoa pessoa;
    @Column(name="CARGO")
    private String cargoCodigo;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Cargo cargo;
    @Column(name="LOCAL_TRABALHO")
    private String locaTrabalhoCodigo;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCAL_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private LocalTrabalho localTrabalho;
    @Column(name="AMBIENTE_TRABALHO")
    private Integer ambienteTrabalhoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="AMBIENTE_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private AmbienteTrabalho ambienteTrabalho;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="periciaNova", cascade={CascadeType.ALL})
    private List<PericiaExame> exames;
    @Column(name="MOTIVO_SITUACAOTRABALHADOR")
    @Size(max=512)
    private String motivoSituacaoTrabalhador;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public TipoExame getTipoExame() {
        return this.tipoExame;
    }

    public void setTipoExame(TipoExame tipoExame) {
        this.tipoExame = tipoExame;
    }

    public PericiaSituacaoTrabalhador getPericiaSituacaoTrabalhador() {
        return this.periciaSituacaoTrabalhador;
    }

    public Integer getSituacaoTrabalhador() {
        return this.situacaoTrabalhador;
    }

    public void setSituacaoTrabalhador(Integer situacaoTrabalhador) {
        this.situacaoTrabalhador = situacaoTrabalhador;
    }

    public void setPericiaSituacaoTrabalhador(PericiaSituacaoTrabalhador periciaSituacaoTrabalhador) {
        this.periciaSituacaoTrabalhador = periciaSituacaoTrabalhador;
        if (this.periciaSituacaoTrabalhador != null) {
            this.setSituacaoTrabalhador(periciaSituacaoTrabalhador.getId().intValue());
        }
    }

    public Integer getDiasAfastamentoMedico() {
        return this.diasAfastamentoMedico;
    }

    public void setDiasAfastamentoMedico(Integer diasAfastamentoMedico) {
        this.diasAfastamentoMedico = diasAfastamentoMedico;
    }

    public String getCpfPessoa() {
        return this.cpfPessoa;
    }

    public void setCpfPessoa(String cpfPessoa) {
        this.cpfPessoa = cpfPessoa;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    public String getLocaTrabalhoCodigo() {
        return this.locaTrabalhoCodigo;
    }

    public void setLocaTrabalhoCodigo(String locaTrabalhoCodigo) {
        this.locaTrabalhoCodigo = locaTrabalhoCodigo;
    }

    public LocalTrabalho getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalho localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public boolean onlyPessoa() {
        return this.getTrabalhador() == null && this.getPessoa() != null;
    }

    public Integer getAmbienteTrabalhoCodigo() {
        return this.ambienteTrabalhoCodigo;
    }

    public void setAmbienteTrabalhoCodigo(Integer ambienteTrabalhoCodigo) {
        this.ambienteTrabalhoCodigo = ambienteTrabalhoCodigo;
    }

    public AmbienteTrabalho getAmbienteTrabalho() {
        return this.ambienteTrabalho;
    }

    public void setAmbienteTrabalho(AmbienteTrabalho ambienteTrabalho) {
        this.ambienteTrabalho = ambienteTrabalho;
    }

    public List<PericiaExame> getExames() {
        return this.exames;
    }

    public void setExames(List<PericiaExame> exames) {
        this.exames = exames;
    }

    public String getExamesString() {
        if (this.exames != null && !this.exames.isEmpty()) {
            ArrayList<String> listExames = new ArrayList<String>();
            for (PericiaExame exame : this.exames) {
                listExames.add(String.format("%s Exame: %s", exame.getDataExame() != null ? SIPDateUtil.toString((Date)exame.getDataExame()) : "N\u00e3o informada", exame.getExame().getNome()));
            }
            if (!listExames.isEmpty()) {
                return StringUtils.join(listExames, (String)"\n");
            }
        }
        return "";
    }

    public String getMotivoSituacaoTrabalhador() {
        return this.motivoSituacaoTrabalhador;
    }

    public void setMotivoSituacaoTrabalhador(String motivoSituacaoTrabalhador) {
        this.motivoSituacaoTrabalhador = motivoSituacaoTrabalhador;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PericiaNova that = (PericiaNova)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PericiaNova{id=" + this.id + ", dataHora=" + this.dataHora + ", trabalhador=" + this.trabalhador + ", tipoExame=" + this.tipoExame + ", periciaSituacaoTrabalhador=" + this.periciaSituacaoTrabalhador + ", diasAfastamentoMedico=" + this.diasAfastamentoMedico + '}';
    }
}

