/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Pericia;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioPergunta;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioTipoOpcao;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Entity
@Table(name="PERICIA_FORM_REPOSTA")
@Audited
public class PericiaFormularioResposta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_PERICIA = "SELECT re FROM PericiaFormularioResposta re JOIN FETCH re.periciaFormularioPergunta WHERE re.pericia.id = :periciaId";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(length=512)
    private String resposta;
    @Column(length=512)
    private String obs;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PERICIA_ID", nullable=false)
    private Pericia pericia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PERGUNTA_ID", nullable=false)
    private PericiaFormularioPergunta periciaFormularioPergunta;
    @Transient
    private String perguntaEnunciado;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getResposta() {
        return this.resposta;
    }

    public void setResposta(String resposta) {
        this.resposta = resposta;
    }

    public Pericia getPericia() {
        return this.pericia;
    }

    public void setPericia(Pericia pericia) {
        this.pericia = pericia;
    }

    public PericiaFormularioPergunta getPericiaFormularioPergunta() {
        return this.periciaFormularioPergunta;
    }

    public void setPericiaFormularioPergunta(PericiaFormularioPergunta pergunta) {
        this.periciaFormularioPergunta = pergunta;
    }

    public int[] getMulpiplaResposta() {
        int[] retorno = null;
        if (this.periciaFormularioPergunta.getTipoOpcao() == PericiaFormularioTipoOpcao.MULTIPLA_ESCOLHA && StringUtils.isNotBlank((CharSequence)this.resposta)) {
            String[] opcoes = this.resposta.split(";");
            retorno = new int[opcoes.length];
            for (int i = 0; i < opcoes.length; ++i) {
                if (!NumberUtils.isNumber((String)opcoes[i])) continue;
                retorno[i] = Integer.parseInt(opcoes[i]);
            }
            return retorno;
        }
        return retorno;
    }

    public void setMulpiplaResposta(int[] mulpiplaResposta) {
        this.resposta = "";
        for (int i = 0; i < mulpiplaResposta.length; ++i) {
            this.resposta = this.resposta + ";" + mulpiplaResposta[i];
        }
        this.resposta = this.resposta.replaceFirst(";", "");
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public String getPerguntaEnunciado() {
        return this.perguntaEnunciado;
    }

    public void setPerguntaEnunciado(String perguntaEnunciado) {
        this.perguntaEnunciado = perguntaEnunciado;
    }
}

