/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.PericiaFormulario;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioPerguntaOpcao;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioTipoOpcao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PERICIA_FORM_PERGUNTA")
@Audited
public class PericiaFormularioPergunta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_FORMULARIO = "SELECT p FROM PericiaFormularioPergunta p WHERE p.periciaFormulario.id = :formularioId ORDER BY p.sequencia";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(length=512)
    private String enunciado;
    @Type(type="BooleanTypeSip")
    @Column
    private boolean texto;
    @Column(name="TIPO_OPCAO", nullable=false)
    @Enumerated
    private PericiaFormularioTipoOpcao tipoOpcao;
    @Column(nullable=false)
    private int sequencia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FORMULARIO_ID", nullable=false)
    private PericiaFormulario periciaFormulario;
    @OneToMany(mappedBy="periciaFormularioPergunta", fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, orphanRemoval=true)
    private List<PericiaFormularioPerguntaOpcao> periciaFormularioPerguntaOpcoes;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEnunciado() {
        return this.enunciado;
    }

    public void setEnunciado(String enunciado) {
        this.enunciado = enunciado;
    }

    public PericiaFormulario getPericiaFormulario() {
        return this.periciaFormulario;
    }

    public void setPericiaFormulario(PericiaFormulario periciaForm) {
        this.periciaFormulario = periciaForm;
    }

    public List<PericiaFormularioPerguntaOpcao> getPericiaFormularioPerguntaOpcoes() {
        if (this.periciaFormularioPerguntaOpcoes == null) {
            this.periciaFormularioPerguntaOpcoes = new ArrayList<PericiaFormularioPerguntaOpcao>();
        }
        return this.periciaFormularioPerguntaOpcoes;
    }

    public void setPericiaFormularioPerguntaOpcoes(List<PericiaFormularioPerguntaOpcao> periciaFormularioPerguntaOpcaos) {
        this.periciaFormularioPerguntaOpcoes = periciaFormularioPerguntaOpcaos;
    }

    public boolean getTexto() {
        return this.texto;
    }

    public void setTexto(boolean texto) {
        this.texto = texto;
    }

    public PericiaFormularioTipoOpcao getTipoOpcao() {
        return this.tipoOpcao;
    }

    public void setTipoOpcao(PericiaFormularioTipoOpcao tipoOpcao) {
        this.tipoOpcao = tipoOpcao;
    }

    public int getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(int sequencia) {
        this.sequencia = sequencia;
    }

    public PericiaFormularioPerguntaOpcao addPericiaFormularioPerguntaOpcoes(PericiaFormularioPerguntaOpcao periciaFormPerguntaOpcao) {
        this.getPericiaFormularioPerguntaOpcoes().add(periciaFormPerguntaOpcao);
        periciaFormPerguntaOpcao.setPericiaFormularioPergunta(this);
        return periciaFormPerguntaOpcao;
    }

    public PericiaFormularioPerguntaOpcao removePericiaFormularioPerguntaOpcoes(PericiaFormularioPerguntaOpcao periciaFormPerguntaOpcao) {
        this.getPericiaFormularioPerguntaOpcoes().remove(periciaFormPerguntaOpcao);
        periciaFormPerguntaOpcao.setPericiaFormularioPergunta(null);
        return periciaFormPerguntaOpcao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.periciaFormularioPerguntaOpcoes == null ? 0 : this.periciaFormularioPerguntaOpcoes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PericiaFormularioPergunta other = (PericiaFormularioPergunta)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.periciaFormularioPerguntaOpcoes == null ? other.periciaFormularioPerguntaOpcoes != null : !this.periciaFormularioPerguntaOpcoes.equals(other.periciaFormularioPerguntaOpcoes));
    }
}

