/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.Pericia;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioPergunta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="PERICIA_FORM")
@Audited
public class PericiaFormulario
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ID_FOR_EDIT = "SELECT fo FROM PericiaFormulario fo JOIN FETCH fo.periciaFormularioPerguntas pe LEFT JOIN FETCH fo.medico WHERE fo.id = :id ORDER BY pe.sequencia";
    public static final String IS_FORMULARIO_EDITAVEL = "SELECT CASE WHEN COUNT(pe.id) > 0 THEN false ELSE true END FROM PericiaFormulario fo JOIN fo.pericias pe WHERE pe.formulario.id = :formularioId";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="MEDICO_ID", insertable=false, updatable=false)
    private Integer medicoId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="MEDICO_ID")
    private Medico medico;
    @Column(nullable=false, length=50)
    private String nome;
    @OneToMany(mappedBy="periciaFormulario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PericiaFormularioPergunta> periciaFormularioPerguntas;
    @OneToMany(mappedBy="formulario", fetch=FetchType.LAZY)
    private List<Pericia> pericias;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Integer getMedicoId() {
        return this.medicoId;
    }

    public void setMedicoId(Integer medicoId) {
        this.medicoId = medicoId;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<PericiaFormularioPergunta> getPericiaFormularioPerguntas() {
        if (this.periciaFormularioPerguntas == null) {
            this.periciaFormularioPerguntas = new ArrayList<PericiaFormularioPergunta>();
        }
        return this.periciaFormularioPerguntas;
    }

    public void setPericiaFormularioPerguntas(List<PericiaFormularioPergunta> periciaFormularioPerguntas) {
        this.periciaFormularioPerguntas = periciaFormularioPerguntas;
    }

    public PericiaFormularioPergunta addPericiaFormularioPergunta(PericiaFormularioPergunta periciaFormPergunta) {
        this.getPericiaFormularioPerguntas().add(periciaFormPergunta);
        periciaFormPergunta.setPericiaFormulario(this);
        return periciaFormPergunta;
    }

    public PericiaFormularioPergunta removePericiaFormularioPergunta(PericiaFormularioPergunta periciaFormPergunta) {
        this.getPericiaFormularioPerguntas().remove(periciaFormPergunta);
        periciaFormPergunta.setPericiaFormulario(null);
        return periciaFormPergunta;
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medico = medico;
    }

    public List<Pericia> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<Pericia> pericias) {
        this.pericias = pericias;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PericiaFormulario other = (PericiaFormulario)obj;
        return this.id == other.id;
    }
}

