/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.PericiaFormPergunta;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioTipoOpcao;
import br.com.fiorilli.sip.persistence.entity.PericiaResposta;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Entity
@Table(name="PERICIA_FORM_REPOSTA")
@Audited
public class PericiaFormResposta
implements Serializable {
    public static final String FIND_BY_FORM_PERGUNTA = "SELECT re FROM PericiaFormResposta re JOIN FETCH re.periciaFormPergunta WHERE re.periciaFormPergunta.id = :periciaFormPergunta";
    public static final String FIND_BY_PERICIA_RESPOSTA = "SELECT DISTINCT re FROM PericiaFormResposta re JOIN FETCH re.periciaResposta pr JOIN FETCH re.periciaFormPergunta p WHERE pr.id = :periciaRespostaId ORDER BY p.sequencia ";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private Integer id;
    @Column
    @Size(max=512)
    private String resposta;
    @Column(name="OBS")
    @Size(max=512)
    private String observacao;
    @Column(name="PERICIARESPOSTA")
    private Integer periciaRespostaId;
    @ManyToOne
    @JoinColumn(name="PERICIARESPOSTA", referencedColumnName="IDPERICIARESPOSTA", insertable=false, updatable=false)
    private PericiaResposta periciaResposta;
    @Column(name="PERGUNTA_ID", nullable=false)
    private Integer periciaPerguntaId;
    @ManyToOne
    @JoinColumn(name="PERGUNTA_ID", referencedColumnName="IDPERGUNTA", insertable=false, updatable=false)
    private PericiaFormPergunta periciaFormPergunta;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getResposta() {
        return this.resposta;
    }

    public void setResposta(String resposta) {
        this.resposta = resposta;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public PericiaResposta getPericiaResposta() {
        return this.periciaResposta;
    }

    public void setPericiaResposta(PericiaResposta periciaResposta) {
        this.periciaResposta = periciaResposta;
    }

    public PericiaFormPergunta getPericiaFormPergunta() {
        return this.periciaFormPergunta;
    }

    public void setPericiaFormPergunta(PericiaFormPergunta periciaFormPergunta) {
        this.periciaFormPergunta = periciaFormPergunta;
    }

    public Integer getPericiaRespostaId() {
        return this.periciaRespostaId;
    }

    public void setPericiaRespostaId(Integer periciaRespostaId) {
        this.periciaRespostaId = periciaRespostaId;
    }

    public Integer getPericiaPerguntaId() {
        return this.periciaPerguntaId;
    }

    public void setPericiaPerguntaId(Integer periciaPerguntaId) {
        this.periciaPerguntaId = periciaPerguntaId;
    }

    public int[] getMultiplaResposta() {
        int[] retorno = null;
        if (this.periciaFormPergunta.getTipoOpcao() == PericiaFormularioTipoOpcao.MULTIPLA_ESCOLHA && StringUtils.isNotBlank((CharSequence)this.resposta)) {
            String[] opcoes = this.resposta.split(";");
            retorno = new int[opcoes.length];
            for (int i = 0; i < opcoes.length; ++i) {
                if (!NumberUtils.isNumber((String)opcoes[i])) continue;
                retorno[i] = Integer.parseInt(opcoes[i]);
            }
            return retorno;
        }
        return retorno;
    }

    public void setMultiplaResposta(int[] multiplaResposta) {
        this.resposta = "";
        for (int i = 0; i < multiplaResposta.length; ++i) {
            this.resposta = this.resposta + ";" + multiplaResposta[i];
        }
        this.resposta = this.resposta.replaceFirst(";", "");
    }

    public String[] getMultiplasRespostas() {
        if (this.periciaFormPergunta.getTipoOpcao() == PericiaFormularioTipoOpcao.MULTIPLA_ESCOLHA && StringUtils.isNotBlank((CharSequence)this.resposta)) {
            String[] opcoes = this.resposta.split(";");
            return opcoes;
        }
        return null;
    }

    public void setMultiplasRespostas(String[] multiplaResposta) {
        this.resposta = "";
        for (int i = 0; i < multiplaResposta.length; ++i) {
            this.resposta = this.resposta + ";" + multiplaResposta[i];
        }
        this.resposta = this.resposta.replaceFirst(";", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PericiaFormResposta that = (PericiaFormResposta)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PericiaFormResposta{id=" + this.id + ", resposta='" + this.resposta + '\'' + ", observacao='" + this.observacao + '\'' + ", periciaRespostaId=" + this.periciaRespostaId + ", periciaResposta=" + this.periciaResposta + ", periciaPerguntaId=" + this.periciaPerguntaId + ", periciaFormPergunta=" + this.periciaFormPergunta + '}';
    }
}

