/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigitalPDF;
import br.com.fiorilli.sip.persistence.entity.Exame;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.PericiaSimaExame;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(name="PERICIA_EXAME")
@Audited
public class PericiaExame
implements Serializable {
    private static final long serialversionUID = 1L;
    public static final String GENERATOR = "GEN_PERICIA_EXAME";
    public static final String FIND_BY_PERICIA = "SELECT e FROM PericiaExame e LEFT JOIN FETCH e.documentoDigitalPDF d WHERE e.periciaNova.id = :id ";
    @Id
    @Column(name="IDPERICIAEXAME", unique=true, nullable=false)
    private Integer id;
    @Column(name="PERICIA", nullable=false)
    private Integer periciaNovaId;
    @ManyToOne
    @JoinColumn(name="PERICIA", referencedColumnName="ID", insertable=false, updatable=false)
    private PericiaNova periciaNova;
    @Column(name="EXAME")
    private Long exameId;
    @ManyToOne
    @JoinColumn(name="EXAME", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Exame exame;
    @Column(name="SITUACAOEXAME")
    private String situacaoExame;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDPDF")
    private DocumentoDigitalPDF documentoDigitalPDF;
    @Column(name="IDSIMA")
    private Long periciaSimaExameId;
    @ManyToOne
    @JoinColumn(name="IDSIMA", referencedColumnName="IDSIMAEXAME", insertable=false, updatable=false)
    private PericiaSimaExame periciaSimaExame;
    @Column(name="DATA_EXAME")
    private Date dataExame;
    @Column(name="RESULTADO")
    @Size(max=20)
    private String resultado;
    @Column(name="OBS")
    private String observacao;
    @Transient
    private Boolean inseridoPeloMedico;

    public PericiaExame() {
    }

    public PericiaExame(String situacaoExame) {
        this.situacaoExame = situacaoExame;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PericiaNova getPericiaNova() {
        return this.periciaNova;
    }

    public void setPericiaNova(PericiaNova periciaNova) {
        if (periciaNova != null) {
            this.periciaNovaId = periciaNova.getId();
        }
        this.periciaNova = periciaNova;
    }

    public Exame getExame() {
        return this.exame;
    }

    public void setExame(Exame exame) {
        if (exame != null) {
            this.exameId = exame.getId();
        }
        this.exame = exame;
    }

    public String getSituacaoExame() {
        return this.situacaoExame;
    }

    public void setSituacaoExame(String situacaoExame) {
        this.situacaoExame = situacaoExame;
    }

    public DocumentoDigitalPDF getDocumentoDigitalPDF() {
        return this.documentoDigitalPDF;
    }

    public void setDocumentoDigitalPDF(DocumentoDigitalPDF documentoDigitalPDF) {
        this.documentoDigitalPDF = documentoDigitalPDF;
    }

    public PericiaSimaExame getPericiaSimaExame() {
        return this.periciaSimaExame;
    }

    public void setPericiaSimaExame(PericiaSimaExame periciaSimaExame) {
        this.periciaSimaExame = periciaSimaExame;
    }

    public Integer getPericiaNovaId() {
        return this.periciaNovaId;
    }

    public void setPericiaNovaId(Integer periciaNovaId) {
        this.periciaNovaId = periciaNovaId;
    }

    public Long getExameId() {
        return this.exameId;
    }

    public void setExameId(Long exameId) {
        this.exameId = exameId;
    }

    public Long getPericiaSimaExameId() {
        return this.periciaSimaExameId;
    }

    public void setPericiaSimaExameId(Long periciaSimaExameId) {
        this.periciaSimaExameId = periciaSimaExameId;
    }

    public Date getDataExame() {
        return this.dataExame;
    }

    public void setDataExame(Date dataExame) {
        this.dataExame = dataExame;
    }

    public String getResultado() {
        return this.resultado;
    }

    public void setResultado(String resultado) {
        this.resultado = resultado;
    }

    public Boolean getInseridoPeloMedico() {
        return this.inseridoPeloMedico != null ? this.inseridoPeloMedico : false;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setInseridoPeloMedico(Boolean inseridoPeloMedico) {
        this.inseridoPeloMedico = inseridoPeloMedico;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PericiaExame that = (PericiaExame)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PericiaExame{id=" + this.id + ", periciaNovaId=" + this.periciaNovaId + ", periciaNova=" + this.periciaNova + ", exameId=" + this.exameId + ", exame=" + this.exame + ", situacaoExame='" + this.situacaoExame + '\'' + ", documentoDigitalPDF=" + this.documentoDigitalPDF + ", periciaSimaExameId=" + this.periciaSimaExameId + ", periciaSimaExame=" + this.periciaSimaExame + '}';
    }
}

